/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.demo.swing.edit.styler.styles;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.jmo_lang.demo.swing.edit.CodeEditor;
import org.jmo_lang.demo.swing.edit.styler.styles.StyleType;

public class Styles {
    public final Style[] styles = new Style[StyleType.values().length];
    private final CodeEditor editor;

    public Styles(CodeEditor editor) {
        this.editor = editor;
    }

    public void initStyles() {
        Color blue = new Color(50, 50, 255);
        Color green = new Color(31, 122, 71);
        Color black = Color.BLACK;
        Color dark_gray = Color.DARK_GRAY;
        Color magenta = new Color(230, 50, 230);
        Color red = new Color(255, 0, 0);
        Color dark_red = new Color(164, 0, 0);
        Color yellow = new Color(150, 150, 0);
        Color orange = new Color(185, 121, 2);
        Color light_gray = Color.LIGHT_GRAY;
        Color light_blue = new Color(205, 236, 255);
        this.setStyle(StyleType.IGNORE, black);
        this.setEmpty(StyleType.LINEBREAK);
        this.setEmpty(StyleType.UNKNOWN_WORD);
        this.setBackground(StyleType.WHITESPACE_LEADING, red);
        this.setBackground(StyleType.ERROR, red);
        this.setEmpty(StyleType.TABULATOR);
        this.setStyle(StyleType.FUNCTION, black);
        this.setStyle(StyleType.CHAR, magenta);
        this.setStyle(StyleType.STRING, magenta);
        this.setStyle(StyleType.NUMBER, magenta);
        this.setStyle(StyleType.PUNCTUATION, dark_gray);
        this.setBackground(StyleType.DEFINITION, dark_gray, light_blue);
        this.setStyle(StyleType.BRACKET, Color.DARK_GRAY);
        this.setStyle(StyleType.MAGIC, dark_red, 1);
        this.setStyle(StyleType.EVENT, orange);
        this.setStyle(StyleType.TYPE, green, 1);
        this.setStyle(StyleType.CONST, blue);
        this.setStyle(StyleType.VAR, blue);
        this.setStyle(StyleType.PARSERSETTING, yellow);
        this.setStyle(StyleType.COMMENT_LINE, light_gray, 2);
        this.setStyle(StyleType.COMMENT_BLOCK, light_gray, 2);
        this.setStyle(StyleType.COMMENT_SCRIPT, light_gray, 2);
        int i = 0;
        while (i < this.styles.length) {
            if (this.styles[i] == null) {
                MOut.temp((Object[])new Object[]{"Missing style for: " + StyleType.values()[i].name()});
                Err.invalid((Object[])new Object[]{"Missing style"});
            }
            ++i;
        }
    }

    private void setEmpty(StyleType type) {
        Style style;
        this.styles[type.ordinal()] = style = this.editor.addStyle(type.name(), null);
    }

    private void setStyle(StyleType type, Color color) {
        Style style = this.editor.addStyle(type.name(), null);
        StyleConstants.setForeground(style, color);
        this.styles[type.ordinal()] = style;
    }

    private void setStyle(StyleType type, Color color, int fontStyle) {
        Style style = this.editor.addStyle(type.name(), null);
        StyleConstants.setForeground(style, color);
        if ((fontStyle & 1) != 0) {
            StyleConstants.setBold(style, true);
        }
        if ((fontStyle & 2) != 0) {
            StyleConstants.setItalic(style, true);
        }
        this.styles[type.ordinal()] = style;
    }

    private void setBackground(StyleType type, Color color) {
        Style style = this.editor.addStyle(type.name(), null);
        StyleConstants.setBackground(style, color);
        this.styles[type.ordinal()] = style;
    }

    private void setBackground(StyleType type, Color front, Color back) {
        Style style = this.editor.addStyle(type.name(), null);
        StyleConstants.setForeground(style, front);
        StyleConstants.setBackground(style, back);
        this.styles[type.ordinal()] = style;
    }

    private void setImage(StyleType type, String imgpath) {
        ImageIcon img = new ImageIcon(this.getClass().getClassLoader().getResource(imgpath));
        Style style = this.editor.addStyle(type.name(), null);
        StyleConstants.setIcon(style, img);
        this.styles[type.ordinal()] = style;
    }
}

