/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.demo.swing.edit.styler;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.StyledDocument;
import org.jmo_lang.demo.swing.edit.CodeEditor;
import org.jmo_lang.demo.swing.edit.I_Styler;
import org.jmo_lang.demo.swing.edit.styler.Scanner;
import org.jmo_lang.demo.swing.edit.styler.TextUpdate;
import org.jmo_lang.demo.swing.edit.styler.styles.Styles;

public class Styler
implements DocumentListener,
I_Styler {
    private final CodeEditor editor;
    private final StyledDocument doc;
    private final Styles styles;
    private TextUpdate lastUpdate = null;
    private final Scanner scanner;

    public Styler(CodeEditor editor) {
        this.editor = editor;
        this.doc = (StyledDocument)editor.getDocument();
        this.doc.addDocumentListener(this);
        this.styles = new Styles(editor);
        this.styles.initStyles();
        this.scanner = new Scanner(this.doc, this.styles);
    }

    @Override
    public void paintStyles() {
        if (this.lastUpdate != null) {
            this.scanner.update(this.lastUpdate);
            this.lastUpdate = null;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.lastUpdate = new TextUpdate(e.getOffset(), 0, e.getLength());
        this.editor.repaint();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.lastUpdate = new TextUpdate(e.getOffset(), e.getLength(), 0);
        this.editor.repaint();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.lastUpdate = new TextUpdate(e.getOffset(), e.getLength(), e.getLength());
        this.editor.repaint();
    }
}

