/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.demo.swing.edit.styler;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.jmo_lang.demo.swing.edit.styler.TextUpdate;
import org.jmo_lang.demo.swing.edit.styler.styles.StyleType;
import org.jmo_lang.demo.swing.edit.styler.styles.Styles;

public class Scanner {
    private final StyledDocument doc;
    private Styles styles;
    boolean scanning = false;
    private int start = 0;
    private StyleType style = StyleType.LINEBREAK;
    private boolean definition = false;

    public Scanner(StyledDocument doc, Styles styles) {
        this.doc = doc;
        this.styles = styles;
    }

    public void update(TextUpdate lastUpdate) {
        if (this.scanning) {
            MOut.temp((Object[])new Object[]{"Already scanning!"});
            return;
        }
        this.scanning = true;
        int len = this.doc.getLength();
        String text = null;
        try {
            text = this.doc.getText(0, len);
        }
        catch (BadLocationException e) {
            MOut.temp((Object[])new Object[]{"Bad location", e, 0, len});
            Err.exit((Throwable)e);
        }
        this.start = 0;
        this.style = StyleType.LINEBREAK;
        this.definition = false;
        boolean lock = false;
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '#' && this.style != StyleType.CHAR && this.style != StyleType.STRING && this.style != StyleType.COMMENT_BLOCK) {
                if (this.style != StyleType.COMMENT_LINE && i + 3 < len && text.substring(i, i + 4).equals("#**#")) {
                    this.iCheck(text, i, StyleType.COMMENT_SCRIPT);
                    i = len;
                } else {
                    this.iCheck(text, i, StyleType.COMMENT_LINE);
                }
            } else if (c == '/' && i + 1 < len && text.charAt(i + 1) == '*' && (this.style != StyleType.CHAR || this.style != StyleType.STRING)) {
                lock = true;
                this.iCheck(text, i, StyleType.COMMENT_BLOCK);
            } else if (c == '/' && i >= 1 && text.charAt(i - 1) == '*' && this.style == StyleType.COMMENT_BLOCK) {
                lock = false;
            } else if (!lock || this.style != StyleType.COMMENT_BLOCK) {
                if (c == '\n' && this.style == StyleType.COMMENT_LINE) {
                    this.iCheck(text, i, StyleType.LINEBREAK);
                } else if (this.style != StyleType.COMMENT_LINE) {
                    if (c == '\'' && this.style == StyleType.CHAR) {
                        lock = false;
                    } else if (c == '\'' && !lock && this.style != StyleType.STRING && this.style != StyleType.CHAR) {
                        this.iCheck(text, i, StyleType.CHAR);
                        lock = true;
                    } else if (lock && this.style == StyleType.CHAR) {
                        if (c == '\n') {
                            this.iCheck(text, i, StyleType.ERROR);
                            i = len;
                        }
                    } else if (c == '\"' && this.style == StyleType.STRING) {
                        lock = false;
                    } else if (c == '\"' && !lock && this.style != StyleType.STRING && this.style != StyleType.CHAR) {
                        this.iCheck(text, i, StyleType.STRING);
                        lock = true;
                    } else if (lock && this.style == StyleType.STRING) {
                        if (c == '\n') {
                            this.iCheck(text, i, StyleType.ERROR);
                            i = len;
                        }
                    } else if (c != '.' || this.style != StyleType.NUMBER) {
                        if (c >= '0' && c <= '9' && this.style != StyleType.UNKNOWN_WORD && this.style != StyleType.FUNCTION) {
                            this.iCheck(text, i, StyleType.NUMBER);
                        } else if ((c == '\n' || c == '(') && this.style == StyleType.PARSERSETTING) {
                            lock = false;
                            this.iCheck(text, i, c == '\n' ? StyleType.LINEBREAK : StyleType.BRACKET);
                        } else if (c == '>' && this.style == StyleType.LINEBREAK) {
                            this.iCheck(text, i, StyleType.PARSERSETTING);
                            lock = true;
                        } else if (!lock || this.style != StyleType.PARSERSETTING) {
                            if (c == '\n') {
                                this.iCheck(text, i, StyleType.LINEBREAK);
                                this.definition = false;
                            } else if (c == '\t') {
                                this.iCheck(text, i, StyleType.TABULATOR);
                            } else if (c == ' ' && this.style == StyleType.LINEBREAK) {
                                this.iCheck(text, i, StyleType.WHITESPACE_LEADING);
                            } else if (!(c == ' ' && this.style == StyleType.WHITESPACE_LEADING || this.style == StyleType.FUNCTION && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_'))) {
                                if (c == '.') {
                                    this.iCheck(text, i, StyleType.FUNCTION);
                                } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '@') {
                                    this.iCheck(text, i, StyleType.UNKNOWN_WORD);
                                } else if (this.style != StyleType.UNKNOWN_WORD || (c < '0' || c > '9') && c != '?' && c != '\u00bf') {
                                    if ("\u00b0$\u00a7\u20ac\u00b1".indexOf(c) > -1) {
                                        this.iCheck(text, i, StyleType.MAGIC);
                                    } else if (";,".indexOf(c) > -1) {
                                        this.iCheck(text, i, StyleType.PUNCTUATION);
                                    } else if (c == ':') {
                                        this.iCheck(text, i, StyleType.DEFINITION);
                                        if (i + 1 < len && text.charAt(i + 1) == ':') {
                                            this.definition = true;
                                        }
                                    } else if ("(){}<>[]".indexOf(c) > -1) {
                                        this.iCheck(text, i, StyleType.BRACKET);
                                    } else {
                                        this.iCheck(text, i, StyleType.IGNORE);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        this.iCheck(text, len, StyleType.LINEBREAK);
        this.scanning = false;
    }

    private void iCheck(String text, int offset, StyleType next) {
        if (this.style != next) {
            int length = offset - this.start;
            if (this.style == StyleType.UNKNOWN_WORD) {
                this.style = this.iCheckWord(text.substring(this.start, offset));
            }
            if (length > 0) {
                this.doc.setCharacterAttributes(this.start, length, this.styles.styles[this.style.ordinal()], true);
            }
            this.start = offset;
            this.style = next;
        }
    }

    private StyleType iCheckWord(String s) {
        char c0 = s.charAt(0);
        if (s.charAt(0) == '@') {
            this.definition = false;
            return StyleType.EVENT;
        }
        if (this.definition) {
            this.definition = false;
            return c0 >= 'A' && c0 <= 'Z' ? StyleType.TYPE : StyleType.FUNCTION;
        }
        switch (s.toLowerCase()) {
            case "it": 
            case "app": 
            case "cur": 
            case "jmo": 
            case "nil": 
            case "each": 
            case "func": 
            case "loop": 
            case "this": 
            case "true": 
            case "false": {
                return StyleType.MAGIC;
            }
        }
        if (s.equals(s.toUpperCase())) {
            return StyleType.CONST;
        }
        if (c0 >= 'A' && c0 <= 'Z') {
            return StyleType.TYPE;
        }
        return StyleType.VAR;
    }
}

