/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.demo.swing.edit.border;

import de.mn77.base.data.Lib_String;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.AbstractBorder;
import org.jmo_lang.demo.swing.edit.CodeEditor;

public class LineNumberedBorder
extends AbstractBorder {
    private static final long serialVersionUID = -3812536735962506061L;
    private static final Color numberColor = Color.white;
    private static final Color separatorColor = Color.black;
    private static final int offsetEditX = 10;

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        if (c instanceof CodeEditor) {
            insets.left = this.lineNumberWidth((CodeEditor)c) + 10;
        }
        return insets;
    }

    private int lineNumberWidth(CodeEditor textArea) {
        int lineCount = textArea.getLineCount() + 1;
        lineCount = Math.max(lineCount, 999);
        return textArea.getFontMetrics(textArea.getFont()).stringWidth(String.valueOf(lineCount) + " ");
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        CodeEditor jta;
        int yend;
        Rectangle clip = g.getClipBounds();
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int ybaseline = y + fm.getAscent();
        int startingLineNumber = clip.y / fontHeight + 1;
        if (ybaseline < clip.y) {
            ybaseline = y + startingLineNumber * fontHeight - (fontHeight - fm.getAscent());
        }
        if ((yend = (jta = (CodeEditor)c).getLineCount() * fontHeight) > y + height) {
            yend = y + height;
        }
        int lineWidth = this.lineNumberWidth(jta);
        int lnxstart = x;
        lnxstart = x + lineWidth;
        g.setColor(new Color(127, 127, 127));
        g.fillRect(0, 0, lineWidth, yend * lineWidth);
        g.setColor(numberColor);
        int length = ("" + jta.getLineCount() + 1).length();
        while (ybaseline < yend) {
            String label = LineNumberedBorder.padLabel(startingLineNumber, length);
            g.drawString(label, lnxstart - fm.stringWidth(label), ybaseline);
            ybaseline += fontHeight;
            ++startingLineNumber;
        }
        g.setColor(separatorColor);
        lnxstart = x + lineWidth - 1;
        g.drawLine(lnxstart, 0, lnxstart, height);
    }

    private static String padLabel(int lineNumber, int length) {
        int spaces = 3;
        return String.valueOf(Lib_String.sequence((char)' ', (long)3L)) + lineNumber + ' ';
    }
}

