/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.demo.swing.edit;

import de.mn77.base.data.Lib_String;
import de.mn77.base.error.Err;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import org.jmo_lang.demo.swing.edit.I_Styler;
import org.jmo_lang.demo.swing.edit.border.LineNumberedBorder;
import org.jmo_lang.demo.swing.edit.styler.Styler;
import org.jmo_lang.tools.Lib_Parser;

public class CodeEditor
extends JTextPane {
    private static final long serialVersionUID = -1801145479677890566L;
    public static final boolean DEMO = false;
    private static final Color LINE_HIGHLIGHT_COLOR = new Color(238, 238, 236, 255);
    private final I_Styler style = new Styler(this);
    private int caretYcurrent = 0;
    private int currentLineHeight = 17;

    public CodeEditor() {
        this.setEditable(true);
        this.setOpaque(false);
        this.setBorder(new LineNumberedBorder());
        TabStop[] tabs = new TabStop[20];
        int tabWidth = 36;
        int i = 0;
        while (i < tabs.length) {
            tabs[i] = new TabStop((i + 1) * 36, 0, 0);
            ++i;
        }
        TabSet tabset = new TabSet(tabs);
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.TabSet, tabset);
        this.setParagraphAttributes(aset, false);
        this.addCaretListener(e -> {
            int caret = this.getCaretPosition();
            if (caret >= 0) {
                try {
                    Rectangle r = this.getUI().modelToView(this, caret);
                    if (this.currentLineHeight > 0) {
                        this.repaint(0, this.caretYcurrent, this.getWidth(), this.currentLineHeight);
                    }
                    if (r != null && r.height > 0) {
                        this.caretYcurrent = r.y;
                        this.currentLineHeight = r.height;
                        this.repaint(0, r.y, this.getWidth(), r.height);
                    } else {
                        this.currentLineHeight = -1;
                    }
                }
                catch (BadLocationException err) {
                    Err.show((Throwable)err);
                }
            }
        });
        final CodeEditor t = this;
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    return;
                }
                String text = t.getText();
                int base = t.getCaretPosition();
                int startBefore = base - 2;
                while (startBefore > 0 && text.charAt(startBefore) != '\n') {
                    --startBefore;
                }
                String lineBefore = text.substring(startBefore + 1, base - 1);
                int indent = Lib_Parser.getDepth((String)lineBefore);
                if (indent > 0) {
                    try {
                        t.getDocument().insertString(base, Lib_String.sequence((char)'\t', (long)indent), null);
                    }
                    catch (BadLocationException err) {
                        Err.show((Throwable)err);
                    }
                }
            }
        });
    }

    public int getLineCount() {
        return this.getDocument().getDefaultRootElement().getElementCount();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.currentLineHeight > 0) {
            g.setColor(LINE_HIGHLIGHT_COLOR);
            g.fillRect(0, this.caretYcurrent, this.getWidth(), this.currentLineHeight);
        }
        super.paintComponent(g);
        if (this.style != null) {
            this.style.paintStyles();
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getUI().getPreferredSize(this);
    }
}

