/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.demo.swing;

import de.mn77.base.data.group.Group4;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.event.Procedure;
import de.mn77.base.sys.Sys;
import de.mn77.base.thread.A_ParallelProcess;
import java.awt.KeyboardFocusManager;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jmo_lang.demo.swing.MainPanel;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.struct.App;

public class JMoSwingDemo {
    private App runningApp = null;
    private Thread runningThread = null;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new JMoSwingDemo().createAndShowGUI());
    }

    private void createAndShowGUI() {
        Parser_App parser = new Parser_App();
        String version = "JM\u00b0  " + parser.getVersionString(false, true);
        JFrame frame = new JFrame(version);
        frame.setDefaultCloseOperation(3);
        MainPanel panel = new MainPanel(g -> this.execute(parser, (Group4<String, JTextArea, JTextField, Procedure>)g), () -> this.reset());
        frame.add(panel);
        frame.pack();
        frame.setSize(1100, 500);
        frame.setVisible(true);
        ImageIcon img = new ImageIcon(this.getClass().getClassLoader().getResource("org/jmo_lang/icon256.png"));
        frame.setIconImage(img.getImage());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            if (402 != e.getID()) {
                return false;
            }
            if (e.getKeyCode() == 81 && e.getModifiers() == 2) {
                frame.dispose();
            }
            if (e.getKeyCode() == 10 && e.getModifiers() > 0) {
                panel.execute();
            }
            return false;
        });
    }

    private void execute(final Parser_App parser, final Group4<String, JTextArea, JTextField, Procedure> g) {
        final String sourcecode = (String)g.o1;
        if (this.runningThread != null) {
            return;
        }
        this.runningThread = new A_ParallelProcess(){

            protected void process() {
                if (JMoSwingDemo.this.runningApp != null) {
                    return;
                }
                App app = null;
                try {
                    app = parser.parseText(">strictWebstart");
                    parser.parseText(app, sourcecode);
                    JMoSwingDemo.this.runningApp = app;
                    app.setOutputBuffer();
                    String result = app.exec(null);
                    if (app.toBeTerminated()) {
                        ((JTextField)g.o3).setText("");
                        ((JTextArea)g.o2).setText("");
                    } else {
                        String text = app.getOutput();
                        ((JTextArea)g.o2).setText(text);
                        ((JTextField)g.o3).setText(result);
                    }
                }
                catch (Err_FileSys e) {
                    ((JTextArea)g.o2).setText(e.toString());
                    Err.show((Throwable)e);
                }
                catch (ErrorBaseDebug ce) {
                    if (app != null && app.toBeTerminated()) {
                        ((JTextField)g.o3).setText("");
                        ((JTextArea)g.o2).setText("");
                    }
                    ((JTextArea)g.o2).setText(ce.toInfo());
                    Err.show((Throwable)ce);
                }
            }

            protected void onFinished() {
                ((Procedure)g.o4).execute();
                JMoSwingDemo.this.runningApp = null;
                JMoSwingDemo.this.runningThread = null;
            }
        };
    }

    private void reset() {
        if (this.runningApp != null) {
            this.runningApp.terminate();
        }
        Sys.sleep((int)100);
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
        Sys.sleep((int)100);
        try {
            if (this.runningThread != null) {
                this.runningThread.stop();
            }
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }
}

