/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.error.Err;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.mc.MC_APP;
import org.jmo_lang.object.pseudo.mc.MC_JMO;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.tools.Lib_Convert;

public class Lib_Type {
    public static Class<?> getType(CallRuntime cr, I_Object o) {
        o = Lib_Convert.getValue(cr, o);
        return o.getClass();
    }

    public static boolean typeIs(CallRuntime cr, I_Object o, Class<?> ... ta) {
        o = Lib_Convert.getValue(cr, o);
        Class<?> typ = o.getClass();
        Class<?>[] classArray = ta;
        int n = ta.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            if (t.isAssignableFrom(typ)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getName(I_Object obj) {
        return Lib_Type.getName(obj.getClass(), obj);
    }

    public static String getName(Class<?> objClass, I_Object obj) {
        Err.ifNull(objClass);
        if (objClass == App.class) {
            return "Root";
        }
        if (objClass == Function.class) {
            return "_FUNC";
        }
        if (objClass == Handle_Loop.class) {
            return "_LOOP";
        }
        if (objClass == MC_JMO.class || objClass == MC_APP.class) {
            return obj.toString();
        }
        String s = objClass.getSimpleName();
        if (objClass == Instance.class) {
            String string = s = obj == null ? Instance.class.getSimpleName() : ((Instance)obj).getType().getName();
        }
        if (objClass == Var.class) {
            s = "Var";
        }
        if (objClass == Const.class) {
            s = "Const";
        }
        if (s.startsWith("JMo_")) {
            return s.substring(4);
        }
        if (s.startsWith("A_")) {
            return s.substring(2);
        }
        if (s.equals("I_AtomicValue")) {
            return "Atomic";
        }
        if (s.startsWith("I_")) {
            Err.todo(s);
        }
        return s;
    }

    public static boolean isInstanceOf(I_Object o, String type) {
        String[] stringArray = o.getTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (t.equals(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String typesToString(I_Object obj) {
        String[] types = obj.getTypes();
        StringBuilder sb = new StringBuilder();
        if (types.length > 1) {
            sb.append("(");
        }
        int tc = 0;
        while (tc < types.length) {
            String type = types[tc];
            if (tc != 0) {
                sb.append(", ");
            }
            sb.append(type);
            ++tc;
        }
        if (types.length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }
}

