/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.Parser_Script;

public class Lib_Namespace {
    public static String parsetimeCheckTypename(String newName, Parser_Script parser) {
        return Lib_Namespace.checkTypeValidity(newName, true, parser, parser.gDebugInfo());
    }

    public static String parsetimeCheckTypename(String newName, Parser_Script parser, DebugInfo debug) {
        return Lib_Namespace.checkTypeValidity(newName, true, parser, debug);
    }

    public static void checkTypeValidity(String typeName, DebugInfo debug) {
        Lib_Namespace.checkTypeValidity(typeName, false, null, debug);
    }

    private static String checkTypeValidity(String typeName, boolean addNamespace, Parser_Script parser, DebugInfo debug) {
        char cl;
        boolean parsetime;
        boolean bl = parsetime = parser != null;
        if (typeName.length() == 0) {
            Lib_Namespace.invalidTypename("Type can't be empty!", parsetime, debug);
        }
        if ((cl = typeName.charAt(typeName.length() - 1)) == '_') {
            Lib_Namespace.invalidTypename("Type can't end with underline! Got: " + typeName, parsetime, debug);
        }
        int underlines = 0;
        boolean nextCapital = true;
        char[] cArray = typeName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char cx = cArray[n2];
            if (nextCapital && (cx < 'A' || cx > 'Z')) {
                Lib_Namespace.invalidTypename("Type must start with a capital letter! Got: " + typeName, parsetime, debug);
            }
            nextCapital = false;
            if (!(cx >= 'A' && cx <= 'Z' || cx >= 'a' && cx <= 'z' || cx >= '0' && cx <= '9')) {
                if (cx == '_') {
                    ++underlines;
                    nextCapital = true;
                } else {
                    Lib_Namespace.invalidTypename("Invalid char '" + cx + "'! Got: " + typeName, parsetime, debug);
                }
            }
            ++n2;
        }
        if (underlines > 1) {
            Lib_Namespace.invalidTypename("Type can't have multiple underlines and namespaces: " + typeName, parsetime, debug);
        }
        if (addNamespace) {
            String currentNamespace;
            String string = currentNamespace = parsetime ? parser.getCurrentNamespace() : null;
            if (underlines == 0 && currentNamespace != null) {
                return String.valueOf(currentNamespace) + '_' + typeName;
            }
        }
        return typeName;
    }

    private static void invalidTypename(String detail, boolean parsetime, DebugInfo debug) {
        if (parsetime) {
            throw new ParseError("Invalid Type-Name!", detail, debug);
        }
        throw new ExecError("Invalid Type-Name!", detail, debug);
    }
}

