/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.struct.runtime.CallRuntime;

public class Lib_Error {
    public static void ifNot(CallRuntime cr, int shouldBe, int value, String title) {
        if (value != shouldBe) {
            throw new ExecError(cr, "Invalid " + title, "Got: " + value + ", should be: " + shouldBe);
        }
    }

    public static void ifNotBetween(CallRuntime cr, int min, int max, int value, String title) {
        if (max == 0) {
            throw new ExecError(cr, "Value out of bounds, invalid " + title, "Size = 0, can't get " + title + ": " + value);
        }
        if (min > max) {
            Err.forbidden(min, max, value);
        }
        if (value < min || value > max) {
            String s = min < max ? String.valueOf(min) + "-" + max : "" + min;
            throw new ExecError(cr, "Value out of bounds, invalid " + title, "Got: " + value + ", allowed: " + s);
        }
    }

    public static void ifTooHigh(CallRuntime cr, int max, int value) {
        if (value > max) {
            throw new ExecError(cr, "Value too big", "Got: " + value + "  Maximum is: " + max);
        }
    }

    public static void ifTooLow(CallRuntime cr, int min, int value) {
        if (value < min) {
            throw new ExecError(cr, "Value too small", "Got: " + value + "  Minimum is: " + min);
        }
    }

    public static CodeError notAllowed(CallRuntime cr) {
        throw new CodeError(cr, "Not allowed!", "You can't run this function!");
    }

    public static void ifEmpty(CallRuntime cr, int size, String type) {
        if (size == 0) {
            throw new ExecError(cr, "Can't access position", String.valueOf(type) + " is empty");
        }
    }

    public static void ifPars(int got, int min, int max, CallRuntime cr) {
        if (!Lib_Math.isBetween(got, min, max)) {
            String want = min != max ? String.valueOf(min) + "-" + max : "" + min;
            throw new CodeError(cr, "Invalid amount of parameters", "Got " + got + ", want " + want);
        }
    }
}

