/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.type.Lib_Class;
import de.mn77.base.error.Err;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.JarInputStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jmo_lang.dev.JMo_Object;
import org.jmo_lang.object.I_Object;

public class ClassFinder {
    private static ClassFinder singleton = null;
    private final HashMap<String, Class<?>> classes;
    private final ArrayList<String> imports = new ArrayList();

    public static ClassFinder getInstance(boolean debug) {
        if (singleton == null) {
            singleton = new ClassFinder(debug);
        }
        return singleton;
    }

    private ClassFinder(boolean debug) {
        try {
            this.classes = this.iGetJMoClasses(debug);
        }
        catch (Exception e) {
            throw Err.exit(e);
        }
        this.imports.add("java.lang");
        this.imports.add("java.util");
    }

    public Class<?> getJMoClass(String name) {
        return this.classes.get(name);
    }

    public Collection<Class<?>> getJMoClasses() {
        return this.classes.values();
    }

    public Class<?> getJavaClass(String name) {
        return Lib_Class.getClassByName(this.imports, name);
    }

    public void addImport(String path) {
        if (path.endsWith("*")) {
            if ((path = path.substring(0, path.length() - 1)).endsWith(".")) {
                path = path.substring(0, path.length() - 1);
            }
            path = path.replace('.', '/');
            this.iSearchPackages(path).forEach(s -> {
                s = s.replace("/", ".");
                s = s.substring(0, s.length() - 1);
                this.imports.add((String)s);
            });
        } else {
            this.imports.add(path);
        }
    }

    private void iSearchJar(Set<String> set, URL url, String prefix) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JarInputStream jin = new JarInputStream(Files.newInputStream(Paths.get(url.toURI()), new OpenOption[0]));){
                ZipEntry ze;
                while ((ze = jin.getNextEntry()) != null) {
                    if (!ze.isDirectory() || !ze.getName().startsWith(prefix)) continue;
                    set.add(ze.getName());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Err.show(e);
        }
    }

    private Set<String> iSearchPackages(String prefix) {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        HashSet<String> set = new HashSet<String>();
        URL[] uRLArray = sysloader.getURLs();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            String urlString = url.toString().toLowerCase();
            if (urlString.endsWith("jar") || urlString.endsWith("zip")) {
                this.iSearchJar(set, url, prefix);
            }
            ++n2;
        }
        return set;
    }

    private HashMap<String, Class<?>> iGetJMoClasses(boolean debug) throws Exception {
        ArrayList classList = new ArrayList();
        try {
            CodeSource src = ClassFinder.class.getProtectionDomain().getCodeSource();
            Consumer<String> add = line -> {
                String filename = line.substring(line.lastIndexOf(47) + 1);
                if (filename.endsWith(".class") && !filename.contains("$") && filename.startsWith("JMo_")) {
                    try {
                        Class<?> c = Class.forName(this.iPathConvert((String)line));
                        if (I_Object.class.isAssignableFrom(c) || JMo_Object.class.isAssignableFrom(c)) {
                            classList.add(c);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        Err.show(e);
                        return;
                    }
                    catch (NoClassDefFoundError e) {
                        if (debug) {
                            Err.show(e, "Missing Jar-Library");
                        }
                        return;
                    }
                }
            };
            if (src.getLocation().toString().toLowerCase().endsWith(".jar")) {
                this.searchClassesFromJar(add);
            } else {
                this.searchClassesDirect(add);
            }
        }
        catch (Exception e) {
            Err.exit(e);
        }
        HashMap map = new HashMap();
        for (Class c : classList) {
            map.put(c.getSimpleName(), c);
        }
        return map;
    }

    private String iPathConvert(String line) {
        int start = 0;
        if (line.startsWith("/")) {
            start = 1;
        }
        line = line.replace('/', '.');
        return line.substring(start, line.lastIndexOf(46));
    }

    private void searchClassesDirect(Consumer<String> add) throws IOException, URISyntaxException, ClassNotFoundException {
        Enumeration<URL> eu = ClassFinder.class.getClassLoader().getResources("");
        while (eu.hasMoreElements()) {
            URI uri = eu.nextElement().toURI();
            Path myPath = Paths.get(uri);
            String base = myPath.toString();
            Stream<Path> walk = Files.walk(myPath, Integer.MAX_VALUE, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                String line = ((Path)it.next()).toString();
                line = line.substring(base.length());
                add.accept(line);
            }
            walk.close();
        }
    }

    private void searchClassesFromJar(Consumer<String> add) throws IOException, ClassNotFoundException {
        String classpath = System.getProperty("java.class.path");
        String[] paths = classpath.split(System.getProperty("path.separator"));
        ArrayList<String> scanned = new ArrayList<String>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (scanned.indexOf(path) < 0) {
                scanned.add(path);
                File file = new File(path);
                if (file.isFile()) {
                    ZipEntry e;
                    FileInputStream is = new FileInputStream(file);
                    ZipInputStream zip = new ZipInputStream(is);
                    while ((e = zip.getNextEntry()) != null) {
                        add.accept(e.getName());
                    }
                    zip.close();
                }
            }
            ++n2;
        }
    }
}

