/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.test.lib;

import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.debug.DEBUG_LEVEL;
import de.mn77.base.debug.Stopwatch;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.cmd.SysCmd;
import de.mn77.base.sys.cmd.SysCmd_Data;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.base.sys.file.MDir;
import de.mn77.base.sys.file.MFile;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ErrorBase;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.struct.App;

public class AutoTest {
    private final boolean STOP_AT_FAIL;
    private final boolean HINTS;
    private final DEBUG_LEVEL DEBUG;

    public AutoTest(boolean stopAtFail, boolean hints2, DEBUG_LEVEL debug2) {
        this.STOP_AT_FAIL = stopAtFail;
        this.HINTS = hints2;
        this.DEBUG = debug2;
    }

    public void testDir(String s) {
        MOut.setDebug(this.DEBUG);
        try {
            Stopwatch clock = new Stopwatch();
            this.iTestDir(s);
            clock.print();
        }
        catch (Throwable t) {
            Err.exit(t);
        }
    }

    public void iTestDir(String s) throws Exception {
        MDir o = new MDir(s);
        I_List<I_File> list = o.contentFilesWithSuffix("jmo");
        list.sort(new int[0]);
        MOut.debug(list);
        int fails = 0;
        ArrayList<String> failed = new ArrayList<String>();
        Stopwatch uhr = new Stopwatch();
        for (I_File d : list) {
            boolean tr = this.test(d.getPathAbsolute());
            if (tr) continue;
            ++fails;
            failed.add(d.getName());
        }
        String stop = uhr.gStringMillisec();
        if (fails > 0) {
            MOut.text("\n--- Failed ---");
            for (String f : failed) {
                MOut.text(f);
            }
        }
        String result = "\nTesttime: " + stop + "\n" + "Result  : " + (fails == 0 ? "Passed" : "FAILED (" + fails + ")");
        MOut.text(result);
    }

    public void testOne(String testdir, String filename) {
        MOut.setDebug(this.DEBUG);
        try {
            Stopwatch clock = new Stopwatch();
            boolean tr = this.test(String.valueOf(testdir) + Sys.getSeperatorDir() + filename);
            if (!tr) {
                MOut.text("\n--- Failed ---");
            }
            clock.print();
        }
        catch (Throwable t) {
            Err.exit(t);
        }
    }

    private boolean test(String s) throws Exception {
        I_File output_saved;
        MFile datei = new MFile(s);
        MFile output_test = new MFile("/tmp/jmo-test.txt");
        if (output_test.exists()) {
            output_test.delete();
        }
        MOut.text("===== " + s);
        MFile file = new MFile("/tmp/jmo-test.txt");
        Parser_App parser = new Parser_App();
        App app = parser.parseText("> setOutputFile(\"/tmp/jmo-test.txt\")\n> lazyErrors");
        boolean parseError = false;
        try {
            parser.parseFile(app, datei);
        }
        catch (CodeError | ParseError err) {
            parseError = true;
            Lib_TextFile.addRow(file, err.toInfo());
        }
        if (!parseError) {
            if (this.HINTS) {
                app.setGenHints("/tmp/jmo-types.csv", "/tmp/jmo-hints.csv");
                app.exec(null);
                app.hintsSave();
                app.hintsShow();
            } else {
                try {
                    app.exec(null);
                }
                catch (ErrorBaseDebug eb) {
                    Lib_TextFile.addRow(file, eb.toInfo());
                }
                catch (ErrorBase eb) {
                    if (this.STOP_AT_FAIL) {
                        Err.exit(eb);
                    } else {
                        Err.show(eb);
                    }
                    return false;
                }
            }
        }
        if (!(output_saved = datei.getDirectory().dirFlex("output").fileFlex(datei.getName(), "txt")).exists() && output_test.exists()) {
            output_test.copy(output_saved);
        }
        if (!output_test.exists()) {
            return true;
        }
        String befehl = "diff " + output_saved.getPathAbsolute() + " " + output_test.getPathAbsolute();
        SysCmd_Data sysInfo = new SysCmd_Data();
        sysInfo.startDir.set(output_test.getDirectory());
        sysInfo.command.set(befehl);
        sysInfo.wait.set(true);
        boolean ok = true;
        try {
            new SysCmd().start(sysInfo);
        }
        catch (Exception f) {
            ok = false;
        }
        if (ok) {
            MOut.text("Check: OK");
            return true;
        }
        MOut.text("Check: FAIL");
        if (this.STOP_AT_FAIL) {
            String befehl2 = "kdiff3 " + output_saved.getPathAbsolute() + " " + output_test.getPathAbsolute();
            SysCmd_Data sysInfo2 = new SysCmd_Data();
            sysInfo2.startDir.set(output_test.getDirectory());
            sysInfo2.command.set(befehl2);
            sysInfo2.wait.set(false);
            try {
                new SysCmd().start(sysInfo2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
        return false;
    }
}

