/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct.runtime;

import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ErrorBase;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_HasConstructor;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.passthrough.I_VarConst;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.FuncLet;
import org.jmo_lang.object.pseudo.I_ObjToReplace;
import org.jmo_lang.object.pseudo.MultiCall;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.object.pseudo.mc.MC_IT_BLOCK;
import org.jmo_lang.object.pseudo.mc.MC_IT_EACH;
import org.jmo_lang.object.pseudo.mc.MC_IT_STREAM;
import org.jmo_lang.object.pseudo.mc.MC_THIS;
import org.jmo_lang.object.pseudo.mc.MagicConst;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.FunctionPar;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.StrictManager;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.struct.runtime.VCE_NEW_LEVEL;
import org.jmo_lang.struct.runtime.VarConstEnv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Function;
import org.jmo_lang.tools.Lib_Par;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Prio;

public class CallRuntime {
    final boolean SHOW_RAW_ERRORS;
    public final Instance instance;
    public final Call call;
    public final VarConstEnv vce;
    public final Call funcCalledWith;
    private I_Object[] par_result = null;

    public CallRuntime(Instance instance, Call call) {
        this(instance, call, null, VCE_NEW_LEVEL.FULL, null);
    }

    private CallRuntime(Instance instance, Call call, VarConstEnv parentVCE, VCE_NEW_LEVEL varEnvNew, Call funcCalledWith) {
        this.instance = instance;
        this.call = call;
        this.funcCalledWith = funcCalledWith;
        this.vce = varEnvNew == VCE_NEW_LEVEL.NO ? parentVCE : (varEnvNew == VCE_NEW_LEVEL.FRAME ? new VarConstEnv(parentVCE.vars, parentVCE.cons, parentVCE) : new VarConstEnv(parentVCE));
        this.SHOW_RAW_ERRORS = instance.getApp().isDebug();
    }

    public CallRuntime copyCall(Call call, boolean newVarEnv) {
        return new CallRuntime(this.instance, call, this.vce, newVarEnv ? VCE_NEW_LEVEL.FULL : VCE_NEW_LEVEL.NO, this.funcCalledWith);
    }

    public CallRuntime copyEach(String method) {
        Call call = new Call(this.getSurrBlock(), null, method, this.call.parCalls, this.getDebugInfo());
        return new CallRuntime(this.instance, call, this.vce, VCE_NEW_LEVEL.NO, this.funcCalledWith);
    }

    public CallRuntime copyBlockItem(Call call) {
        return new CallRuntime(this.instance, call, this.vce, VCE_NEW_LEVEL.NO, this.funcCalledWith);
    }

    public CallRuntime copyVCE(Instance newInstance, VarConstEnv base_vce, boolean varEnvNew) {
        return new CallRuntime(newInstance, this.call, base_vce, varEnvNew ? VCE_NEW_LEVEL.FULL : VCE_NEW_LEVEL.NO, this.funcCalledWith);
    }

    public CallRuntime copyLoop(Handle_Loop handle) {
        CallRuntime result = new CallRuntime(this.instance, this.call, this.vce, VCE_NEW_LEVEL.FRAME, this.funcCalledWith);
        result.vce.loopSet(handle);
        return result;
    }

    public CallRuntime copyNil() {
        Call c = new Call(this.getSurrBlock(), Nil.NIL, this.getDebugInfo());
        return new CallRuntime(this.instance, c, this.vce, VCE_NEW_LEVEL.NO, this.funcCalledWith);
    }

    public CallRuntime copyFunctional(Call c, Call[] pars, DebugInfo debug) {
        Block emptyBlock = new Block(null, null, null);
        Call callCopy = new Call(emptyBlock, c.object, c.method, pars, debug);
        Instance newInstance = new Instance(this.instance.getApp(), this.instance.getType(), null);
        newInstance.setAlreadyInit();
        return new CallRuntime(newInstance, callCopy, null, VCE_NEW_LEVEL.FULL, null);
    }

    public CallRuntime copyFunction() {
        return new CallRuntime(this.instance, this.call, this.instance.getMainEnv(), VCE_NEW_LEVEL.FULL, this.call);
    }

    public void describe(int left) {
        MOut.line(new Object[0]);
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + "CurProc " + this.hashCode());
        space = Lib_Parser.space(++left);
        MOut.text(String.valueOf(space) + "Instance: " + this.instance.toDebug(this));
        MOut.text(String.valueOf(space) + "VCE: " + this.vce.toString());
        MOut.text(String.valueOf(space) + "Call: " + (this.call == null ? "null" : this.call.toDebug(this)));
        if (this.call != null) {
            MOut.text(String.valueOf(space) + "SurrBlock: " + this.call.surrounding);
            MOut.text(String.valueOf(space) + "CallBlock: " + this.call.getBlock());
            MOut.text(String.valueOf(space) + "Vars (Types): ");
            if (this.getSurrBlock() != null && this.getSurrBlock().gVarManager() != null) {
                this.getSurrBlock().gVarManager().describe(left + 1);
            } else {
                MOut.text(String.valueOf(space) + "  none");
            }
        }
    }

    public App getApp() {
        return this.instance.getApp();
    }

    public Block getCallBlock() {
        return this.call.getBlock();
    }

    public DebugInfo getDebugInfo() {
        return this.call.debugInfo;
    }

    public Call getStream() {
        return this.call.getStream();
    }

    public Block getSurrBlock() {
        return this.call.surrounding;
    }

    public Type getType() {
        return this.instance.getType();
    }

    public StrictManager getStrict() {
        return this.instance.getApp().strict;
    }

    public int parCount() {
        return this.call.getParCount(this);
    }

    public I_Object[] pars() {
        return Lib_Par.checkPars(this, null, new Class[0]);
    }

    public I_Object[] pars(I_Object itStream, Class<?> ... types) {
        return Lib_Par.checkPars(this, itStream, types);
    }

    public I_Object[] parsExt(I_Object itStream, Class<?>[] ... types) {
        return Lib_Par.checkParsExt(this, itStream, types);
    }

    public I_Object parsEach(I_Object itStream, int offset, I_Object[] itEach, Class<?> type) {
        return Lib_Par.checkParsEach(this, itStream, offset, itEach, type);
    }

    public I_Object parEach(I_Object itStream, int parIdx, I_Object itEach, Class<?> type) {
        return Lib_Par.checkParEach(this, itStream, parIdx, itEach, type);
    }

    public I_Object[] parsFlex(I_Object itStream, int par_min, int par_max) {
        return Lib_Par.checkParsFlex(this, itStream, par_min, par_max);
    }

    public I_Object[] parsVarArgs(I_Object itStream, int par_min, int varArgsOffset) {
        I_Object[] pars = Lib_Par.checkParsFlex(this, itStream, par_min, Integer.MAX_VALUE);
        if (pars.length == varArgsOffset + 1 && pars[varArgsOffset] instanceof VarLet) {
            VarLet vl = (VarLet)pars[varArgsOffset];
            JMo_List list = (JMo_List)this.parType(vl.getVar().get(this), JMo_List.class);
            ArrayList<I_Object> al = list.getInternalObject();
            I_Object[] pars2 = new I_Object[varArgsOffset + al.size()];
            Lib_Error.ifPars(pars2.length, par_min, Integer.MAX_VALUE, this);
            if (varArgsOffset > 0) {
                System.arraycopy(pars, 0, pars2, 0, varArgsOffset);
            }
            int i = 0;
            while (i < al.size()) {
                pars2[varArgsOffset + i] = al.get(i);
                ++i;
            }
            return pars2;
        }
        return pars;
    }

    public I_Object parsOneAdvance(I_Object itStream, int argIdx, Class<? extends I_Object> type) {
        return Lib_Par.checkParAdvance(this, itStream, argIdx, type);
    }

    public void blockNecessary() {
        Lib_Par.checkBlockNecessary(this);
    }

    public void blockForbidden() {
        Lib_Par.checkBlockForbidden(this);
    }

    public I_Object parType(I_Object par, Class<?> type) {
        return Lib_Par.checkPar(this, par, type, null);
    }

    public I_Object parTypeExt(I_Object par, Class<?> ... types) {
        return Lib_Par.checkParExt(this, par, types);
    }

    public I_Object exec(I_Object streamIt, boolean isPar) {
        return (I_Object)this.exec((I_Object)streamIt, null, (byte)-1, (boolean)isPar).o1;
    }

    private Group2<I_Object, Call> exec(I_Object streamIt, I_Object eachIt, byte leftprio, boolean isPar) {
        Err.ifNull(this.call);
        try {
            I_Object with;
            Group2<I_Object, Call> res = null;
            I_Object objNew = this.call.object;
            I_Object i_Object = with = objNew != null ? objNew : streamIt;
            if (this.call.method == null && with instanceof A_Atomic && this.call.getBlock() == null) {
                if (this.call.getStream() != null) {
                    throw Err.invalid(this.call);
                }
                return new Group2<I_Object, Object>(with, null);
            }
            if (with instanceof I_ObjToReplace) {
                String met;
                if (objNew instanceof MC_THIS) {
                    with = this.instance;
                }
                if (objNew instanceof MC_IT_STREAM) {
                    if (streamIt instanceof MC_IT_STREAM) {
                        Err.invalid(objNew, with, streamIt);
                    }
                    if ((with = streamIt) instanceof MC_THIS) {
                        with = this.instance;
                    }
                }
                if (with instanceof MC_IT_BLOCK && (with = (met = this.call.method) != null && (met.equals("convertLet") || Lib_Function.isCalcLet(met) >= 0) ? this.call.surrounding : this.call.surrounding.getIt()) == null) {
                    with = Nil.NIL;
                }
                if (with instanceof MC_IT_EACH) {
                    if (eachIt == null) {
                        throw new CodeError(this, "Invalid call!", "This type/function currently doesn't support _EACH.");
                    }
                    with = eachIt;
                }
                if (with instanceof MagicConst) {
                    I_Object with_copy = with;
                    if ((with = ((MagicConst)with).get(this)) == null) {
                        throw new CodeError(this, "Invalid use of a magic constant!", with_copy.toString());
                    }
                }
            }
            if (with == null) {
                if (this.call.object == null) {
                    throw Err.invalid("Call without Object!", this.call.toDebug(this), this.getDebugInfo());
                }
                throw new CodeError(this, "Missing Object, nothing to work with", "Invalid use of MagicConst: " + this.call.object.toDebug(this));
            }
            if (with instanceof NonAtomic) {
                with = ((NonAtomic)with).create(this);
            }
            with.initOnce(this);
            boolean multicall = this.iHasMulticall(this.call.parCalls);
            if (!multicall) {
                res = this.execObject(with, leftprio, isPar);
            } else {
                Call[] pars = this.call.parCalls;
                int plen = pars.length;
                I_Object o = this.call.object != null ? this.call.object : with;
                I_Object[] parsResult = new I_Object[plen];
                int pp = 0;
                while (pp < pars.length) {
                    Call par = pars[pp];
                    if (par.object instanceof MultiCall) {
                        ((MultiCall)par.object).setStream(o);
                    }
                    CallRuntime cpPar = new CallRuntime(this.instance, par, this.vce, VCE_NEW_LEVEL.NO, this.funcCalledWith);
                    parsResult[pp] = cpPar.exec(o, isPar);
                    ++pp;
                }
                res = new Group2<I_Object, Object>(this.iExecMultiCall(with, 0, parsResult), null);
            }
            return res;
        }
        catch (ErrorBase t) {
            throw t;
        }
        catch (Err_Runtime t) {
            if (this.SHOW_RAW_ERRORS) {
                MOut.error(t);
            }
            String ste = this.stackTrace(t.getStackTrace()[1]);
            throw new ExecError(this, String.valueOf(t.getMessage()) + ste, ConvObject.toTextDebug(t.getDetails()));
        }
        catch (RuntimeException t) {
            if (this.SHOW_RAW_ERRORS) {
                MOut.error(t);
            }
            String ste0 = this.stackTrace(t.getStackTrace()[0]);
            String ste1 = this.stackTrace(t.getStackTrace()[1]);
            throw new ExecError(this, String.valueOf(t.getClass().getSimpleName()) + ste0 + ", " + ste1, t.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public Group2<I_Object, Call> execObject(I_Object with, byte leftprio, boolean isPar) {
        if (this.call.method == null) {
            if (this.call.getBlock() != null) {
                if (isPar) {
                    throw new CodeError(this, "Invalid use of auto-block-function.", "Auto-block-function can't used for a parameter");
                }
                this2 = Lib_Convert.getValue(this, with);
                if (this2 instanceof I_AutoBlockDo) {
                    if (with instanceof I_VarConst) {
                        throw new CodeError(this, "Auto-Block can't be used after a variable or constant.", "Use it with a function, for example '.pass' or '.each': " + with);
                    }
                    this.getStrict().checkAutoBlock(this);
                    ab_result = ((I_AutoBlockDo)this2).autoBlockDo(this);
                    return new Group2<I_Object, Object>(ab_result, null);
                }
                throw new CodeError(this, "This type has no auto-block-function.", "Use it with a function, for example '.pass' or '.each': " + with.getTypeName());
            }
            if (with instanceof I_HasConstructor) {
                return new Group2<I_Object, Object>(((I_HasConstructor)with).constructor(this), null);
            }
            return new Group2<I_Object, Object>(with, null);
        }
        next = this.call.getStream();
        while (next != null && Lib_Prio.streamPrio(this.call, next) && this.call.getParCount(this) == 1) {
            par = this.pars(with, new Class[]{I_Object.class})[0];
            streamPrioResult = this.execStream(par, next, leftprio == -1 ? this.call.prio : leftprio);
            this.par_result = new I_Object[]{(I_Object)streamPrioResult.o1};
            next = (Call)streamPrioResult.o2;
        }
        callResult = with.call(this);
        if (callResult.is_Attachment_Exec) {
            return new Group2<I_Object, Object>(callResult.obj, null);
        }
        method = this.call.method;
        currentresult = callResult.obj;
        if (this.call.getBlock() != null) {
            if (this.getType().getFunctions().knows(method) && (f = this.getType().getFunctions().get(this, method)).hasControl()) {
                return new Group2<I_Object, Object>(currentresult, null);
            }
            this.getStrict().checkAutoPass(this);
            block = this.getCallBlock();
            if (block != null) {
                try {
                    currentresult = block.exec(this, currentresult);
                }
                catch (ReturnException e) {
                    return new Group2<I_Object, Call>(e.get(), next);
                }
            }
        }
        if (next != null) ** GOTO lbl46
        return new Group2<I_Object, Call>(currentresult, next);
lbl-1000:
        // 1 sources

        {
            if (leftprio > -1 && next.prio < this.call.prio) {
                return new Group2<I_Object, Call>(currentresult, next);
            }
            streamResult = this.execStream(currentresult, next, leftprio);
            next = (Call)streamResult.o2;
            currentresult = (I_Object)streamResult.o1;
lbl46:
            // 2 sources

            ** while (next != null)
        }
lbl47:
        // 1 sources

        return new Group2<I_Object, Call>(currentresult, next);
    }

    public Group2<I_Object, Call> execStream(I_Object streamIt, Call next, byte leftprio) {
        if (next == null) {
            return new Group2<I_Object, Object>(streamIt, null);
        }
        switch (next.method) {
            case "&&": {
                if (streamIt != Bool.FALSE) break;
                return new Group2<I_Object, Object>(streamIt, null);
            }
            case "||": {
                if (streamIt != Bool.TRUE) break;
                return new Group2<I_Object, Object>(streamIt, null);
            }
            case "!&&": {
                if (streamIt != Bool.FALSE) break;
                return new Group2<Bool, Object>(Bool.TRUE, null);
            }
            case "!||": {
                if (streamIt != Bool.TRUE) break;
                return new Group2<Bool, Object>(Bool.FALSE, null);
            }
        }
        CallRuntime crStream = new CallRuntime(this.instance, next, this.vce, VCE_NEW_LEVEL.NO, this.funcCalledWith);
        return crStream.exec(streamIt, null, leftprio, false);
    }

    private I_Object iExecMultiCall(I_Object with, int ppos, I_Object[] current) {
        int len = current.length;
        if (ppos == len) {
            this.par_result = current;
            Group2<I_Object, Call> gr = this.execObject(with, (byte)-1, true);
            return (I_Object)gr.o1;
        }
        I_Object[] current2 = new I_Object[len];
        System.arraycopy(current, 0, current2, 0, len);
        if (current[ppos] instanceof MultiCall) {
            I_Object result = with;
            MultiCall curMC = (MultiCall)current[ppos];
            curMC.exec(this, this.getSurrBlock(), with);
            curMC.resetPointer();
            while (curMC.hasNext()) {
                current2[ppos] = curMC.getNext();
                result = this.iExecMultiCall(with, ppos + 1, current2);
                if (!(with instanceof Var)) continue;
                ((Var)with).let(this, this, result);
            }
            return result;
        }
        return this.iExecMultiCall(with, ppos + 1, current2);
    }

    public I_Object[] getPars(I_Object streamIt) {
        return this.getPars(streamIt, true);
    }

    public I_Object[] getPars(I_Object streamIt, boolean buffer) {
        if (buffer && this.par_result != null) {
            return this.par_result;
        }
        int len = this.call.parCalls == null ? 0 : this.call.parCalls.length;
        I_Object[] parsTemp = new I_Object[len];
        if (len > 0) {
            I_Object o = this.call.object == null || this.call.object instanceof I_ObjToReplace ? streamIt : this.call.object;
            int pp = 0;
            while (pp < len) {
                Call par = this.call.parCalls[pp];
                CallRuntime cpPar = new CallRuntime(this.instance, par, this.vce, VCE_NEW_LEVEL.NO, this.funcCalledWith);
                parsTemp[pp] = cpPar.exec(o, true);
                ++pp;
            }
        }
        this.par_result = parsTemp;
        return this.par_result;
    }

    public I_Object getParEach(I_Object streamIt, int parIdx, I_Object eachItObj) {
        Lib_Error.ifPars(parIdx + 1, 1, this.call.parCalls.length, this);
        I_Object o = this.call.object != null ? this.call.object : streamIt;
        I_Object parTemp = Nil.NIL;
        Call pc = this.call.parCalls[parIdx];
        parTemp = (I_Object)this.copyCall((Call)pc, (boolean)false).exec((I_Object)o, (I_Object)eachItObj, (byte)-1, (boolean)true).o1;
        this.par_result = null;
        return parTemp;
    }

    public I_Object getParsEach(I_Object streamIt, int offset, I_Object[] eachIt) {
        if (this.par_result != null) {
            return this.par_result[0];
        }
        Err.ifToSmall(1.0, eachIt.length);
        I_Object eachItObj = eachIt.length == 1 ? eachIt[0] : new JMo_List(eachIt);
        int len = this.call.parCalls == null ? 0 : this.call.parCalls.length;
        Lib_Error.ifPars(len, offset + 1, offset + 2, this);
        I_Object o = this.call.object != null ? this.call.object : streamIt;
        int fLen = len - offset;
        Err.ifOutOfBounds(1.0, 2.0, fLen);
        I_Object parTemp = Nil.NIL;
        if (fLen == 2) {
            if (!(this.call.parCalls[offset].object instanceof VarLet)) {
                throw new CodeError(this, "Invalid parameter!", "Parameter " + (offset + 1) + " isn't a VarLet!");
            }
            VarLet vl = (VarLet)this.call.parCalls[offset].object;
            vl.getVar().let(this, this, eachItObj);
            Call pc = this.call.parCalls[offset + 1];
            parTemp = (I_Object)this.copyCall((Call)pc, (boolean)false).exec((I_Object)o, (I_Object)eachItObj, (byte)-1, (boolean)true).o1;
        } else {
            Call pc = this.call.parCalls[offset];
            if (pc.object instanceof VarLet) {
                throw new CodeError(this, "Invalid use of VarLet!", "This function doesn't accept a VarLet.");
            }
            if (pc.object instanceof FuncLet) {
                FuncLet fl = (FuncLet)pc.object;
                Call[] par_calls = new Call[eachIt.length];
                int i = 0;
                while (i < eachIt.length) {
                    par_calls[i] = new Call(this.getSurrBlock(), eachIt[i], this.getDebugInfo());
                    ++i;
                }
                Call c = new Call(this.getSurrBlock(), null, null, par_calls, this.getDebugInfo());
                CallRuntime cpFL = this.copyCall(c, true);
                parTemp = fl.exec(cpFL);
            } else {
                parTemp = (I_Object)this.copyCall((Call)pc, (boolean)false).exec((I_Object)o, (I_Object)eachItObj, (byte)-1, (boolean)true).o1;
            }
        }
        parTemp = Lib_Convert.getValue(this, parTemp);
        if (parTemp instanceof FuncLet) {
            parTemp = ((FuncLet)parTemp).eachExec(this, eachItObj);
        }
        this.par_result = new I_Object[]{parTemp};
        return parTemp;
    }

    public I_Object getParAdvance(I_Object streamIt, int parIdx) {
        if (this.par_result != null) {
            return this.par_result[parIdx];
        }
        I_Object o = this.call.object != null ? this.call.object : streamIt;
        return this.execInit(this.call.parCalls[parIdx], o);
    }

    public I_Object getParAdvance(I_Object streamIt, int funcParIdx, FunctionPar[] funcPars, boolean buffer, I_Object eachItObj) {
        if (buffer && this.par_result != null) {
            return this.par_result[funcParIdx];
        }
        I_Object o = this.call.object != null ? this.call.object : streamIt;
        int diff = funcPars.length - this.call.parCalls.length;
        int fp = funcPars.length - 1;
        while (fp > funcParIdx) {
            if (diff > 0 && funcPars[fp].defaultValue != null) {
                --diff;
            }
            --fp;
        }
        if (diff > 0 && funcPars[funcParIdx].defaultValue != null) {
            return funcPars[funcParIdx].defaultValue;
        }
        Call parCall = this.call.parCalls[funcParIdx - diff];
        return eachItObj == null ? this.execInit(parCall, o) : (I_Object)this.copyCall((Call)parCall, (boolean)false).exec((I_Object)o, (I_Object)eachItObj, (byte)-1, (boolean)true).o1;
    }

    private String stackTrace(StackTraceElement st) {
        String ste;
        String string = ste = st.getFileName() == null ? "" : String.valueOf(st.getFileName()) + ":" + st.getLineNumber();
        if (ste.length() > 0) {
            ste = String.valueOf('(') + ste + ')';
        }
        return ste;
    }

    private boolean iHasMulticall(Call[] calls) {
        if (calls != null) {
            Call[] callArray = calls;
            int n = calls.length;
            int n2 = 0;
            while (n2 < n) {
                Call c = callArray[n2];
                if (c.object instanceof MultiCall) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public String toString() {
        String sc = this.call == null ? "null" : this.call.toString();
        return sc + " | " + this.instance.toString() + " | " + this.vce.toString();
    }

    public I_Object execInit(Call call, I_Object streamIt) {
        CallRuntime cpInit = new CallRuntime(this.instance, call, this.vce, VCE_NEW_LEVEL.NO, this.funcCalledWith);
        return cpInit.exec(streamIt, false);
    }

    public I_Object execEachInit(Call call, I_Object streamIt, I_Object eachIt) {
        CallRuntime cpInit = new CallRuntime(this.instance, call, this.vce, VCE_NEW_LEVEL.NO, this.funcCalledWith);
        Group2<I_Object, Call> g = cpInit.exec(streamIt, eachIt, (byte)0, false);
        if (g.o2 != null) {
            Err.invalid(g.o2);
        }
        return (I_Object)g.o1;
    }
}

