/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.data.group.Group4;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.JmoError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.FunctionPar;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;

public class Function
extends A_Object {
    private final String name;
    private final Block block;
    private final boolean control;
    private final FunctionPar[] pars;
    private final String returnType;
    private final boolean returnNil;
    private final Type typ;
    private boolean oneLine = false;
    private boolean varArgs;

    public Function(Type typ, String name, FunctionPar[] pars, boolean control, String returnType, boolean returnNil, DebugInfo debugInfo) {
        this.typ = typ;
        this.name = name;
        this.block = new Block(typ, this, typ.getBlock());
        this.pars = pars;
        if (pars != null) {
            FunctionPar[] functionParArray = pars;
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionPar par = functionParArray[n2];
                if (par.isConst) {
                    this.block.gConstManager().define(par.name, debugInfo);
                } else {
                    this.block.gVarManager().define(par.name, debugInfo);
                }
                ++n2;
            }
        }
        this.control = control;
        this.returnType = returnType;
        this.returnNil = returnNil;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "=": 
            case "let": {
                return this.iResult(cr, 1, 1);
            }
            case "<<": 
            case "end": {
                return this.iResult(cr, 0, 0);
            }
            case "return": {
                return this.iResult(cr, 0, 1);
            }
            case "init": 
            case "_init": {
                return this.iInit(cr);
            }
            case "hasStream": {
                this.iCheckControl(cr, CONTROL_PART.STREAM);
                Bool res = Bool.getObject(cr.funcCalledWith.getStream() != null);
                return A_Object.stdResult(res);
            }
            case "hasBlock": {
                this.iCheckControl(cr, CONTROL_PART.BLOCK);
                Bool resb = Bool.getObject(cr.funcCalledWith.getBlock() != null);
                return A_Object.stdResult(resb);
            }
            case "push": {
                this.iCheckControl(cr, null);
                I_Object result = cr.pars(this, I_Object.class)[0];
                if (cr.funcCalledWith.getBlock() != null) {
                    try {
                        Group4<Block, CallRuntime, CallRuntime, FunctionPar[]> g = cr.vce.getFuncInit(cr);
                        if (g == null) {
                            throw new JmoError(cr, "Missing initialization of the parameters.", "Function: " + this.name);
                        }
                        result = cr.funcCalledWith.getBlock().execExt((CallRuntime)g.o2, result);
                    }
                    catch (ReturnException e) {
                        return new ObjectCallResult(e.get(), true);
                    }
                }
                if (cr.funcCalledWith.getStream() != null) {
                    result = cr.execInit(cr.funcCalledWith.getStream(), result);
                }
                return A_Object.stdResult(result);
            }
        }
        return null;
    }

    @Override
    public void describe(CallRuntime cr, int depth) {
        this.block.describe(cr, depth);
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean hasControl() {
        return this.control;
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean getReturnNil() {
        return this.returnNil;
    }

    public Type getType() {
        return this.typ;
    }

    public FunctionPar[] getVars() {
        return this.pars;
    }

    public void setOneLine() {
        this.oneLine = true;
    }

    public boolean isOneLine() {
        return this.oneLine;
    }

    public void setVarArgs() {
        this.varArgs = true;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "Function: " + this.name + "\n" + this.block.toDebug(cr);
    }

    @Override
    public String toString() {
        return String.valueOf(this.typ.getName()) + "." + this.name;
    }

    private ObjectCallResult iResult(CallRuntime cr, int min, int max) {
        I_Object o = Lib_Exec.onePar(cr, this, min, max);
        return A_Object.stdResult(new Return(Return.LEVEL.RETURN, o));
    }

    private ObjectCallResult iInit(CallRuntime cr) {
        if (!this.control) {
            throw new CodeError(cr, "Function has no control-functionality.", "Function: " + this.name);
        }
        I_Object[] pars = cr.parsFlex(null, 0, 2);
        Group4<Block, CallRuntime, CallRuntime, FunctionPar[]> g = cr.vce.getFuncInit(cr);
        if (g == null) {
            throw new ExecError(cr, "Failed to initialize the parameters.", "Function: " + this.name);
        }
        if (pars.length == 0) {
            ((Block)g.o1).initPars((CallRuntime)g.o2, (CallRuntime)g.o3, (FunctionPar[])g.o4, ((CallRuntime)g.o2).getPars(null, false));
        } else {
            int parNr = Lib_Convert.getIntValue(cr, cr.parType(pars[0], A_IntNumber.class));
            Lib_Error.ifNotBetween(cr, 1, ((FunctionPar[])g.o4).length, parNr, "Parameter-Number");
            I_Object par = pars.length == 1 ? ((CallRuntime)g.o2).getParAdvance(null, parNr - 1, (FunctionPar[])g.o4, false, null) : ((CallRuntime)g.o2).getParAdvance(null, parNr - 1, (FunctionPar[])g.o4, false, pars[1]);
            int funcParCount = ((FunctionPar[])g.o4).length;
            I_Object[] initPars = new I_Object[funcParCount];
            initPars[parNr - 1] = par;
            ((Block)g.o1).initPars((CallRuntime)g.o2, (CallRuntime)g.o3, (FunctionPar[])g.o4, initPars);
        }
        return A_Object.stdResult(Nil.NIL);
    }

    private void iCheckControl(CallRuntime cr, CONTROL_PART bs) {
        if (!this.control || cr.funcCalledWith == null) {
            throw new CodeError(cr, "Invalid " + (bs == null ? "block/stream" : bs.name().toLowerCase()) + " access", "This function has no control functionality!");
        }
    }

    private static enum CONTROL_PART {
        BLOCK,
        STREAM;

    }
}

