/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.object.pseudo.mc.MC_THIS;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ConstManager;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.FunctionPar;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.VarManager;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Function;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Type;

public class Block
extends A_Object {
    private static int counter = 0;
    private final int nr;
    private ArrayList<Call> items = null;
    private final Block parent;
    private final Function func;
    private final Type typ;
    private final VarManager vars;
    private final ConstManager consts;
    private I_Object blockIT = null;

    public Block(Type typ) {
        this(typ, null, null);
    }

    public Block(Type typ, Function func, Block parent) {
        this.typ = typ;
        this.func = func;
        this.parent = parent;
        this.nr = ++counter;
        this.vars = new VarManager(parent == null ? null : parent.gVarManager());
        this.consts = new ConstManager(parent == null ? null : parent.gConstManager());
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "=": {
                this.blockIT = cr.pars(this, new Class[]{null})[0];
                return A_Object.stdResult(this);
            }
            case "convertLet": {
                this.blockIT = cr.pars(this.blockIT, I_Object.class)[0];
                return A_Object.stdResult(this);
            }
        }
        byte cl = Lib_Function.isCalcLet(method);
        if (cl > 0) {
            this.blockIT = Lib_Function.calcLet(cr, method, cl, this.blockIT);
            return new ObjectCallResult(this, true);
        }
        return null;
    }

    public final void add(Call m) {
        Err.ifNull(m);
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(m);
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        String space = Lib_Parser.space(left);
        String space2 = Lib_Parser.space(left + 1);
        MOut.text(String.valueOf(space) + this.toDebug(cr));
        if (this.vars != null && this.vars.getCount() > 0) {
            MOut.text(String.valueOf(space2) + "Variables:");
            this.vars.describe(cr, left + 2);
        }
        if (this.consts != null && this.consts.getCount() > 0) {
            MOut.text(String.valueOf(space2) + "Constants:");
            this.consts.describe(cr, left + 2);
        }
        if (this.items != null && this.items.size() > 0) {
            MOut.text(String.valueOf(space2) + "Items:");
            for (Call c : this.items) {
                c.describe(cr, left + 2);
            }
        }
    }

    public final I_Object execAppRoot(CallRuntime cr) throws ReturnException {
        return this.iExec(cr, this.blockIT, true);
    }

    public final I_Object exec(CallRuntime cr, I_Object blockIT) throws ReturnException {
        return this.execExt(cr, blockIT);
    }

    public final I_Object execExt(CallRuntime cr, I_Object blockIT) throws ReturnException {
        cr = cr.copyCall(cr.call, true);
        return this.iExec(cr, blockIT, false);
    }

    public void reInit(CallRuntime crOut, CallRuntime crIn, I_Object[] pars) {
        this.initPars(crOut, crIn, crIn.instance.getType().getVars(), pars);
    }

    public void reInit(CallRuntime crOut, CallRuntime crIn, int parsGiven, int parToInit, I_Object parValue) {
        I_Object[] pars = new I_Object[parsGiven];
        pars[parToInit - 1] = parValue;
        this.initPars(crOut, crIn, crIn.instance.getType().getVars(), pars);
    }

    public I_Object execOverwrite(CallRuntime cr, Instance instance, Function f) {
        CallRuntime crInside = cr.copyVCE(instance, instance.getMainEnv(), true);
        try {
            I_Object result = f.getBlock().execFunction(cr, crInside, f);
            MOut.exit(result);
            return result;
        }
        catch (ReturnException e) {
            if (e.get().getLevel() != Return.LEVEL.RETURN) {
                throw new ExecError(crInside, "Invalid return from overwritten function!", "Function " + f.toDebug(crInside) + " returns " + (Object)((Object)e.get().getLevel()));
            }
            return e.get().getResult();
        }
    }

    public I_Object execFunction(CallRuntime crOutside, CallRuntime crInside, Function f) throws ReturnException {
        boolean throw_return;
        I_Object checkValue;
        I_Object returnValue;
        CallRuntime crNew;
        block15: {
            if (!f.hasControl() && crInside.call.getBlock() != null) {
                throw new CodeError(crInside, "No Block allowed", "This function doesn't allow a block: " + crInside.call.toString());
            }
            crNew = crInside.copyFunction();
            if (!f.hasControl()) {
                this.initPars(crOutside, crNew, f.getVars(), crOutside.getPars(null));
            } else {
                crNew.vce.setFuncInit(this, crOutside, crNew, f.getVars());
            }
            returnValue = null;
            checkValue = null;
            throw_return = false;
            try {
                checkValue = returnValue = this.iExec(crNew, Nil.NIL, false);
            }
            catch (ReturnException e) {
                Return r = e.get();
                returnValue = r;
                checkValue = r.getResult();
                throw_return = true;
                if (r.getLevel() == Return.LEVEL.RETURN) break block15;
                Err.todo(r);
            }
        }
        if (checkValue == null && this.isEmpty()) {
            checkValue = returnValue = Lib_AtomConv.getDefaultValue(f.getReturnType());
        }
        if (f.getReturnType() != null) {
            if (f.getReturnType().equals("Same")) {
                if (throw_return && checkValue != Nil.NIL && !(checkValue instanceof MC_THIS) && !(checkValue instanceof Instance)) {
                    throw new CodeError(crNew, "Invalid Value for Return-Type 'Same'", "Got \"" + Lib_Type.getName(checkValue.getClass(), checkValue) + "\", need _THIS");
                }
                Instance newValue = crNew.instance;
                returnValue = throw_return ? new Return(((Return)returnValue).getLevel(), newValue) : newValue;
            } else {
                String resultType = Lib_Type.getName(checkValue.getClass(), checkValue);
                String wantedType = f.getReturnType();
                if (!Lib_Type.isInstanceOf(checkValue, wantedType)) {
                    if (resultType.equals("Nil")) {
                        if (!f.getReturnNil()) {
                            throw new CodeError(crNew, "Invalid return value", "Return value is nil");
                        }
                    } else {
                        throw new CodeError(crNew, "Invalid Return-Type", "Got \"" + resultType + "\", need \"" + wantedType + "\"");
                    }
                }
            }
        }
        if (throw_return) {
            throw new ReturnException((Return)returnValue);
        }
        return returnValue;
    }

    public void execTypeBlock(CallRuntime cpOutside, CallRuntime cpInside, I_Object[] pars) {
        CallRuntime cpNew2 = cpInside.copyCall(cpInside.call, false);
        this.initPars(cpOutside, cpNew2, cpInside.instance.getType().getVars(), pars);
        try {
            this.iExec(cpNew2, null, false);
        }
        catch (ReturnException e) {
            throw new CodeError(cpOutside, "Invalid condition", "Return, Break & Next in Type-Body is forbidden.");
        }
    }

    public ConstManager gConstManager() {
        return this.consts;
    }

    public Function getFunction(CallRuntime cr) {
        return this.func != null ? this.func : cr.getType().getMain(cr);
    }

    public I_Object getIt() {
        return this.blockIT;
    }

    public Collection<Call> gItems() {
        return this.items;
    }

    public Block gParent() {
        return this.parent;
    }

    public Type gType() {
        return this.typ;
    }

    public boolean isEmpty() {
        return this.items == null || this.items.size() == 0;
    }

    public VarManager gVarManager() {
        return this.vars;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "<Block_" + this.nr + ">";
    }

    @Override
    public String toString() {
        return "Block_" + this.nr;
    }

    private final I_Object iExec(CallRuntime cr, I_Object blockIT, boolean returnLast) throws ReturnException {
        this.blockIT = blockIT;
        if (this.items == null) {
            return null;
        }
        I_Object last_result = null;
        for (Call c : this.items) {
            I_Object result;
            CallRuntime crCall = cr.copyBlockItem(c);
            last_result = result = crCall.exec(blockIT, false);
            if (!(result instanceof Return)) continue;
            if (((Return)result).getLevel() != Return.LEVEL.EXIT) {
                throw new ReturnException((Return)result);
            }
            result = ((Return)result).getResult();
            cr.getApp().exit(cr.copyCall(new Call(cr.getSurrBlock(), result, cr.getDebugInfo()), false));
        }
        return returnLast ? last_result : this.blockIT;
    }

    public void initPars(CallRuntime cpOld, CallRuntime cpNew, FunctionPar[] fPars, I_Object[] pars) {
        block18: {
            boolean hasVarArgs;
            int parsLen = pars == null ? 0 : pars.length;
            int fParsLen = fPars == null ? 0 : fPars.length;
            boolean bl = hasVarArgs = this.func != null && this.func.isVarArgs() || this.func == null && this.typ != null && this.typ.isVarArgs();
            if (parsLen > fParsLen && !hasVarArgs) {
                throw new CodeError(cpOld, "Too much parameters", "Got " + parsLen + ", need " + fParsLen + " parameter(s).");
            }
            if (fPars == null) break block18;
            Err.ifNull(new Object[]{pars});
            int offset = fParsLen - parsLen;
            int i = fParsLen - 1;
            while (i >= 0) {
                block22: {
                    I_Object par;
                    boolean useVarArgs;
                    FunctionPar fPar;
                    block20: {
                        I_Object par1;
                        int parIdx;
                        block21: {
                            block19: {
                                boolean useDefault;
                                fPar = fPars[i];
                                boolean bl2 = useDefault = offset > 0 && fPar.defaultValue != null;
                                if (useDefault) {
                                    --offset;
                                }
                                boolean bl3 = useVarArgs = hasVarArgs && i == fParsLen - 1;
                                if (useVarArgs) {
                                    offset = parsLen >= fParsLen - 1 ? 0 : --offset;
                                }
                                if ((parIdx = i - offset) < 0) {
                                    throw new CodeError(cpOld, "Missing parameter or default value", "Got " + parsLen + ", need " + fParsLen + " parameter(s).");
                                }
                                par = null;
                                if (!useDefault) break block19;
                                par = fPar.defaultValue;
                                break block20;
                            }
                            if (!useVarArgs) break block21;
                            if (parsLen >= 1 && fParsLen == parsLen && parIdx == parsLen - 1 && pars[parIdx] instanceof VarLet) {
                                I_Object paro = ((VarLet)pars[parIdx]).getVar().get(cpOld);
                                if (!Lib_Type.typeIs(cpOld, paro, JMo_List.class)) {
                                    throw new ExecError(cpOld, "Invalid type of variable for varargs", "To use Var-Args with a VarLet, the variable must be a List");
                                }
                                par = paro;
                            } else {
                                ArrayList<I_Object> al = new ArrayList<I_Object>();
                                int v = fParsLen - 1;
                                while (v < parsLen) {
                                    I_Object p = pars[v];
                                    if (fPar.type != null && par != Nil.NIL && !Lib_Type.isInstanceOf(p, fPar.type)) {
                                        throw new CodeError(cpOld, "Invalid type of parameter in VarArgs", "Got \"" + p.getTypeName() + "\", need \"" + fPar.type + "\"");
                                    }
                                    al.add(p);
                                    ++v;
                                }
                                par = new JMo_List(al);
                            }
                            break block20;
                        }
                        if (parIdx > parsLen - 1) {
                            Err.invalid(parIdx, parsLen, fParsLen);
                        }
                        if ((par1 = pars[parIdx]) == null) break block22;
                        par = Lib_Convert.getValue(cpOld, par1);
                    }
                    if (!useVarArgs && fPar.type != null && par != Nil.NIL && !Lib_Type.isInstanceOf(par, fPar.type)) {
                        throw new CodeError(cpOld, "Invalid type of parameter", "Got \"" + par.getTypeName() + "\", need \"" + fPar.type + "\"");
                    }
                    if (this.vars.parentKnowsRaw(fPar.name)) {
                        throw new CodeError(cpOld, "Can't create Var/Const with this name!", "Name is already used/known in this block: " + fPar.name);
                    }
                    if (fPar.isConst) {
                        Const con = (Const)this.consts.use_RunTime(cpOld, fPar.name);
                        con.set(cpOld, cpNew, par);
                    } else {
                        Var var = (Var)this.vars.use_RunTime(cpOld, fPar.name);
                        var.let(cpOld, cpNew, par);
                    }
                }
                --i;
            }
            Err.ifNot(offset, 0);
        }
    }
}

