/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.MODIFIER;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Parser;

public abstract class A_VarManager<T extends I_Object> {
    private final A_VarManager<T> parent;
    private final ArrayList<MODIFIER> varsModifier = new ArrayList();
    private final ArrayList<String> varsRaw = new ArrayList();
    private final ArrayList<T> varsObject = new ArrayList();

    public A_VarManager(A_VarManager<T> parent) {
        this.parent = parent;
    }

    public T define(String name, DebugInfo debug) {
        Group2<String, MODIFIER> g = this.iSplitName(name);
        char c0 = name.charAt(0);
        if (g.o2 == MODIFIER.UNSAFE && c0 >= 'A' && c0 <= 'Z') {
            throw new ParseError("Invalid constant!", "Modifiers ?? and \u00bf are not allowed: " + name, debug);
        }
        this.varsRaw.add((String)g.o1);
        this.varsModifier.add((MODIFIER)((Object)g.o2));
        T vo = this.pCreateNew(name);
        this.varsObject.add(vo);
        return vo;
    }

    public T use_ParseTime(Parser_Script parser, String name, boolean onlyDefine) {
        T vo = this.iUse(parser.app, name, false, parser.gDebugInfo());
        if (vo != null) {
            if (onlyDefine) {
                throw new ParseError("Variable/Const already defined", "Name: " + name, parser.gDebugInfo());
            }
            return vo;
        }
        return this.define(name, parser.gDebugInfo());
    }

    public T use_RunTime(CallRuntime cr, String name) {
        return this.iUse(cr.getApp(), name, true, cr.getDebugInfo());
    }

    public boolean knowsRaw(String rawname) {
        if (this.varsRaw.contains(rawname)) {
            return true;
        }
        return this.parent != null && this.parent.knowsRaw(rawname);
    }

    public boolean parentKnowsRaw(String rawname) {
        return this.parent != null && this.parent.knowsRaw(rawname);
    }

    public int getCount() {
        return this.varsRaw.size();
    }

    public void describe(CallRuntime cr, int depth) {
        for (I_Object t : this.varsObject) {
            t.describe(cr, depth);
        }
    }

    public void describe(int left) {
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + "Items:");
        if (!this.varsObject.isEmpty()) {
            for (I_Object t : this.varsObject) {
                MOut.text(String.valueOf(Lib_Parser.space(left + 1)) + t.toString());
            }
        } else {
            MOut.text(String.valueOf(space) + "  none");
        }
        MOut.text(String.valueOf(space) + "Parent:");
        if (this.parent == null) {
            MOut.text(String.valueOf(space) + "  none");
        } else {
            this.parent.describe(left + 1);
        }
    }

    protected abstract T pCreateNew(String var1);

    protected T iUse(App app, String name, boolean isRuntime, DebugInfo debug) {
        if (this.parent == this) {
            Err.invalid(name);
        }
        Group2<String, MODIFIER> g = this.iSplitName(name);
        int idx = this.varsRaw.indexOf(g.o1);
        if (idx >= 0) {
            MODIFIER modifOriginal;
            if (!isRuntime && (modifOriginal = this.varsModifier.get(idx)) != g.o2) {
                if (g.o2 != MODIFIER.SAFE) {
                    char c0 = ((String)g.o1).charAt(0);
                    String vc = c0 >= 'A' && c0 <= 'Z' ? "Const" : "Var";
                    throw new CodeError("Invalid modifier for Var/Const", String.valueOf(vc) + " '" + (String)g.o1 + "' is '" + modifOriginal.title + "' but the query is: " + ((MODIFIER)((Object)g.o2)).title, debug);
                }
                if (g.o2 == MODIFIER.SAFE) {
                    String full = String.valueOf((String)g.o1) + (modifOriginal == MODIFIER.NILABLE ? "?" : "??");
                    app.strict.checkVarConstShortcut(debug, name, full);
                }
            }
            return (T)((I_Object)this.varsObject.get(idx));
        }
        if (this.parent != null && this.parent.knowsRaw((String)g.o1)) {
            return this.parent.iUse(app, name, false, debug);
        }
        if (isRuntime) {
            throw Err.forbidden("Access to unknown variable: " + name);
        }
        return null;
    }

    private Group2<String, MODIFIER> iSplitName(String name) {
        char c_l2;
        int len = name.length();
        boolean unsafe = false;
        boolean nilable = false;
        char c_l1 = name.charAt(len - 1);
        if (c_l1 == '?') {
            --len;
            nilable = true;
        }
        if (c_l1 == '\u00bf') {
            --len;
            unsafe = true;
        }
        if (!unsafe && len > 0 && (c_l2 = name.charAt(len - 1)) == '?') {
            --len;
            unsafe = true;
        }
        String rawname = name.substring(0, len);
        MODIFIER modifier = unsafe ? MODIFIER.UNSAFE : (nilable ? MODIFIER.NILABLE : MODIFIER.SAFE);
        return new Group2<String, MODIFIER>(rawname, modifier);
    }
}

