/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Regex;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.passthrough.Use;
import org.jmo_lang.object.passthrough.While;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.parser.Parser_Call;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.tools.Lib_Parser;

public class ParseObj_ShortCutsQm
implements I_ParseObject {
    private boolean use_ok = true;
    private boolean while_ok = true;
    private boolean regex_ok = true;

    public void strict(boolean use_ok, boolean while_ok, boolean regex_ok) {
        this.use_ok = use_ok;
        this.while_ok = while_ok;
        this.regex_ok = regex_ok;
    }

    @Override
    public boolean hits(char c0, Block current, String s) {
        if (c0 != '?' || s.length() < 2) {
            return false;
        }
        switch (s.charAt(1)) {
            case '\"': 
            case '(': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        s = s.substring(1);
        switch (s.charAt(0)) {
            case '(': {
                return this.parseCondition(parser, current, s);
            }
            case '{': {
                return this.parseWhile(parser, current, s);
            }
            case '\"': {
                return this.parseRegex(parser, current, s);
            }
        }
        throw Err.invalid(s);
    }

    private Group2<I_Object, String> parseCondition(Parser_Script parser, Block current, String s) {
        if (!this.use_ok) {
            throw new ParseError("Strict: Shortcut for Use is forbidden. Write Use()!", s, parser.gDebugInfo());
        }
        String group = Lib_Parser.group('(', ')', s, parser.gDebugInfo());
        String rem = s.substring(group.length() + 2);
        Call[] pars = Parser_Call.parseParameter(parser, current, group);
        Lib_Parser.ifPars(pars.length, 2, 3, parser.gDebugInfo());
        return new Group2<I_Object, String>(new NonAtomic(Use.class, pars), ".get()" + rem);
    }

    private Group2<I_Object, String> parseWhile(Parser_Script parser, Block current, String s) {
        if (!this.while_ok) {
            throw new ParseError("Strict: Shortcut for While is forbidden. Use While()!", s, parser.gDebugInfo());
        }
        String group = Lib_Parser.group('{', '}', s, parser.gDebugInfo());
        String rem = s.substring(group.length() + 2);
        Call[] pars = Parser_Call.parseParameter(parser, current, group);
        Lib_Parser.ifPars(pars.length, 1, 1, parser.gDebugInfo());
        return new Group2<I_Object, String>(new NonAtomic(While.class, pars), ".each()" + rem);
    }

    private Group2<I_Object, String> parseRegex(Parser_Script parser, Block current, String s) {
        if (!this.regex_ok) {
            throw new ParseError("Strict: Shortcut for Regex is forbidden. Use Regex()!", s, parser.gDebugInfo());
        }
        Group2<String, Integer> g = Lib_Parser.regexGet(s, parser.gDebugInfo());
        String str = (String)g.o1;
        String rem = s.substring((Integer)g.o2 + 1);
        Call par = new Call(current, new Str(str), parser.gDebugInfo());
        return new Group2<I_Object, String>(new NonAtomic(JMo_Regex.class, new Call[]{par}), rem);
    }
}

