/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.struct.Block;

public class ParseObj_Int
implements I_ParseObject {
    private static final String regex = "^([-+]?[0-9]+)[bsilfd]?.*$";

    @Override
    public boolean hits(char c0, Block current, String s) {
        return (c0 == '-' || c0 == '+' || c0 >= '0' && c0 <= '9') && s.matches(regex);
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        String nr = s.replaceFirst(regex, "$1");
        String rem = s.substring(nr.length());
        if (rem.length() == 0) {
            Int obj = new Int(Integer.parseInt(nr));
            return new Group2<I_Object, String>(obj, rem);
        }
        A_Number obj = null;
        switch (rem.charAt(0)) {
            case 'b': {
                obj = new JMo_Byte(Byte.parseByte(nr));
                rem = rem.substring(1);
                break;
            }
            case 's': {
                obj = new JMo_Short(Short.parseShort(nr));
                rem = rem.substring(1);
                break;
            }
            case 'i': {
                obj = new Int(Integer.parseInt(nr));
                rem = rem.substring(1);
                break;
            }
            case 'l': {
                obj = new JMo_Long(Long.parseLong(nr));
                rem = rem.substring(1);
                break;
            }
            case 'f': {
                obj = new JMo_Float(Float.parseFloat(nr));
                rem = rem.substring(1);
                break;
            }
            case 'd': {
                obj = new Dec(Double.parseDouble(nr));
                rem = rem.substring(1);
                break;
            }
            default: {
                obj = new Int(Integer.parseInt(nr));
            }
        }
        return new Group2<I_Object, String>(obj, rem);
    }
}

