/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.fdef;

import de.mn77.base.data.group.Group3;
import de.mn77.base.data.struct.list.I_List;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.fdef.I_ParseFDef;
import org.jmo_lang.parser.fdef.Lib_FDef;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.FunctionPar;
import org.jmo_lang.struct.Type;
import org.jmo_lang.tools.Lib_Parser;

public class ParseFDef_ParMulti
implements I_ParseFDef {
    private static final String regex = "^([a-z_][A-Za-z0-9_]*)\\s*[({]\\s*((\\s*[A-Z][A-Za-z0-9_]*\\s+)?[a-zA-Z][A-Za-z0-9_]*[?\u00bf]?[?]?\\s*(=[^,]+)?\\s*(,\\s*(\\s*[A-Z][A-Za-z0-9_]*\\s+)?[a-zA-Z][A-Za-z0-9_]*[?\u00bf]?[?]?\\s*(=[^,]+)?)*)?\\s*(\\.\\.\\.\\s*)?[)}]\\s*([A-Z][A-Za-z0-9_]*[?]?)?(\\s*=\\s*.*)?$";

    @Override
    public boolean hits(String s) {
        return s.matches(regex);
    }

    @Override
    public Function parse(Parser_Script parser, Type type, String s) {
        String name = s.replaceFirst(regex, "$1");
        String rest = s.substring(name.length()).trim();
        boolean control = false;
        char open = '(';
        char close = ')';
        if (rest.charAt(0) == '{') {
            control = true;
            open = '{';
            close = '}';
        }
        Group3<I_List<FunctionPar>, Integer, Boolean> g = Lib_Parser.getFunctionPars(parser, type.getBlock(), s, open, close);
        I_List pars = (I_List)g.o1;
        boolean varargs = (Boolean)g.o3;
        String sReturnDef = s.substring((Integer)g.o2).trim();
        String regexReturn = "^([A-Z][A-Za-z0-9_]*[?]?)?(.*)$";
        String returnType = sReturnDef.replaceFirst("^([A-Z][A-Za-z0-9_]*[?]?)?(.*)$", "$1").trim();
        String sReturnValue = sReturnDef.replaceFirst("^([A-Z][A-Za-z0-9_]*[?]?)?(.*)$", "$2").trim();
        boolean returnNil = false;
        if (returnType.length() == 0) {
            returnType = null;
        }
        if (returnType != null && returnType.length() > 0 && returnType.endsWith("?")) {
            returnNil = true;
            returnType = returnType.substring(0, returnType.length() - 1);
        }
        parser.app.strict.checkFuncResultType(returnType, name, parser.gDebugInfo());
        Function f = new Function(type, name, pars.toArray(FunctionPar.class), control, returnType, returnNil, parser.gDebugInfo());
        Lib_FDef.setReturnCall(sReturnValue, parser, f);
        if (varargs) {
            f.setVarArgs();
        }
        return f;
    }
}

