/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.struct;

import de.mn77.base.data.Lib_Random;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.type.Lib_Compare;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Regex;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.object.struct.A_Sequence;
import org.jmo_lang.object.struct.JMo_Map;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.I_AutoBlockList;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.ObjectManager;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Sequence;
import org.jmo_lang.tools.Lib_StrFormat;
import org.jmo_lang.tools.Lib_Type;

public class JMo_List
extends A_Sequence
implements I_AutoBlockDo,
I_AutoBlockList {
    private ArrayList<I_Object> list;
    private Call[] init;
    private boolean fixedLength = false;
    private boolean fixedTypes = false;
    private String fixedType = null;

    public JMo_List() {
        this.list = new ArrayList();
        this.init = null;
    }

    public JMo_List(ArrayList<I_Object> list) {
        this.list = list;
        this.init = null;
    }

    public JMo_List(I_Object[] oa) {
        this.list = new ArrayList();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            this.list.add(o);
            ++n2;
        }
        this.init = null;
    }

    public JMo_List(Call ... ca) {
        this.list = null;
        this.init = ca;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.init != null) {
            this.list = new ArrayList();
            Call[] callArray = this.init;
            int n = this.init.length;
            int n2 = 0;
            while (n2 < n) {
                Call ca = callArray[n2];
                I_Object o = cr.execInit(ca, null);
                o = Lib_Convert.getValue(cr, o);
                this.list.add(o);
                ++n2;
            }
            this.init = null;
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "+": 
            case "add": 
            case "join": {
                return A_Object.stdResult(this.add(cr));
            }
            case "delete": 
            case "-": {
                return A_Object.stdResult(this.removePos(cr));
            }
            case "*": 
            case "mul": {
                return A_Object.stdResult(this.multiply(cr));
            }
            case "remove": 
            case "--": {
                return A_Object.stdResult(this.removeItems(cr));
            }
            case "insert": {
                return A_Object.stdResult(this.insert(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.clear(cr));
            }
            case "swap": {
                return A_Object.stdResult(this.swap(cr));
            }
            case "adjust": {
                return A_Object.stdResult(this.adjust(cr));
            }
            case "concat": 
            case "++": {
                return A_Object.stdResult(this.concat(cr));
            }
            case "addAll": {
                return A_Object.stdResult(this.addAll(cr));
            }
            case "subtractAll": 
            case "subAll": 
            case "removeAll": {
                return A_Object.stdResult(this.subAll(cr));
            }
            case "slice": 
            case "intersect": {
                return A_Object.stdResult(this.slice(cr));
            }
            case "init": {
                this.initList(cr);
                return A_Object.stdResult(this);
            }
            case "shuffle": {
                return A_Object.stdResult(this.shuffle(cr));
            }
            case "reverse": {
                return A_Object.stdResult(this.reverse(cr));
            }
            case "uniq": {
                return A_Object.stdResult(this.uniq(cr));
            }
            case "only": {
                return A_Object.stdResult(this.only(cr));
            }
            case "has": 
            case "knows": {
                return A_Object.stdResult(this.knows(cr));
            }
            case "search": 
            case "searchFirst": {
                return A_Object.stdResult(this.search(cr, true));
            }
            case "searchLast": {
                return A_Object.stdResult(this.search(cr, false));
            }
            case "each": {
                return this.each(cr);
            }
            case "eachVertical": {
                return this.eachVertical(cr);
            }
            case "combine": 
            case "implode": {
                return A_Object.stdResult(this.implode(cr));
            }
            case "unfold": {
                return A_Object.stdResult(this.unfold(cr));
            }
            case "flatten": {
                return A_Object.stdResult(this.flatten(cr));
            }
            case "format": {
                return A_Object.stdResult(this.format(cr));
            }
            case "min": {
                return A_Object.stdResult(this.min(cr));
            }
            case "max": {
                return A_Object.stdResult(this.max(cr));
            }
            case "sum": {
                return A_Object.stdResult(this.sum(cr));
            }
            case "average": 
            case "avg": {
                return A_Object.stdResult(this.average(cr));
            }
            case "count": {
                return A_Object.stdResult(this.count(cr));
            }
            case "cut": {
                return A_Object.stdResult(this.cut(cr));
            }
            case "area": {
                return A_Object.stdResult(this.area(cr));
            }
            case "end": {
                return A_Object.stdResult(this.endPos(cr));
            }
            case "left": {
                return A_Object.stdResult(this.left(cr));
            }
            case "right": {
                return A_Object.stdResult(this.right(cr));
            }
            case "start": {
                return A_Object.stdResult(this.startPos(cr));
            }
            case "filter": {
                return A_Object.stdResult(this.filter(cr, method));
            }
            case "map": {
                return A_Object.stdResult(this.map(cr, method));
            }
            case "sort": {
                return A_Object.stdResult(this.sort(cr, method));
            }
            case "reduce": {
                return A_Object.stdResult(this.reduce(cr, method));
            }
            case "amount": {
                return A_Object.stdResult(this.amount(cr, method));
            }
            case "fixLength": {
                cr.pars(this, new Class[0]);
                this.fixedLength = true;
                return A_Object.stdResult(this);
            }
            case "fixTypes": {
                cr.pars(this, new Class[0]);
                this.fixedTypes = true;
                return A_Object.stdResult(this);
            }
            case "fixType": {
                this.fixType(cr);
                return A_Object.stdResult(this);
            }
            case "toMap": {
                return A_Object.stdResult(this.toMap(cr));
            }
            case "store": {
                return A_Object.stdResult(this.store(cr));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        return this.list;
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cr));
    }

    public ArrayList<I_Object> getInternalObject() {
        return this.list;
    }

    public void internalAdd(I_Object o) {
        if (this.fixedLength) {
            Err.forbidden(o);
        }
        this.list.add(o);
    }

    public Bool knows(CallRuntime cr) {
        I_Object o = cr.pars(this, I_Object.class)[0];
        for (I_Object lo : this.list) {
            if (!lo.equals(o)) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    public I_Atomic search(CallRuntime cr, boolean first) {
        I_Object o = cr.pars(this, I_Object.class)[0];
        if (first) {
            int i = 0;
            while (i < this.list.size()) {
                if (this.list.get(i).compareTo(o) == 0) {
                    return new Int(i + 1);
                }
                ++i;
            }
        } else {
            int i = this.list.size() - 1;
            while (i >= 0) {
                if (this.list.get(i).compareTo(o) == 0) {
                    return new Int(i + 1);
                }
                --i;
            }
        }
        return Nil.NIL;
    }

    @Override
    protected int sequenceSize() {
        return this.list.size();
    }

    @Override
    public String toDebug(CallRuntime cr) {
        String s = this.list == null ? "null" : Lib_Output.toString(this.list, true);
        return "List(" + s + ")";
    }

    @Override
    public String toString() {
        String s = this.list == null ? "null" : Lib_Output.toString(this.list, true);
        return "[" + s + "]";
    }

    private JMo_List add(CallRuntime cr) {
        I_Object[] oa = cr.parsVarArgs(this, 1, 0);
        this.iFixedLength(cr);
        this.iFixedType(cr, oa);
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            this.list.add(o);
            ++n2;
        }
        return this;
    }

    private JMo_List multiply(CallRuntime cr) {
        I_Object par = cr.pars(this, A_IntNumber.class)[0];
        int value = Lib_Convert.getIntValue(cr, par);
        Lib_Error.ifTooLow(cr, 1, value);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int i = 0;
        while (i < value) {
            result.add(new JMo_List((ArrayList)this.list.clone()));
            ++i;
        }
        return new JMo_List(result);
    }

    private JMo_List insert(CallRuntime cr) {
        I_Object[] oa = cr.pars(this, Int.class, null);
        this.iFixedLength(cr);
        this.iFixedType(cr, oa);
        int pos = Lib_Convert.getIntValue(cr, oa[0]);
        if (pos == this.list.size() + 1) {
            this.list.add(oa[1]);
        } else {
            Lib_Error.ifNotBetween(cr, 1, this.list.size() + 1, pos, "position");
            this.list.add(pos - 1, oa[1]);
        }
        return this;
    }

    private JMo_List area(CallRuntime cr) {
        I_Object[] oa = cr.pars(this, Int.class, Int.class);
        int start = ((Int)oa[0]).getValue();
        int end = ((Int)oa[1]).getValue();
        int size = this.list.size();
        Lib_Error.ifEmpty(cr, this.list.size(), "List");
        Lib_Error.ifNotBetween(cr, 1, Math.min(end, size), start, "start");
        Lib_Error.ifNotBetween(cr, Math.max(1, start), size, end, "end");
        return this.iCutCopy(cr, start, Math.min(this.list.size(), end));
    }

    private JMo_List concat(CallRuntime cr) {
        JMo_List list2 = (JMo_List)cr.pars(this, JMo_List.class)[0];
        ArrayList<I_Object> newList = new ArrayList<I_Object>();
        newList.addAll(this.list);
        newList.addAll(list2.getInternalObject());
        return new JMo_List(newList);
    }

    private JMo_List addAll(CallRuntime cr) {
        JMo_List list2 = (JMo_List)cr.pars(this, JMo_List.class)[0];
        this.iFixedLength(cr);
        if (this.fixedType != null) {
            for (I_Object obj : list2.getInternalObject()) {
                this.iFixedType(cr, obj);
            }
        }
        this.list.addAll(list2.getInternalObject());
        return this;
    }

    private JMo_List subAll(CallRuntime cr) {
        JMo_List list2 = (JMo_List)cr.pars(this, JMo_List.class)[0];
        this.iFixedLength(cr);
        this.list.removeAll(list2.list);
        return this;
    }

    private JMo_List slice(CallRuntime cr) {
        JMo_List list2 = (JMo_List)cr.pars(this, JMo_List.class)[0];
        ArrayList<I_Object> list3 = new ArrayList<I_Object>();
        for (I_Object o1 : this.list) {
            if (!list2.list.contains(o1)) continue;
            list3.add(o1);
        }
        return new JMo_List(list3);
    }

    private JMo_Map toMap(CallRuntime cr) {
        JMo_List keys = (JMo_List)cr.pars(this, JMo_List.class)[0];
        return new JMo_Map((ArrayList)keys.list.clone(), (ArrayList)this.list.clone());
    }

    @Override
    protected JMo_List copy(CallRuntime cr) {
        cr.pars(this, new Class[0]);
        ArrayList copy = (ArrayList)this.list.clone();
        return new JMo_List(copy);
    }

    private JMo_List cut(CallRuntime cr) {
        I_Object[] oa = cr.pars(this, Int.class, Int.class);
        int start = ((Int)oa[0]).getValue();
        int len = ((Int)oa[1]).getValue();
        Lib_Error.ifEmpty(cr, this.list.size(), "List");
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), start, "start");
        if (len == 0) {
            return new JMo_List(new ArrayList<I_Object>());
        }
        if (len > this.list.size()) {
            len = this.list.size() - start + 1;
        }
        return this.iCutCopy(cr, start, Math.min(this.list.size(), start + len - 1));
    }

    private ObjectCallResult each(CallRuntime cpOld) {
        I_Object[] pars = cpOld.parsFlex(this, 0, 1);
        if (cpOld.getStream() == null && cpOld.getCallBlock() == null) {
            throw new CodeError(cpOld, "No Stream or Block for 'each'", null);
        }
        Handle_Loop handle = new Handle_Loop(this);
        CallRuntime cpNew = cpOld.copyLoop(handle);
        BlockExecArgs args = new BlockExecArgs(pars);
        I_Object result = this;
        for (I_Object it : this.list) {
            handle.startLap();
            result = Lib_Exec.execBlockStream(cpNew, args, it);
            result = Lib_Exec.loopResult(result);
            if (!(result instanceof Return)) continue;
            return ((Return)result).getLoopResult();
        }
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult eachVertical(CallRuntime cpOld) {
        I_Object[] pars = cpOld.parsFlex(this, 0, 1);
        if (cpOld.getStream() == null && cpOld.getCallBlock() == null) {
            throw new CodeError(cpOld, "No Stream or Block for 'eachAll'", null);
        }
        Handle_Loop handle = new Handle_Loop(this);
        CallRuntime cpNew = cpOld.copyLoop(handle);
        BlockExecArgs args = new BlockExecArgs(pars);
        I_Object result = this;
        int maxItems = 1;
        int pos = 1;
        while (pos <= maxItems) {
            handle.startLap();
            ArrayList<I_Object> cur_al = new ArrayList<I_Object>();
            for (I_Object item : this.list) {
                if ((item = Lib_Convert.getValue(cpNew, item)) instanceof I_AutoBlockList) {
                    ArrayList<I_Object> abl = ((I_AutoBlockList)((Object)item)).autoBlockToList(cpNew.copyNil());
                    int len = abl.size();
                    if (len > maxItems) {
                        maxItems = len;
                    }
                    Nil o = len >= pos ? abl.get(pos - 1) : Nil.NIL;
                    cur_al.add(o);
                    continue;
                }
                cur_al.add(pos == 1 ? item : Nil.NIL);
            }
            JMo_List cur = new JMo_List(cur_al);
            result = Lib_Exec.execBlockStream(cpNew, args, cur);
            if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            ++pos;
        }
        return new ObjectCallResult(result, true);
    }

    private JMo_List filter(CallRuntime cr, String method) {
        Lib_Error.ifPars(cr.parCount(), 1, 2, cr);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            Bool ok = (Bool)cr.copyEach(method).parsEach(this, 0, new I_Object[]{test}, Bool.class);
            if (ok.getValue().booleanValue()) {
                result.add(test);
            }
            ++p;
        }
        return new JMo_List(result);
    }

    private JMo_List map(CallRuntime cr, String method) {
        Lib_Error.ifPars(cr.parCount(), 1, 2, cr);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            I_Object[] each = new I_Object[]{test};
            I_Object testr = cr.copyEach(method).parsEach(this, 0, each, I_Object.class);
            result.add(testr);
            ++p;
        }
        return new JMo_List(result);
    }

    private I_Object reduce(CallRuntime cr, String method) {
        Lib_Error.ifPars(cr.parCount(), 2, 3, cr);
        I_Object sum = cr.parsOneAdvance(this, 0, I_Object.class);
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            I_Object[] each = new I_Object[]{sum, test};
            sum = cr.copyEach(method).parsEach(this, 1, each, I_Object.class);
            ++p;
        }
        return sum;
    }

    private Int amount(CallRuntime cr, String method) {
        Lib_Error.ifPars(cr.parCount(), 1, 2, cr);
        int result = 0;
        for (I_Object test : this.list) {
            Bool ok = (Bool)cr.copyEach(method).parsEach(this, 0, new I_Object[]{test}, Bool.class);
            if (!ok.getValue().booleanValue()) continue;
            ++result;
        }
        return new Int(result);
    }

    private JMo_List unfold(CallRuntime cr) {
        cr.pars();
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        for (I_Object item : this.list) {
            if (item instanceof I_AutoBlockList) {
                ArrayList<I_Object> abl = ((I_AutoBlockList)((Object)item)).autoBlockToList(cr.copyNil());
                for (I_Object o : abl) {
                    result.add(o);
                }
                continue;
            }
            result.add(item);
        }
        return new JMo_List(result);
    }

    private JMo_List flatten(CallRuntime cr) {
        cr.pars();
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        this.internalFlatten(result, this);
        return new JMo_List(result);
    }

    private void internalFlatten(ArrayList<I_Object> result, JMo_List current) {
        for (I_Object item : current.getInternalObject()) {
            if (item instanceof JMo_List) {
                this.internalFlatten(result, (JMo_List)item);
                continue;
            }
            result.add(item);
        }
    }

    @Override
    protected I_Object first(CallRuntime cr) {
        cr.pars();
        return this.list.size() == 0 ? Nil.NIL : this.list.get(0);
    }

    @Override
    protected I_Object last(CallRuntime cr) {
        cr.pars();
        int len = this.list.size();
        return len == 0 ? Nil.NIL : this.list.get(len - 1);
    }

    private JMo_List startPos(CallRuntime cr) {
        I_Object o = cr.pars(this, Int.class)[0];
        int par = ((Int)o).getValue();
        int size = this.list.size();
        Lib_Error.ifNotBetween(cr, 1, size, par, "position");
        return this.iCutCopy(cr, par, size);
    }

    @Override
    protected I_Object sequenceGetPull(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.parsVarArgs(this, 1, 0);
        Lib_Error.ifPars(oa.length, 1, Integer.MAX_VALUE, cr);
        if (oa.length == 1) {
            I_AtomicValue oav = (I_AtomicValue)cr.parType(oa[0], I_AtomicValue.class);
            int oi = Lib_Convert.getIntValue(cr, oav);
            int pos = Lib_Sequence.realPos(cr, oi, this.list.size(), lazy);
            return pos == -1 ? Nil.NIL : this.list.get(pos - 1);
        }
        return this.sequenceDeepGet(cr, oa, 0, lazy);
    }

    private Str implode(CallRuntime cr) {
        I_Object[] pars = cr.parsFlex(this, 0, 1);
        if (pars.length == 0) {
            StringBuilder sb = new StringBuilder();
            for (I_Object o : this.list) {
                sb.append(o.toString());
            }
            return new Str(sb.toString());
        }
        I_AtomicValue atomic = (I_AtomicValue)cr.parType(pars[0], I_AtomicValue.class);
        String delimiter = Lib_Convert.getStringValue(cr, atomic);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.list.size()) {
            I_Object o = this.list.get(i);
            String s = Lib_Convert.getStringValue(cr, o);
            sb.append(s);
            if (i != this.list.size() - 1) {
                sb.append(delimiter);
            }
            ++i;
        }
        return new Str(sb.toString());
    }

    private void initList(CallRuntime cr) {
        I_Object[] pars = cr.pars(this, A_IntNumber.class, I_Object.class);
        I_Object obj = pars[1];
        int num = Lib_Convert.getIntValue(cr, pars[0]);
        int i = 0;
        while (i < num) {
            this.list.add(obj);
            ++i;
        }
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.list.size() == 0;
    }

    private JMo_List left(CallRuntime cr) {
        I_Object o = cr.pars(this, Int.class)[0];
        int left = ((Int)o).getValue();
        Lib_Error.ifTooLow(cr, 0, left);
        if (left == 0) {
            return new JMo_List(new ArrayList<I_Object>());
        }
        if (left > this.list.size()) {
            return new JMo_List((ArrayList)this.list.clone());
        }
        return this.iCutCopy(cr, 1, Math.min(left, this.list.size()));
    }

    private I_Object max(CallRuntime cr) {
        cr.pars();
        I_Object result_o = null;
        Double result_d = null;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cr, o);
            if (result_o != null && !(d > result_d)) continue;
            result_o = o;
            result_d = d;
        }
        return result_o;
    }

    private I_Object min(CallRuntime cr) {
        cr.pars();
        I_Object result_o = null;
        Double result_d = null;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cr, o);
            if (result_o != null && !(d < result_d)) continue;
            result_o = o;
            result_d = d;
        }
        return result_o;
    }

    private I_Object average(CallRuntime cr) {
        cr.pars();
        double result = 0.0;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cr, o);
            result += d / (double)this.list.size();
        }
        return new Dec(result);
    }

    private I_Object count(CallRuntime cr) {
        I_Object search = cr.pars(this, I_Object.class)[0];
        int result = 0;
        for (I_Object o : this.list) {
            if (!o.equals(search)) continue;
            ++result;
        }
        return new Int(result);
    }

    private I_Object sum(CallRuntime cr) {
        cr.pars();
        double result = 0.0;
        for (I_Object o : this.list) {
            result += Lib_Convert.getDoubleValue(cr, o);
        }
        return new Dec(result);
    }

    private JMo_List only(CallRuntime cr) {
        I_Object[] pars = cr.parsVarArgs(this, 1, 0);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            I_Object[] i_ObjectArray = pars;
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                String teststr;
                I_Object par = i_ObjectArray[n2];
                if (par instanceof JMo_Regex) {
                    JMo_Regex regex = (JMo_Regex)par;
                    teststr = Lib_Convert.getStringValue(cr, test);
                    if (teststr.matches(regex.toString())) {
                        result.add(test);
                    }
                } else if (par instanceof Str) {
                    String search = Lib_Convert.getStringValue(cr, par);
                    teststr = Lib_Convert.getStringValue(cr, test);
                    if (teststr.equals(search)) {
                        result.add(test);
                    }
                } else if (test.compareTo(par) == 0) {
                    result.add(test);
                }
                ++n2;
            }
            ++p;
        }
        return new JMo_List(result);
    }

    private JMo_List removeItems(CallRuntime cr) {
        I_Object[] oa = cr.parsVarArgs(this, 1, 0);
        this.iFixedLength(cr);
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            int i = this.list.size() - 1;
            while (i >= 0) {
                if (this.list.get(i).equals(o)) {
                    this.list.remove(i);
                }
                --i;
            }
            ++n2;
        }
        return this;
    }

    private JMo_List removePos(CallRuntime cr) {
        Int o = (Int)cr.pars(this, Int.class)[0];
        this.iFixedLength(cr);
        int oi = Lib_Convert.getIntValue(cr, o);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), oi, "position");
        this.list.remove(oi - 1);
        return this;
    }

    private JMo_List clear(CallRuntime cr) {
        cr.pars(this, new Class[0]);
        this.iFixedLength(cr);
        this.list.clear();
        return this;
    }

    private JMo_List swap(CallRuntime cr) {
        I_Object[] pars = cr.pars(this, A_IntNumber.class, A_IntNumber.class);
        int pos1 = Lib_Convert.getIntValue(cr, pars[0]);
        int pos2 = Lib_Convert.getIntValue(cr, pars[1]);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos1, "position 1");
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos2, "position 2");
        I_Object buffer = this.list.get(--pos1);
        this.list.set(pos1, this.list.get(--pos2));
        this.list.set(pos2, buffer);
        return this;
    }

    private JMo_List adjust(CallRuntime cr) {
        I_Object[] pars = cr.pars(this, A_IntNumber.class, I_Object.class);
        this.iFixedLength(cr);
        int len = Lib_Convert.getIntValue(cr, pars[0]);
        I_Object fill = pars[1];
        this.iFixedType(cr, fill);
        Lib_Error.ifTooLow(cr, 0, len);
        while (this.list.size() > len) {
            this.list.remove(this.list.size() - 1);
        }
        while (this.list.size() < len) {
            this.list.add(fill);
        }
        return this;
    }

    private JMo_List reverse(CallRuntime cr) {
        cr.pars(this, new Class[0]);
        ArrayList<I_Object> dest = new ArrayList<I_Object>();
        for (I_Object o : this.list) {
            dest.add(0, o);
        }
        this.list = dest;
        return this;
    }

    private JMo_List right(CallRuntime cr) {
        I_Object o = cr.pars(this, Int.class)[0];
        int right = ((Int)o).getValue();
        Lib_Error.ifTooLow(cr, 0, right);
        if (right == 0) {
            return new JMo_List(new ArrayList<I_Object>());
        }
        if (right > this.list.size()) {
            return new JMo_List((ArrayList)this.list.clone());
        }
        return this.iCutCopy(cr, Math.max(1, this.list.size() - right + 1), this.list.size());
    }

    @Override
    protected void sequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.parsVarArgs(this, 2, 1);
        if (oa.length > 2) {
            this.sequenceDeepSet(cr, oa, 1, oa[0], lazy);
            return;
        }
        int wanted = Lib_Convert.getIntValue(cr, oa[1]);
        if (lazy) {
            while (Math.abs(wanted) > this.list.size()) {
                this.list.add(Nil.NIL);
            }
        }
        int pos = Lib_Sequence.realPos(cr, wanted, this.list.size(), lazy);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos, "position");
        I_Object o = oa[0];
        if (this.fixedTypes) {
            Class<?> t = o.getClass();
            I_Object curo = this.list.get(pos);
            Class<?> curt = curo.getClass();
            if (t != Nil.class && !curt.isAssignableFrom(t)) {
                throw new ExecError(cr, "Invalid Type for List-Position!", "(" + Lib_Type.getName(curt, curo) + ") <-- (" + Lib_Type.getName(t, o) + ") " + o);
            }
        }
        this.list.set(pos - 1, o);
    }

    private JMo_List shuffle(CallRuntime cr) {
        cr.pars(this, new Class[0]);
        int[] rnd = Lib_Random.getIntArraySet(0, this.list.size() - 1);
        ArrayList<I_Object> dest = new ArrayList<I_Object>();
        int[] nArray = rnd;
        int n = rnd.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            dest.add(this.list.get(i));
            ++n2;
        }
        this.list = dest;
        return this;
    }

    private JMo_List sort(CallRuntime cr, String method) {
        int parCount = cr.parCount();
        Lib_Error.ifPars(parCount, 0, 2, cr);
        if (parCount == 0) {
            cr.pars();
            this.list.sort((o1, o2) -> {
                Object so1 = o1;
                Object so2 = o2;
                if (o1 instanceof I_AtomicValue) {
                    so1 = ((I_AtomicValue)o1).getValue();
                }
                if (o2 instanceof I_AtomicValue) {
                    so2 = ((I_AtomicValue)o2).getValue();
                }
                return Lib_Compare.isEqual(so1, so2) ? 0 : (Lib_Compare.isGreater(so1, so2) ? 1 : -1);
            });
            return this;
        }
        int l = 1;
        while (l < this.list.size()) {
            int smallest = l;
            int m = l + 1;
            while (m <= this.list.size()) {
                I_Object buffer1 = this.list.get(smallest - 1);
                I_Object buffer2 = this.list.get(m - 1);
                I_Object[] test = new I_Object[]{buffer1, buffer2};
                Bool correct = (Bool)cr.copyEach(method).parsEach(this, 0, test, Bool.class);
                if (!correct.getValue().booleanValue()) {
                    smallest = m;
                }
                ++m;
            }
            if (l != smallest) {
                int pos1 = smallest - 1;
                int pos2 = l - 1;
                I_Object buffer1 = this.list.get(pos1);
                I_Object buffer2 = this.list.get(pos2);
                this.list.set(pos1, buffer2);
                this.list.set(pos2, buffer1);
            }
            ++l;
        }
        return this;
    }

    private JMo_List endPos(CallRuntime cr) {
        I_Object o = cr.pars(this, Int.class)[0];
        int par = ((Int)o).getValue();
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), par, "position");
        return this.iCutCopy(cr, 1, par);
    }

    private JMo_List uniq(CallRuntime cr) {
        cr.pars();
        int p = 0;
        while (p < this.list.size() - 1) {
            I_Object search = this.list.get(p);
            int q = this.list.size() - 1;
            while (q > p) {
                if (this.list.get(q).equals(search)) {
                    this.list.remove(q);
                }
                --q;
            }
            ++p;
        }
        return this;
    }

    private JMo_List store(CallRuntime cr) {
        I_Object[] pars = cr.getPars(this);
        if (pars.length != this.list.size()) {
            throw new CodeError(cr, "Invalid Parameter-Count", "Got " + pars.length + ", need equal to listsize: " + this.list.size());
        }
        int pi = 0;
        while (pi < this.list.size()) {
            I_Object par = cr.parTypeExt(pars[pi], VarLet.class, Nil.class);
            if (!(par instanceof Nil)) {
                Var v = ((VarLet)par).getVar();
                v.let(cr, cr, this.list.get(pi));
            }
            ++pi;
        }
        return this;
    }

    private Str format(CallRuntime cr) {
        String form = ((Str)cr.pars(this, Str.class)[0]).getValue();
        int listPos = 0;
        int formPos = 0;
        StringBuilder sb = new StringBuilder();
        while (formPos < form.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(form, formPos);
            formPos += ((String)part.o2).length();
            if (!((Boolean)part.o1).booleanValue() || listPos >= this.list.size()) {
                sb.append((String)part.o2);
                continue;
            }
            sb.append(Lib_StrFormat.format(cr, (String)part.o2, this.list.get(listPos++)));
        }
        return new Str(sb.toString());
    }

    private void fixType(CallRuntime cr) {
        Str o = (Str)cr.pars(this, Str.class)[0];
        String type = Lib_Convert.getStringValue(cr, o);
        if (!ObjectManager.isTypeKnown(cr, type)) {
            throw new ExecError(cr, "Unknown type", "Unknown type: " + type);
        }
        this.fixedType = type;
        int counter = 0;
        for (I_Object item : this.list) {
            ++counter;
            if (Lib_Type.isInstanceOf(item, this.fixedType)) continue;
            String sTypes = Lib_Type.typesToString(item);
            throw new ExecError(cr, "Invalid type of item in list", "Type \"" + this.fixedType + "\" needed, but types of item at position " + counter + " are: " + sTypes);
        }
    }

    private JMo_List iCutCopy(CallRuntime cr, int start, int end) {
        Lib_Error.ifTooLow(cr, start, end);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int i = start - 1;
        while (i < end) {
            result.add(this.list.get(i));
            ++i;
        }
        return new JMo_List(result);
    }

    private void iFixedLength(CallRuntime cr) {
        if (this.fixedLength) {
            throw new ExecError(cr, "Can't change size of fixed List", "Adding/Removing elements is not allowed!");
        }
    }

    private void iFixedType(CallRuntime cr, I_Object[] oa) {
        if (this.fixedType != null) {
            I_Object[] i_ObjectArray = oa;
            int n = oa.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object obj = i_ObjectArray[n2];
                this.iFixedType(cr, obj);
                ++n2;
            }
        }
    }

    private void iFixedType(CallRuntime cr, I_Object obj) {
        if (this.fixedType != null && !Lib_Type.isInstanceOf(obj, this.fixedType)) {
            throw new ExecError(cr, "Invalid type for fixed List.", "Fixed type of List is \"" + this.fixedType + "\" but object types are: " + Lib_Type.typesToString(obj));
        }
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.parType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPos(cr, i, this.list.size(), lazy);
        if (pos == -1 || pos > this.list.size()) {
            if (lazy) {
                return Nil.NIL;
            }
            Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos, "position in list");
        }
        if (offset == keys.length - 1) {
            return this.list.get(pos - 1);
        }
        I_Object deeper = this.list.get(pos - 1);
        if (!(deeper instanceof A_Sequence)) {
            throw new ExecError(cr, "Invalid type of item.", "Item at position " + (offset + 1) + " isn't a sequence, so I can't go into it!");
        }
        A_Sequence deeper2 = (A_Sequence)deeper;
        return deeper2.sequenceDeepGet(cr, keys, offset + 1, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.parType(keys[offset], A_IntNumber.class);
        int wanted = Lib_Convert.getIntValue(cr, oi);
        if (lazy) {
            while (Math.abs(wanted) > this.list.size()) {
                this.list.add(Nil.NIL);
            }
        }
        int pos = Lib_Sequence.realPos(cr, wanted, this.list.size(), lazy);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos, "position");
        if (offset == keys.length - 1) {
            this.list.set(pos - 1, value);
        } else {
            I_Object deeper = this.list.get(pos - 1);
            if (deeper == Nil.NIL && lazy) {
                deeper = new JMo_List();
                this.list.set(pos - 1, deeper);
            }
            if (!(deeper instanceof A_Sequence)) {
                throw new ExecError(cr, "Invalid type of item.", "Item at position " + (offset + 1) + " isn't a sequence, so I can't go into it!");
            }
            A_Sequence deeper2 = (A_Sequence)deeper;
            deeper2.sequenceDeepSet(cr, keys, offset + 1, value, lazy);
        }
    }

    @Override
    protected JMo_List sequenceSelect(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.parsVarArgs(this, 0, 0);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            I_AtomicValue oav = (I_AtomicValue)cr.parType(o, I_AtomicValue.class);
            int oi = Lib_Convert.getIntValue(cr, oav);
            int pos = Lib_Sequence.realPos(cr, oi, this.list.size(), lazy);
            Nil g = pos == -1 ? Nil.NIL : this.list.get(pos - 1);
            result.add(g);
            ++n2;
        }
        return new JMo_List(result);
    }
}

