/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.pseudo;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.filter.FilterText;
import de.mn77.base.error.Err;
import de.mn77.base.error.I_Error;
import org.jmo_lang.error.CustomError;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.ParCallBuffer;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Output;

public class JMo_Error
extends A_Object {
    private final Throwable ex;
    private final ParCallBuffer par1;
    private final ParCallBuffer par2;

    public JMo_Error(Throwable t) {
        this.ex = t;
        this.par1 = null;
        this.par2 = null;
    }

    public JMo_Error(Call par1, Call par2) {
        this.ex = new Throwable();
        this.par1 = new ParCallBuffer(par1);
        this.par2 = new ParCallBuffer(par2);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.par1 != null) {
            this.par1.init(cr, this, Str.class);
        }
        if (this.par2 != null) {
            this.par2.init(cr, this, Str.class);
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "throw": {
                this.iThrow(cr);
                return new ObjectCallResult(Nil.NIL, true);
            }
            case "show": {
                return A_Object.stdResult(this.show(cr));
            }
            case "getMessage": {
                cr.pars();
                return A_Object.stdResult(new Str(this.iMessage()));
            }
            case "getSource": {
                return this.iErrorBaseDebug(cr, EBD.SOURCE);
            }
            case "getCall": {
                return this.iErrorBaseDebug(cr, EBD.CALL);
            }
            case "getDetail": {
                return this.iErrorBaseDebug(cr, EBD.DETAIL);
            }
            case "getInstance": {
                return this.iErrorBaseDebug(cr, EBD.INSTANCE);
            }
            case "getGroup": {
                return this.iErrorBaseDebug(cr, EBD.GROUP);
            }
            case "getFile": {
                cr.pars();
                return A_Object.stdResult(this.fileLine(cr, true));
            }
            case "getLine": {
                cr.pars();
                return A_Object.stdResult(this.fileLine(cr, false));
            }
            case "getInfo": {
                return A_Object.stdResult(this.iInfo(cr));
            }
        }
        return null;
    }

    private I_Object iInfo(CallRuntime cr) {
        cr.pars();
        String result = this.iMessage();
        String value = this.iErrorBaseDebugText(cr, EBD.DETAIL);
        if (value != null) {
            result = String.valueOf(result) + " | " + value;
        }
        result = String.valueOf(result) + " | " + this.iErrorBaseDebugText(cr, EBD.SOURCE);
        return new Str(result);
    }

    private ObjectCallResult iErrorBaseDebug(CallRuntime cr, EBD source) {
        cr.pars();
        String value = this.iErrorBaseDebugText(cr, source);
        return A_Object.stdResult(value == null ? Nil.NIL : new Str(value));
    }

    private String iErrorBaseDebugText(CallRuntime cr, EBD source) {
        if (!(this.ex instanceof ErrorBaseDebug)) {
            return null;
        }
        String s = null;
        ErrorBaseDebug ebd = (ErrorBaseDebug)this.ex;
        switch (source) {
            case SOURCE: {
                s = ebd.getSource();
                break;
            }
            case CALL: {
                s = ebd.getCall();
                break;
            }
            case DETAIL: {
                s = ebd.getDetail();
                break;
            }
            case INSTANCE: {
                s = ebd.getInstance();
                break;
            }
            case GROUP: {
                s = ebd.getGroup().title;
                break;
            }
            default: {
                Err.impossible(new Object[]{source});
            }
        }
        return s;
    }

    private I_Object fileLine(CallRuntime cr, boolean useFile) {
        cr.pars();
        if (!(this.ex instanceof ErrorBaseDebug)) {
            return Nil.NIL;
        }
        String source = ((ErrorBaseDebug)this.ex).getSource();
        if (useFile) {
            String file = FilterText.to(":", true, source);
            if (file.length() > 0 && file.charAt(file.length() - 1) == ':') {
                file = file.substring(0, file.length() - 1);
            }
            return new Str(file);
        }
        String line = FilterText.right(":", source);
        if (line.length() > 0 && line.charAt(0) == ':') {
            line = line.substring(1);
        }
        return line.length() == 0 ? Nil.NIL : new Int(Integer.parseInt(line));
    }

    private void iThrow(CallRuntime cr) {
        cr.pars();
        if (this.par1 != null && this.par2 != null) {
            throw new CustomError(cr, Lib_String.unquote(this.par1.toString()), Lib_String.unquote(this.par2.toString()));
        }
        throw new CustomError(cr, "Thrown again", this.toString());
    }

    public I_Object show(CallRuntime cr) {
        cr.pars();
        String className = this.ex.getClass().getSimpleName();
        ErrorBaseDebug ebd = this.ex instanceof ErrorBaseDebug ? (ErrorBaseDebug)this.ex : null;
        String grp = ebd != null ? String.valueOf(ebd.getGroup().detail) + " (" + className + ")" : className;
        String s = "Error   : " + grp;
        s = String.valueOf(s) + "\nMessage : ";
        String message = this.iMessage();
        s = String.valueOf(s) + (message != null ? message : "Unknown");
        if (this.ex instanceof I_Error) {
            for (Object o : ((I_Error)((Object)this.ex)).getDetails()) {
                s = String.valueOf(s) + "\n" + ConvObject.toText(o);
            }
        }
        Lib_Output.out(cr.getApp(), s, true);
        return this;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        if (this.par1 != null && this.par2 != null) {
            return "Error(" + this.par1.toDebug(cr) + "," + this.par2.toDebug(cr) + ")";
        }
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.par1 != null && this.par2 != null) {
            return "Error(" + this.par1.toString() + "," + this.par2.toString() + ")";
        }
        if (this.ex instanceof ErrorBaseDebug) {
            ErrorBaseDebug ebd = (ErrorBaseDebug)this.ex;
            String result = "Error(\"" + this.iMessage() + '\"';
            String value = String.valueOf('\"') + ebd.getDetail() + '\"';
            if (value != null) {
                result = String.valueOf(result) + "," + value;
            }
            result = String.valueOf(result) + ",\"" + ebd.getSource() + '\"';
            return String.valueOf(result) + ")";
        }
        return this.toString();
    }

    private String iMessage() {
        return this.par1 != null ? ((Str)this.par1.get()).getValue() : this.ex.getMessage();
    }

    private static enum EBD {
        SOURCE,
        CALL,
        DETAIL,
        INSTANCE,
        GROUP;

    }
}

