/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.Lib_FileSys;
import de.mn77.base.sys.file.Lib_TextFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.datetime.JMo_DateTime;
import org.jmo_lang.object.filesys.A_FileSys;
import org.jmo_lang.object.filesys.JMo_Dir;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Output;

public class JMo_File
extends A_FileSys
implements I_Object {
    private Call par;
    private File file = null;

    public JMo_File(Call par) {
        Err.ifNull(par);
        this.par = par;
    }

    public JMo_File(File file) {
        Err.ifNull(file);
        this.file = file;
        this.par = null;
    }

    @Override
    protected void init2(CallRuntime cr) {
        if (this.par != null) {
            I_Object filename = cr.execInit(this.par, null);
            if (!((filename = Lib_Convert.getValue(cr, filename)) instanceof Str)) {
                throw Err.invalid(filename.toDebug(cr));
            }
            String sFile = ((Str)filename).getValue();
            this.file = new File(sFile);
            this.par = null;
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        Err.ifNull(this.file);
        switch (method) {
            case "getSuffix": {
                return A_Object.stdResult(this.getSuffix(cr));
            }
            case "getPath": {
                return A_Object.stdResult(this.getPath(cr));
            }
            case "getDir": {
                return A_Object.stdResult(this.getDir(cr));
            }
            case "getSize": {
                return A_Object.stdResult(this.getSize(cr));
            }
            case "getDateCreate": 
            case "cDate": {
                return A_Object.stdResult(this.getDateCreate(cr));
            }
            case "getDateModify": 
            case "mDate": {
                return A_Object.stdResult(this.getDateModify(cr));
            }
            case "exec": 
            case "open": {
                return A_Object.stdResult(this.open(cr));
            }
            case "create": 
            case "touch": {
                return A_Object.stdResult(this.create(cr));
            }
            case "readLines": 
            case "lines": {
                return A_Object.stdResult(this.readLines(cr));
            }
            case "read": {
                return A_Object.stdResult(this.read(cr));
            }
            case "append": {
                return A_Object.stdResult(this.append(cr));
            }
            case "set": 
            case "write": {
                return A_Object.stdResult(this.write(cr));
            }
            case "rename": {
                return A_Object.stdResult(this.rename(cr));
            }
            case "move": {
                return A_Object.stdResult(this.move(cr));
            }
            case "delete": {
                return A_Object.stdResult(this.delete(cr));
            }
        }
        return null;
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        super.describe(cr, left);
        if (this.par != null) {
            this.par.describe(cr, left + 4);
        }
    }

    @Override
    public String toDebug(CallRuntime cr) {
        String p = Lib_Output.toDebug(cr, this.par);
        if (p.length() != 0) {
            p = "(" + p + ")";
        }
        return "File" + p;
    }

    @Override
    public String toString() {
        return this.file == null ? "Unknown File" : this.file.getAbsolutePath();
    }

    @Override
    public File getInternalFile() {
        return this.file;
    }

    protected JMo_File rename(CallRuntime cr) {
        Str par = (Str)cr.pars(this, Str.class)[0];
        String newName = Lib_Convert.getStringValue(cr, par);
        if (newName.contains(Sys.getSeperatorDir())) {
            throw new ExtError(cr, "File-Rename failed", "No target-path allowed");
        }
        newName = String.valueOf(this.file.getParent()) + Sys.getSeperatorDir() + newName;
        File newFile = new File(newName);
        boolean done = this.file.renameTo(newFile);
        if (!done) {
            throw new ExtError(cr, "File-Rename failed", String.valueOf(this.file.getAbsolutePath()) + " --> " + newFile.getAbsolutePath());
        }
        this.file = newFile;
        return this;
    }

    private Nil delete(CallRuntime cr) {
        boolean deleted;
        File f = this.getInternalFile();
        if (f.exists() && !(deleted = f.delete())) {
            throw new ExtError(cr, "File-Delete-Error", this.getInternalFile().getAbsolutePath());
        }
        return Nil.NIL;
    }

    private A_FileSys move(CallRuntime cr) {
        File source = this.file;
        boolean isDir = source.isDirectory();
        Str par = (Str)cr.pars(this, Str.class)[0];
        String newNamePath = Lib_Convert.getStringValue(cr, par);
        File target = new File(newNamePath);
        try {
            Files.move(source.toPath(), target.toPath(), new CopyOption[0]);
            this.file = target;
            return isDir ? new JMo_Dir(target) : new JMo_File(target);
        }
        catch (IOException e) {
            throw new ExtError(cr, "File-Move-Error", String.valueOf(e.getMessage()) + ": " + source.getAbsolutePath() + " --> " + target.getAbsolutePath());
        }
    }

    private JMo_File create(CallRuntime cr) {
        cr.pars();
        boolean ok = false;
        try {
            ok = this.file.createNewFile();
        }
        catch (IOException e) {
            ok = false;
        }
        if (!ok) {
            throw new ExtError(cr, "Can't create File", this.file.getAbsolutePath());
        }
        return this;
    }

    private JMo_Long getSize(CallRuntime cr) {
        cr.pars();
        return new JMo_Long(this.file.length());
    }

    private JMo_DateTime getDateModify(CallRuntime cr) {
        cr.pars();
        long l = this.file.lastModified();
        return new JMo_DateTime(new MDateTime(l));
    }

    private JMo_DateTime getDateCreate(CallRuntime cr) {
        BasicFileAttributes attr;
        cr.pars();
        try {
            attr = Files.readAttributes(this.file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new ExtError(cr, "File-Read-Error", e.getMessage());
        }
        long l = attr.creationTime().toMillis();
        return new JMo_DateTime(new MDateTime(l));
    }

    private Str getSuffix(CallRuntime cr) {
        cr.pars();
        String suffix = Lib_FileSys.getSuffix(this.file);
        return new Str(suffix);
    }

    private JMo_Dir getDir(CallRuntime cr) {
        cr.pars();
        String path = this.file.getAbsolutePath();
        return new JMo_Dir(new File(path));
    }

    private Str getPath(CallRuntime cr) {
        cr.pars();
        String path = this.file.getAbsolutePath();
        return new Str(path);
    }

    private JMo_File open(CallRuntime cr) {
        cr.pars();
        try {
            Lib_FileSys.start(this.file);
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "Can't create File", this.file.getAbsolutePath());
        }
        return this;
    }

    private Str read(CallRuntime cr) {
        cr.pars();
        try {
            String content = Lib_TextFile.read(this.file, true);
            return new Str(content);
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "File-Access-Error", e.getMessage());
        }
    }

    private JMo_List readLines(CallRuntime cr) {
        cr.pars(this, new Class[0]);
        ArrayList<I_Object> list = this.iReadLines(cr);
        return new JMo_List(list);
    }

    private ArrayList<I_Object> iReadLines(CallRuntime cr) {
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        try {
            I_List<String> lines = Lib_TextFile.readLines(this.file, true);
            for (String line : lines) {
                list.add(new Str(line));
            }
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "File read error", e.getMessage());
        }
        return list;
    }

    private JMo_File append(CallRuntime cr) {
        I_Object o = cr.pars(this, A_Atomic.class)[0];
        String s = Lib_Convert.getStringValue(cr, o);
        try {
            Lib_TextFile.append(this.file, s, true);
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "File-Access-Error", e.getMessage());
        }
        return this;
    }

    private JMo_File write(CallRuntime cr) {
        I_Object[] oa = cr.parsFlex(this, 1, 2);
        int last = oa.length - 1;
        I_Object so = cr.parType(oa[last], A_Atomic.class);
        String s = Lib_Convert.getStringValue(cr, so);
        try {
            if (oa.length == 1) {
                Lib_TextFile.set(this.file, s, true);
            } else {
                I_Object po = cr.parType(oa[0], A_IntNumber.class);
                int p = Lib_Convert.getIntValue(cr, po);
                Lib_Error.ifTooLow(cr, 1, p);
                Lib_TextFile.set(this.file, (long)p - 1L, s, true);
            }
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "File-Access-Error", e.getLocalizedMessage());
        }
        return this;
    }
}

