/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.classic;

import de.mn77.base.error.Err;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_ControlObject;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.ParCallBuffer;
import org.jmo_lang.struct.runtime.CallRuntime;

public class JMo_Switch
extends A_Object
implements I_ControlObject {
    private final ParCallBuffer value;

    public JMo_Switch(Call c) {
        Err.ifNull(c);
        this.value = new ParCallBuffer(c);
    }

    @Override
    public void init(CallRuntime cr) {
        this.value.init(cr, this, I_Object.class);
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "caseIf": {
                return this.switch_if(cr, method);
            }
            case "caseIs": 
            case "case": {
                return this.switch_is(cr);
            }
            case "default": {
                return new ObjectCallResult(this.iDefault(cr), true);
            }
        }
        return null;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "Switch(" + this.value.toDebug(cr) + ')';
    }

    @Override
    public String toString() {
        return "Switch(" + this.value.toString() + ')';
    }

    private ObjectCallResult switch_if(CallRuntime cr, String method) {
        cr.blockNecessary();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        I_Object res = this.value.get();
        I_Object[] each = new I_Object[]{res};
        Bool par = (Bool)cr.copyEach(method).parsEach(this, 0, each, Bool.class);
        if (par.getValue().booleanValue()) {
            try {
                res = block.execExt(cr, res);
            }
            catch (ReturnException e) {
                res = e.get();
            }
            return new ObjectCallResult(res, true);
        }
        if (stream != null) {
            res = cr.execInit(stream, this);
        }
        return new ObjectCallResult(res, true);
    }

    private ObjectCallResult switch_is(CallRuntime cr) {
        I_Object par = cr.pars(this, new Class[]{null})[0];
        cr.blockNecessary();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        I_Object res = this.value.get();
        if (this.value.get().equals(par)) {
            try {
                res = block.execExt(cr, res);
            }
            catch (ReturnException e) {
                res = e.get();
            }
            return new ObjectCallResult(res, true);
        }
        if (stream != null) {
            res = cr.execInit(stream, this);
        }
        return new ObjectCallResult(res, true);
    }

    private I_Object iDefault(CallRuntime cpOld) {
        Handle_Loop handle = new Handle_Loop(this);
        CallRuntime cpNew = cpOld.copyLoop(handle);
        Call stream = cpNew.getStream();
        Block block = cpNew.getCallBlock();
        I_Object res = this.value.get();
        handle.startLap();
        if (block != null) {
            try {
                res = block.execExt(cpNew, res);
            }
            catch (ReturnException e) {
                return e.get();
            }
        }
        if (stream != null) {
            res = cpNew.execInit(stream, res);
        }
        return res;
    }
}

