/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.classic.JMo_Switch;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.struct.JMo_KeyValue;
import org.jmo_lang.object.sys.JMo_Java;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Exec;

public abstract class A_Atomic
extends A_Object
implements I_AtomicValue {
    @Override
    public final void init(CallRuntime cr) {
    }

    @Override
    protected final ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "getLen": 
            case "getSize": 
            case "getLength": {
                return A_Object.stdResult(this.length(cr));
            }
            case "toBoolean": 
            case "toBool": {
                cr.pars();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.BOOL));
            }
            case "toChar": 
            case "toCharacter": {
                cr.pars();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.CHAR));
            }
            case "toDecimal": 
            case "toDec": {
                cr.pars();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.DEC));
            }
            case "toInt": 
            case "toInteger": {
                cr.pars();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.INT));
            }
            case "toByte": {
                cr.pars();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.BYTE));
            }
            case "toShort": {
                cr.pars();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.SHORT));
            }
            case "toLong": {
                cr.pars();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.LONG));
            }
            case "toFloat": {
                cr.pars();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.FLOAT));
            }
            case "toJava": {
                cr.pars();
                return A_Object.stdResult(this.toJava(cr));
            }
            case "if": {
                return this.doIf(cr, false, false, false);
            }
            case "ifNot": {
                return this.doIf(cr, true, false, false);
            }
            case "at": 
            case "is": {
                return this.doIf(cr, false, false, true);
            }
            case "atNot": 
            case "isNot": {
                return this.doIf(cr, true, false, true);
            }
            case "passIf": {
                return this.doIf(cr, false, true, false);
            }
            case "passIfNot": {
                return this.doIf(cr, true, true, false);
            }
            case "passAt": 
            case "passIs": {
                return this.doIf(cr, false, true, true);
            }
            case "passAtNot": 
            case "passIsNot": {
                return this.doIf(cr, true, true, true);
            }
            case "breakAt": 
            case "breakIs": {
                return this.breakAt(cr);
            }
            case "breakIf": {
                return this.breakIf(cr);
            }
            case "isLess": 
            case "<": {
                return A_Object.stdResult(this.comparsion(cr, COMPARE.L));
            }
            case "isGreater": 
            case ">": {
                return A_Object.stdResult(this.comparsion(cr, COMPARE.G));
            }
            case "<=": 
            case "isLessOrEqual": {
                return A_Object.stdResult(this.comparsion(cr, COMPARE.LE));
            }
            case "isGreaterOrEqual": 
            case ">=": {
                return A_Object.stdResult(this.comparsion(cr, COMPARE.GE));
            }
            case "->": 
            case "keyValue": {
                return A_Object.stdResult(this.keyvalue(cr));
            }
            case "switch": {
                Call ca = new Call(cr.getSurrBlock(), this, cr.getDebugInfo());
                JMo_Switch sw = new JMo_Switch(ca);
                return A_Object.stdResult(sw);
            }
            case "while": {
                return this.iWhile(cr, method);
            }
            case "repeat": {
                return this.iRepeat(cr, method);
            }
        }
        return this.call3(cr, method);
    }

    private I_Object keyvalue(CallRuntime cr) {
        I_Object o = cr.pars(this, I_Object.class)[0];
        return new JMo_KeyValue(this, o);
    }

    protected abstract ObjectCallResult call3(CallRuntime var1, String var2);

    protected abstract Int length(CallRuntime var1);

    protected JMo_Java toJava(CallRuntime cr) {
        return new JMo_Java(this.getValue());
    }

    protected ObjectCallResult breakAt(CallRuntime cr) {
        I_Object[] pars;
        I_Object[] i_ObjectArray = pars = cr.parsVarArgs(this, 1, 0);
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            if (this.equals(par)) {
                Return rb = new Return(Return.LEVEL.BREAK, this);
                return new ObjectCallResult(rb, true);
            }
            ++n2;
        }
        I_Object result = Lib_Exec.execBlockStream(cr, this);
        return new ObjectCallResult(result, true);
    }

    protected ObjectCallResult breakIf(CallRuntime cr) {
        Bool par = (Bool)cr.parsEach(this, 0, new I_Object[]{this}, Bool.class);
        if (par == Bool.TRUE) {
            Return rb = new Return(Return.LEVEL.BREAK, this);
            return new ObjectCallResult(rb, true);
        }
        I_Object result = Lib_Exec.execBlockStream(cr, this);
        return new ObjectCallResult(result, true);
    }

    public ObjectCallResult doIf(CallRuntime cr, boolean not, boolean passToStream, boolean equals) {
        I_Object[] pars = equals ? cr.parsVarArgs(this, 1, 0) : cr.parsFlex(this, 0, 1);
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        if (pars != null && pars.length == 0) {
            pars = null;
        }
        if (pars == null && stream == null && block == null) {
            return new ObjectCallResult(this, true);
        }
        boolean check = false;
        if (equals) {
            I_Object[] i_ObjectArray = pars;
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object par = i_ObjectArray[n2];
                A_Atomic par0 = (A_Atomic)cr.parType(par, A_Atomic.class);
                check = this.getValue().equals(par0.getValue());
                if (!check) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else {
            I_Object base = this;
            if (pars != null && pars.length == 1) {
                base = cr.parType(pars[0], Bool.class);
            } else if (!(this instanceof Bool)) {
                throw new ExecError(cr, "Invalid type of object for if-function", "Type must be bool, but is: " + this.getTypeName());
            }
            check = ((Bool)base).getValue();
        }
        if (not) {
            check = !check;
        }
        I_Object res = Bool.getObject(check);
        A_Atomic it = passToStream ? this : Bool.getObject(check);
        A_Atomic its = passToStream ? this : Bool.getObject(check);
        res = Lib_Exec.execIf(cr, block, stream, check, it, its, passToStream, res);
        return new ObjectCallResult(res, true);
    }

    private ObjectCallResult iWhile(CallRuntime cpOld, String method) {
        Handle_Loop handle = new Handle_Loop(this);
        CallRuntime cpNew = cpOld.copyLoop(handle);
        BlockExecArgs args = new BlockExecArgs(new I_Object[0]);
        I_Object result = this;
        I_Object check = cpOld.copyEach(method).parsEach(this, 0, new I_Object[]{result}, Bool.class);
        boolean b = Lib_Convert.getBoolValue(cpNew, check);
        while (b) {
            handle.startLap();
            result = Lib_Exec.execBlockStream(cpNew, args, result);
            result = Lib_Exec.loopResult(result);
            if (result instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            check = cpOld.copyEach(method).parsEach(this, 0, new I_Object[]{result}, Bool.class);
            b = Lib_Convert.getBoolValue(cpNew, check);
        }
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult iRepeat(CallRuntime cpOld, String method) {
        Handle_Loop handle = new Handle_Loop(this);
        CallRuntime cpNew = cpOld.copyLoop(handle);
        BlockExecArgs args = new BlockExecArgs(new I_Object[0]);
        I_Object result = this;
        I_Object check = cpOld.copyEach(method).parsEach(this, 0, new I_Object[]{result}, Bool.class);
        boolean b = Lib_Convert.getBoolValue(cpNew, check);
        do {
            handle.startLap();
            result = Lib_Exec.execBlockStream(cpNew, args, result);
            result = Lib_Exec.loopResult(result);
            if (!(result instanceof Return)) continue;
            return ((Return)result).getLoopResult();
        } while (b = Lib_Convert.getBoolValue(cpNew, check = cpOld.copyEach(method).parsEach(this, 0, new I_Object[]{result}, Bool.class)));
        return new ObjectCallResult(result, true);
    }

    @Override
    public boolean equalsStrict(Object par) {
        if (this == Nil.NIL || par == Nil.NIL) {
            return this == par;
        }
        if (!(par instanceof I_AtomicValue)) {
            return false;
        }
        par = ((I_AtomicValue)par).getValue();
        Object cur = this.getValue();
        if (par.getClass() != cur.getClass()) {
            return false;
        }
        if (cur instanceof Double && Double.isNaN((Double)cur) && par instanceof Double && Double.isNaN((Double)par)) {
            return true;
        }
        return cur.equals(par);
    }

    @Override
    public boolean equals(Object par) {
        Object cur;
        if (this == Nil.NIL || par == Nil.NIL) {
            return this == par;
        }
        if (par instanceof I_AtomicValue) {
            par = ((I_AtomicValue)par).getValue();
        }
        if ((cur = this) instanceof I_AtomicValue) {
            cur = ((I_AtomicValue)cur).getValue();
        }
        if (cur instanceof Number && par instanceof Number) {
            if (cur instanceof Double && Double.isNaN((Double)cur) && par instanceof Double && Double.isNaN((Double)par)) {
                return true;
            }
            return ((Number)cur).doubleValue() == ((Number)par).doubleValue();
        }
        if ((cur instanceof Character || cur instanceof String) && (par instanceof Character || par instanceof String)) {
            return cur.toString().equals(par.toString());
        }
        return cur.equals(par);
    }

    @Override
    public boolean equalsLazy(Object objPar) {
        String strCurLower;
        Object objCur;
        if (this == Nil.NIL || objPar == Nil.NIL) {
            return this == objPar;
        }
        if (objPar instanceof I_AtomicValue) {
            objPar = ((I_AtomicValue)objPar).getValue();
        }
        if (objPar.equals(objCur = this.getValue())) {
            return true;
        }
        if ((objPar instanceof Boolean || objPar instanceof Number) && (objCur instanceof Boolean || objCur instanceof Number)) {
            Number numCur;
            Number numPar;
            Number number = objPar instanceof Boolean ? (Number)((Boolean)objPar != false ? 1 : 0) : (Number)(numPar = (Number)objPar);
            Number number2 = objCur instanceof Boolean ? (Number)((Boolean)objCur != false ? 1 : 0) : (Number)(numCur = (Number)objCur);
            if (objCur instanceof Double && Double.isNaN((Double)objCur) && objPar instanceof Double && Double.isNaN((Double)objPar)) {
                return true;
            }
            return numCur.doubleValue() == numPar.doubleValue();
        }
        String strPar = objPar.toString();
        String strCur = objCur.toString();
        String strParLower = strPar.toLowerCase();
        if (strParLower.equals("true")) {
            strPar = "1";
        }
        if (strParLower.equals("false")) {
            strPar = "0";
        }
        if ((strCurLower = strCur.toLowerCase()).equals("true")) {
            strCur = "1";
        }
        if (strCurLower.equals("false")) {
            strCur = "0";
        }
        if (strCur.endsWith(".0")) {
            strCur = strCur.substring(0, strCur.length() - 2);
        }
        if (strPar.endsWith(".0")) {
            strPar = strPar.substring(0, strPar.length() - 2);
        }
        return strPar.equals(strCur);
    }

    protected abstract Bool comparsion(CallRuntime var1, COMPARE var2);

    @Override
    public final Integer compareTo2(I_Object o) {
        if (!(o instanceof I_AtomicValue)) {
            return null;
        }
        Integer result = this.compareTo3((I_AtomicValue)o);
        return result != null ? result : null;
    }

    protected abstract Integer compareTo3(I_AtomicValue var1);
}

