/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.data.Lib_Random;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import de.mn77.base.thread.A_Thread;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_AutoObject;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.passthrough.I_PassThrough;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.FuncLet;
import org.jmo_lang.object.pseudo.JMo_Error;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.object.sys.JMo_Java;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.MethodList;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.hints.HintManager;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Namespace;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Type;

public abstract class A_Object
implements I_Object {
    public static final String[] blockedFunctions = new String[]{"assertType", "async", "catch", "compares", "debug", "differs", "diffly", "do", "echo", "equally", "equals", "getType", "getTypes", "handle", "ifExec", "ifNil", "ifNotNil", "isDifferent", "isDiffly", "isEqual", "isEqually", "isNil", "isOther", "isSame", "isType", "let", "mem", "nilUse", "other", "pass", "print", "proc", "replaceNil", "same", "sync", "tee", "try", "tryBlock", "tryBlockCatch", "tryCatch", "tryStream", "type", "types"};
    public static final String[] overwriteFunctions = new String[]{"toStr"};
    public static final String[] blockedEvents = new String[]{"@varChanged"};
    private boolean init = false;

    @Override
    public void initOnce(CallRuntime cr) {
        if (this.init) {
            return;
        }
        this.init = true;
        this.init(cr);
    }

    public abstract void init(CallRuntime var1);

    public void setAlreadyInit() {
        this.init = true;
    }

    @Override
    public final ObjectCallResult call(CallRuntime cr) {
        char c0;
        String method = cr.call.method;
        if (this instanceof I_Atomic && method == null) {
            return new ObjectCallResult(this, false);
        }
        boolean pass = this instanceof I_PassThrough;
        ObjectCallResult result = null;
        ObjectCallResult objectCallResult = result = pass ? this.call2(cr, method) : this.iCall(cr, method);
        if (!pass && result == null && cr.getStrict().isValid_AutoProperty() && (c0 = method.charAt(0)) >= 'a' && c0 <= 'z') {
            String m2 = "get" + Character.toUpperCase(c0) + method.substring(1);
            result = this.iCall(cr, m2);
        }
        if (result == null) {
            String typename = this instanceof JMo_Java ? this.toString() : this.getTypeName();
            throw new CodeError(cr, "Unknown function", String.valueOf(typename) + "." + method);
        }
        if (result.obj == null) {
            Err.todo("Result-Object is null", cr.getDebugInfo());
        }
        return result;
    }

    private ObjectCallResult iCall(CallRuntime cr, String method) {
        switch (method) {
            case "isEqually": 
            case "equally": 
            case "compares": 
            case "==~": {
                return A_Object.stdResult(this.isEqual(cr, COMPARSION.LAZY, false));
            }
            case "equals": 
            case "==": 
            case "isEqual": {
                return A_Object.stdResult(this.isEqual(cr, COMPARSION.NORMAL, false));
            }
            case "isSame": 
            case "===": 
            case "same": {
                return A_Object.stdResult(this.isEqual(cr, COMPARSION.STRICT, false));
            }
            case "diffly": 
            case "isDiffly": 
            case "!=~": {
                return A_Object.stdResult(this.isEqual(cr, COMPARSION.LAZY, true));
            }
            case "isDifferent": 
            case "!=": 
            case "<>": 
            case "differs": {
                return A_Object.stdResult(this.isEqual(cr, COMPARSION.NORMAL, true));
            }
            case "!==": 
            case "other": 
            case "isOther": {
                return A_Object.stdResult(this.isEqual(cr, COMPARSION.STRICT, true));
            }
            case "getType": 
            case "type": {
                cr.pars();
                return A_Object.stdResult(new Str(this.getTypeName()));
            }
            case "types": 
            case "getTypes": {
                cr.pars();
                return A_Object.stdResult(this.types());
            }
            case "isType": {
                return A_Object.stdResult(this.isType(cr));
            }
            case "assertType": {
                return A_Object.stdResult(this.assertType(cr));
            }
            case "isNil": {
                return A_Object.stdResult(this.isNil(cr));
            }
            case "replaceNil": {
                return A_Object.stdResult(this.replaceNil(cr));
            }
            case "ifExec": {
                return A_Object.stdResult(this.ifExec(cr));
            }
            case "ifNil": {
                return this.ifNil(cr, false);
            }
            case "ifNotNil": {
                return this.ifNil(cr, true);
            }
            case "nilUse": {
                return A_Object.stdResult(this.useNil(cr));
            }
            case "which": {
                return A_Object.stdResult(this.which(cr));
            }
            case "toStr": {
                return A_Object.stdResult(this.toStr(cr));
            }
            case "print": {
                return A_Object.stdResult(this.print(cr, true));
            }
            case "echo": {
                return A_Object.stdResult(this.print(cr, false));
            }
            case "debug": {
                return A_Object.stdResult(this.debug(cr));
            }
            case "proc": {
                return A_Object.stdResult(this.procTee(cr, false));
            }
            case "tee": {
                return A_Object.stdResult(this.procTee(cr, true));
            }
            case "pass": {
                return new ObjectCallResult(this.pass(cr), true);
            }
            case "do": {
                cr.getStrict().checkAutoBlock(cr);
                if (!(this instanceof I_AutoBlockDo)) {
                    throw new ExecError(cr, "This object has no auto-block-function!", "Object: " + this.toString());
                }
                I_Object doResult = ((I_AutoBlockDo)((Object)this)).autoBlockDo(cr);
                return new ObjectCallResult(doResult, true);
            }
            case "try": 
            case "tryBlock": {
                return this.errTry(cr);
            }
            case "tryBlockCatch": 
            case "tryCatch": {
                return this.errTryCatch(cr);
            }
            case "tryStream": {
                return this.errTryStream(cr);
            }
            case "catch": {
                return this.errCatch(cr);
            }
            case "mem": {
                this.mem_let(cr, true);
                return A_Object.stdResult(this);
            }
            case "let": {
                this.mem_let(cr, false);
                return A_Object.stdResult(this);
            }
            case "handle": {
                return A_Object.stdResult(this.handle(cr));
            }
            case "sync": {
                return this.sync(cr);
            }
            case "async": {
                return this.async(cr);
            }
            case "\u00b6": {
                return this.endMultiCall(cr);
            }
        }
        return this.call2(cr, method);
    }

    @Override
    public abstract String toString();

    protected abstract ObjectCallResult call2(CallRuntime var1, String var2);

    public I_Object print(CallRuntime cr, boolean newline) {
        I_Object[] pars = cr.parsFlex(this, 0, 1);
        String s = null;
        if (pars != null && pars.length >= 1) {
            s = pars[0].toString();
        } else if (this instanceof Instance && ((Instance)this).getType().getFunctions().knows("toStr")) {
            Function f = ((Instance)this).getType().getFunctions().get(cr, "toStr");
            I_Object result = f.getBlock().execOverwrite(cr, (Instance)this, f);
            s = Lib_Convert.getStringValue(cr, result);
        } else {
            s = this.toString();
        }
        Lib_Output.out(cr.getApp(), s, newline);
        return this;
    }

    public I_Object debug(CallRuntime cr) {
        I_Object[] pars = cr.parsVarArgs(this, 0, 0);
        StringBuilder sb = new StringBuilder();
        sb.append(cr.getDebugInfo().getFile().toString());
        sb.append(":");
        sb.append(cr.getDebugInfo().getLine().toString());
        sb.append(" | ");
        sb.append(this.toDebug(cr));
        if (pars != null && pars.length > 0) {
            sb.append(" (");
            boolean first = true;
            I_Object[] i_ObjectArray = pars;
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object par = i_ObjectArray[n2];
                if (!first) {
                    sb.append(",");
                }
                sb.append(par.toString());
                first = false;
                ++n2;
            }
            sb.append(")");
        }
        Lib_Output.out(cr.getApp(), sb.toString(), true);
        return this;
    }

    @Override
    public final int compareTo(I_Object o) {
        if (o.hashCode() == this.hashCode()) {
            return 0;
        }
        if (this.equals(o)) {
            return 0;
        }
        Integer result = this.compareTo2(o);
        if (result == null) {
            throw new CodeError("Not comparable", String.valueOf(this.toString()) + " <---> " + o.toString(), null);
        }
        return result;
    }

    protected Integer compareTo2(I_Object o) {
        return null;
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + this.toDebug(cr));
    }

    @Override
    public final String getTypeName() {
        Class<?> cl = this.getClass();
        return Lib_Type.getName(cl, this);
    }

    @Override
    public final String[] getTypes() {
        ArrayList<String> list = new ArrayList<String>();
        Class<?> cl = this.getClass();
        while (cl != null) {
            String s = cl.getName();
            if (s.startsWith("org.jmo_lang")) {
                s = Lib_Type.getName(cl, this);
                if (s.equals("Var")) {
                    MOut.exit(cl, s);
                }
                list.add(s);
            }
            cl = cl.getSuperclass();
        }
        return list.toArray(new String[list.size()]);
    }

    public static ObjectCallResult stdResult(I_Object result) {
        return new ObjectCallResult(result, false);
    }

    private I_Object isEqual(CallRuntime cr, COMPARSION comparsion, boolean not) {
        boolean result;
        I_Object par = cr.pars(this, I_Object.class)[0];
        boolean bl = comparsion == COMPARSION.NORMAL ? this.equals(par) : (result = comparsion == COMPARSION.LAZY ? this.equalsLazy(par) : this.equalsStrict(par));
        if (not) {
            result = !result;
        }
        return Bool.getObject(result);
    }

    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    public boolean equalsStrict(Object obj) {
        return this == obj;
    }

    private Str toStr(CallRuntime cr) {
        cr.pars();
        if (this instanceof Instance && ((Instance)this).getType().getFunctions().knows("toStr")) {
            Function f = ((Instance)this).getType().getFunctions().get(cr, "toStr");
            I_Object result = f.getBlock().execOverwrite(cr, (Instance)this, f);
            return new Str(Lib_Convert.getStringValue(cr, result));
        }
        return new Str(this.toString());
    }

    private ObjectCallResult async(final CallRuntime cr) {
        cr.getStrict().checkSave(cr, ".sync");
        final A_Object this2 = this;
        A_Thread t = new A_Thread(){

            @Override
            public void task() {
                cr.pars(this2, new Class[0]);
                Call stream = cr.getStream();
                Block block = cr.getCallBlock();
                if (stream == null && block == null) {
                    throw new CodeError(cr, "Invalid call", "No Parameter, no Stream, no Block, for times ... what to do?");
                }
                I_Object it = this2;
                if (block != null) {
                    try {
                        block.exec(cr, it);
                    }
                    catch (ReturnException e) {
                        Return temp = e.get();
                        temp.getResult();
                        switch (temp.getLevel()) {
                            case BREAK: {
                                return;
                            }
                        }
                        throw new CodeError(cr, "Invalid exit for block", "Got " + (Object)((Object)temp.getLevel()) + ", need " + (Object)((Object)Return.LEVEL.BREAK));
                    }
                }
                if (stream != null) {
                    cr.execInit(stream, it);
                }
            }
        };
        t.start();
        return new ObjectCallResult(Nil.NIL, true);
    }

    private ObjectCallResult endMultiCall(CallRuntime cr) {
        Int multiCallKey = (Int)cr.pars(this, Int.class)[0];
        cr.vce.useMultiCall().add(multiCallKey.getValue(), this);
        return new ObjectCallResult(this, true);
    }

    protected ObjectCallResult errTry(CallRuntime cr) {
        cr.pars();
        cr.blockNecessary();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        I_Object result = this;
        if (block != null) {
            try {
                result = block.exec(cr, result);
            }
            catch (ReturnException e) {
                return new ObjectCallResult(e.get(), true);
            }
            catch (CodeError | ParseError e) {
                if (cr.getApp().strict.getLazyErrors()) {
                    result = new JMo_Error(e);
                }
                throw e;
            }
            catch (ErrorBaseDebug t) {
                result = new JMo_Error(t);
            }
        }
        if (stream != null) {
            result = cr.execInit(stream, result);
        }
        return new ObjectCallResult(result, true);
    }

    protected ObjectCallResult errTryCatch(CallRuntime cr) {
        cr.pars();
        cr.blockNecessary();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        I_Object result = this;
        if (block != null) {
            try {
                result = block.exec(cr, result);
            }
            catch (ReturnException e) {
                return new ObjectCallResult(e.get(), true);
            }
            catch (CodeError | ParseError e) {
                if (cr.getApp().strict.getLazyErrors()) {
                    result = new JMo_Error(e);
                }
                throw e;
            }
            catch (ErrorBaseDebug t) {
                result = new JMo_Error(t);
            }
        }
        if (stream != null && result instanceof JMo_Error) {
            result = cr.execInit(stream, result);
        }
        return new ObjectCallResult(result, true);
    }

    protected ObjectCallResult errTryStream(CallRuntime cr) {
        cr.pars();
        Call stream = cr.getStream();
        I_Object result = this;
        try {
            result = cr.execInit(stream, result);
        }
        catch (CodeError | ParseError e) {
            if (cr.getApp().strict.getLazyErrors()) {
                result = new JMo_Error(e);
            }
            throw e;
        }
        catch (ErrorBaseDebug t) {
            result = new JMo_Error(t);
        }
        return new ObjectCallResult(result, true);
    }

    protected ObjectCallResult errCatch(CallRuntime cr) {
        cr.pars();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        I_Object result = this;
        if (this instanceof JMo_Error) {
            if (block != null) {
                try {
                    result = block.exec(cr, result);
                }
                catch (ReturnException e) {
                    return new ObjectCallResult(e.get(), true);
                }
            }
            if (stream != null) {
                result = cr.execInit(stream, result);
            }
        }
        return new ObjectCallResult(result, true);
    }

    private I_Object hint(CallRuntime cr, boolean pars) {
        cr.getStrict().checkSave(cr, "Hints");
        Str search = (Str)cr.pars(this, Str.class)[0];
        MethodList ml = new MethodList();
        if (this instanceof A_AutoObject) {
            ((A_AutoObject)this).getMethods(ml);
        }
        HintManager hints = cr.getApp().getHints();
        if (pars) {
            hints.searchFuncPars(ml, this.getTypeName(), search.getValue());
        } else {
            hints.searchFunc(ml, this.getTypeName(), search.getValue());
        }
        String result = pars ? ml.getPars(search.getValue()) : ml.get(search.getValue());
        Lib_Output.out(cr.getApp(), result, true);
        return this;
    }

    private I_Object replaceNil(CallRuntime cr) {
        I_Object o = cr.pars(this, I_Object.class)[0];
        return this == Nil.NIL ? o : this;
    }

    private Bool isNil(CallRuntime cr) {
        cr.pars();
        return Bool.getObject(this == Nil.NIL);
    }

    private ObjectCallResult ifNil(CallRuntime cr, boolean not) {
        boolean check;
        cr.pars();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        if (stream == null && block == null) {
            return new ObjectCallResult(this, true);
        }
        boolean bl = check = this == Nil.NIL;
        if (not) {
            check = !check;
        }
        I_Object res = Bool.getObject(check);
        res = Lib_Exec.execIf(cr, block, stream, check, res, res, false, res);
        return new ObjectCallResult(res, true);
    }

    private I_Object useNil(CallRuntime cr) {
        Lib_Error.ifPars(cr.parCount(), 2, 2, cr);
        return cr.parsOneAdvance(this, this == Nil.NIL ? 0 : 1, I_Object.class);
    }

    private I_Object which(CallRuntime cr) {
        int parIdx = 0;
        while (parIdx < cr.parCount()) {
            Bool b1 = (Bool)cr.parsOneAdvance(this, parIdx, Bool.class);
            if (b1 == Bool.TRUE) {
                return new Int(parIdx + 1);
            }
            ++parIdx;
        }
        return Nil.NIL;
    }

    private I_Object ifExec(CallRuntime cr) {
        if (this instanceof FuncLet) {
            return ((FuncLet)this).exec(cr);
        }
        return this;
    }

    private void mem_let(CallRuntime cr, boolean mem) {
        I_Object[] pars;
        if (!cr.getStrict().isValid_AutoPass()) {
            cr.blockForbidden();
        }
        if ((pars = cr.getPars(this)).length != 1) {
            throw new CodeError(cr, "Invalid Parameter-Count", "Got " + pars.length + " Pars, expected one Var");
        }
        if (mem) {
            I_Object par = cr.parType(pars[0], VarLet.class);
            Var o = ((VarLet)par).getVar();
            o.let(cr, cr, this);
        } else {
            this.iCheckParIsVar(cr, this, false);
            Var o = (Var)this;
            o.let(cr, cr, pars[0]);
        }
    }

    private I_Object procTee(CallRuntime cr, boolean tee) {
        I_Object result = null;
        if (cr.parCount() == 2) {
            VarLet v = (VarLet)cr.parsOneAdvance(this, 0, VarLet.class);
            v.getVar().let(cr, cr, this);
            result = cr.parsOneAdvance(this, 1, I_Object.class);
        } else {
            result = cr.pars(this, I_Object.class)[0];
        }
        if (result instanceof FuncLet) {
            result = ((FuncLet)result).eachExec(cr, this);
        }
        return tee ? this : result;
    }

    public I_Object pass(CallRuntime cpOld) {
        I_Object[] pars = cpOld.parsFlex(this, 0, 1);
        CallRuntime cpNew = cpOld.copyLoop(new Handle_Loop(this));
        return Lib_Exec.execBlockStream(cpNew, new BlockExecArgs(pars), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectCallResult sync(CallRuntime cr) {
        cr.getStrict().checkSave(cr, ".sync");
        A_Object a_Object = this;
        synchronized (a_Object) {
            A_Object it;
            I_Object[] pars = cr.parsFlex(this, 0, 1);
            Call stream = cr.getStream();
            Block block = cr.getCallBlock();
            int parlen = pars.length;
            if (parlen == 0 && stream == null && block == null) {
                throw new CodeError(cr, "Invalid call", "No Parameter, no Stream, no Block, for times ... what to do?");
            }
            I_Object res = this;
            I_Object i_Object = it = parlen == 0 ? this : pars[0];
            if (block != null) {
                try {
                    res = block.exec(cr, it);
                }
                catch (ReturnException e) {
                    Return temp = e.get();
                    res = temp.getResult();
                    switch (temp.getLevel()) {
                        case BREAK: {
                            return temp.getLoopResult();
                        }
                    }
                    throw new CodeError(cr, "Invalid exit for block", "Got " + (Object)((Object)temp.getLevel()) + ", need " + (Object)((Object)Return.LEVEL.BREAK));
                }
            }
            if (stream != null) {
                res = cr.execInit(stream, it);
            }
            return new ObjectCallResult(res, true);
        }
    }

    private JMo_List types() {
        String[] types = this.getTypes();
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.add(new Str(s));
            ++n2;
        }
        return new JMo_List(list);
    }

    private Bool isType(CallRuntime cr) {
        I_Object par = cr.pars(this, Str.class)[0];
        String s = Lib_Convert.getStringValue(cr, par);
        Lib_Namespace.checkTypeValidity(s, cr.getDebugInfo());
        String[] stringArray = this.getTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (s.equals(type)) {
                return Bool.TRUE;
            }
            ++n2;
        }
        return Bool.FALSE;
    }

    private I_Object assertType(CallRuntime cr) {
        I_Object par = cr.pars(this, Str.class)[0];
        String s = Lib_Convert.getStringValue(cr, par);
        Lib_Namespace.checkTypeValidity(s, cr.getDebugInfo());
        String[] stringArray = this.getTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (s.equals(type)) {
                return this;
            }
            ++n2;
        }
        throw new ExecError(cr, "Assert-Error: Invalid type of current object!", "Type should be \"" + s + "\", but is \"" + this.getTypeName() + "\"");
    }

    private I_Object handle(CallRuntime cr) {
        Var tmpVar = new Var("handle_" + Lib_Random.getString(10, true, true, true, ""));
        tmpVar.let(cr, cr, this);
        return new VarLet(tmpVar);
    }

    private void iCheckParIsVar(CallRuntime cr, I_Object par, boolean parameter) {
        if (!(par instanceof Var)) {
            String so = parameter ? "Parameter" : "Object";
            throw new CodeError(cr, "Invalid " + so + "-Type", "Got " + par.getTypeName() + "(" + par.toDebug(cr) + "), expected: Var");
        }
    }

    private static enum COMPARSION {
        STRICT,
        NORMAL,
        LAZY;

    }
}

