/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.MFile;
import de.mn77.base.version.VersionData_ABC;
import java.io.IOException;
import org.jmo_lang.cli.JMo_CLI;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.struct.App;

public class JMo {
    public static final VersionData_ABC VERSION = new VersionData_ABC(0, 15, 0, 0);
    public static final String PACKAGE_DOMAIN_BASE = "org.jmo_lang";
    private boolean parseOnly = false;
    private boolean debug = false;

    public static void main(String[] args) {
        MOut.debugNo();
        MOut.setJavaErrors(false);
        try {
            JMo jmo = new JMo();
            jmo.start(args);
        }
        catch (Throwable t) {
            Err.exit(t);
        }
    }

    public void start(String[] args) throws Err_FileSys, IOException {
        if ((args = this.args(args)).length == 0) {
            JMo_CLI cli = new JMo_CLI();
            cli.start(this.parseOnly, this.debug);
            return;
        }
        Parser_App parser = new Parser_App();
        MFile datei = new MFile(args[0]);
        if (!datei.exists()) {
            MOut.text("Missing file: " + datei.getPathAbsolute());
            return;
        }
        App app = parser.parseFile(datei);
        if (this.debug) {
            app.setDebug();
        }
        int len = args.length - 1;
        String[] args_tmp = new String[len];
        if (len > 0) {
            System.arraycopy(args, 1, args_tmp, 0, len);
        }
        args = args_tmp;
        if (this.parseOnly) {
            MOut.text("Test okay, no parse errors found.");
        } else {
            app.exec(args);
        }
    }

    private String[] args(String[] args) {
        int i = 0;
        while (i < args.length) {
            String s = args[i];
            if (!s.startsWith("-")) {
                if (i == 0) {
                    return args;
                }
                int newLen = args.length - i;
                String[] args2 = new String[newLen];
                System.arraycopy(args, i, args2, 0, newLen);
                return args2;
            }
            switch (s) {
                case "-t": 
                case "--test": {
                    this.parseOnly = true;
                    break;
                }
                case "--debug": 
                case "-d": {
                    this.debug = true;
                    MOut.setJavaErrors(true);
                    MOut.debugDetail();
                    break;
                }
                default: {
                    throw new Err_Runtime("Unknown argument for JM\u00b0", s);
                }
            }
            ++i;
        }
        return new String[0];
    }
}

