/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.spec.terminal;

import de.mn77.base.data.struct.HistoryList;
import de.mn77.base.sys.Sys;
import de.mn77.spec.terminal.COLOR_BG;
import de.mn77.spec.terminal.COLOR_FG;
import de.mn77.spec.terminal.CSI;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public final class MTerminal {
    private final HistoryList<String> history = new HistoryList();
    private MODE currentMode = MODE.COOKED;
    private Reader input;
    private final InputStream inputStream = new FileInputStream(FileDescriptor.in);
    private PrintWriter output;
    private boolean debug = false;

    public MTerminal() throws UnsupportedEncodingException {
        if (Sys.isLinux() || Sys.isMac()) {
            this.callStty(MODE.RAW);
        }
        this.input = new InputStreamReader(this.inputStream, "UTF-8");
        this.output = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        this.output.flush();
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public boolean isInRawMode() {
        return this.currentMode == MODE.RAW;
    }

    private void callStty(MODE mode) {
        String[] cmdRaw = new String[]{"/bin/sh", "-c", "stty -ignbrk -brkint -parmrk -istrip -inlcr -igncr -icrnl -ixon -opost -echo -echonl -icanon -isig -iexten -parenb cs8 min 1 < /dev/tty"};
        String[] cmdCooked = new String[]{"/bin/sh", "-c", "stty sane cooked < /dev/tty"};
        try {
            Process process = mode == MODE.RAW ? Runtime.getRuntime().exec(cmdRaw) : Runtime.getRuntime().exec(cmdCooked);
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
            String line = in.readLine();
            if (line != null && line.length() > 0) {
                System.err.println("WEIRD?! Normal output from stty: " + line);
            }
            while (true) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            if (process.exitValue() == 0) {
                this.currentMode = mode;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeTerminal() {
        if (this.currentMode == MODE.RAW) {
            this.callStty(MODE.COOKED);
        } else {
            try {
                if (this.input != null) {
                    this.input.close();
                    this.input = null;
                }
                if (this.output != null) {
                    this.output.close();
                    this.output = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public String readln() throws IOException {
        run = true;
        inputBuffer = "";
        block11: while (run) {
            block33: {
                block32: {
                    c = this.input.read();
                    if (c == -1) {
                        run = false;
                        return null;
                    }
                    cc = (char)c;
                    if (c != 127) break block32;
                    if (inputBuffer.length() > 0) {
                        inputBuffer = inputBuffer.substring(0, inputBuffer.length() - 1);
                        this.output.print(CSI.cursorLeft(new int[0]));
                        this.output.print(CSI.eraseLineToEnd(new int[0]));
                    }
                    ** GOTO lbl86
                }
                if (c != 27) break block33;
                cbuf = new char[16];
                count = this.input.read(cbuf);
                if (count == -1) ** GOTO lbl86
                ca = new char[count];
                System.arraycopy(cbuf, 0, ca, 0, count);
                var9_9 = se = new String(ca);
                tmp = -1;
                switch (var9_9.hashCode()) {
                    case 2886: {
                        if (var9_9.equals("[A")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 2887: {
                        if (var9_9.equals("[B")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 2888: {
                        if (var9_9.equals("[C")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 2889: {
                        if (var9_9.equals("[D")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        h = this.history.getBack();
                        if (inputBuffer.length() > 0) {
                            this.output.print(CSI.cursorLeft(new int[]{inputBuffer.length()}));
                            this.output.print(CSI.eraseLineToEnd(new int[0]));
                        }
                        if (h != null && (inputBuffer = h).length() > 0) {
                            this.output.print(inputBuffer);
                        }
                        ** GOTO lbl86
                    }
                    case 2: {
                        h2 = this.history.getForward();
                        if (inputBuffer.length() > 0) {
                            this.output.print(CSI.cursorLeft(new int[]{inputBuffer.length()}));
                            this.output.print(CSI.eraseLineToEnd(new int[0]));
                        }
                        if (h2 == null) {
                            h2 = "";
                        }
                        if ((inputBuffer = h2).length() > 0) {
                            this.output.print(inputBuffer);
                        }
                        ** GOTO lbl86
                    }
                    default: {
                        this.output.print(se);
                        ** GOTO lbl86
                    }
                    case 3: {
                        if (!this.isInRawMode()) continue block11;
                    }
                }
            }
            if (c == 13 || c == 10) {
                run = false;
            } else if (c == 3 || c == 4) {
                run = false;
                inputBuffer = null;
            } else if (c >= 32 && c <= 126 || c >= 128 || c == 9) {
                if (this.isInRawMode()) {
                    this.output.print("" + cc);
                }
                inputBuffer = String.valueOf(inputBuffer) + cc;
            } else if (this.debug && this.isInRawMode()) {
                this.output.print(String.valueOf(c) + "(" + cc + ")");
            }
lbl86:
            // 11 sources

            if (!this.isInRawMode()) continue;
            this.output.flush();
        }
        if (inputBuffer != null) {
            this.history.add(inputBuffer);
        }
        return inputBuffer;
    }

    public void print(Object ... oa) {
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Enum c;
            Object o = objectArray[n2];
            if (o instanceof String) {
                this.output.print((String)o);
            } else if (o instanceof COLOR_FG) {
                c = (COLOR_FG)((Object)o);
                if (this.isInRawMode()) {
                    this.output.print(((COLOR_FG)c).color);
                }
            } else if (o instanceof COLOR_BG) {
                c = (COLOR_BG)((Object)o);
                if (this.isInRawMode()) {
                    this.output.print(((COLOR_BG)c).color);
                }
            } else {
                this.output.print(o.toString());
            }
            ++n2;
        }
        this.output.flush();
    }

    public void setDebug() {
        this.debug = true;
    }

    private static enum MODE {
        COOKED,
        RAW;

    }
}

