/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.cmd;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Exception;
import de.mn77.base.stream.Lib_Stream;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.cmd.SysCmd_Data;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.thread.A_ParallelProcess;
import java.io.IOException;

public class SysCmd {
    public static void start(String cmd) throws Exception {
        SysCmd.start(cmd, "", false);
    }

    public static void start(String cmd, boolean wait) throws Exception {
        SysCmd.start(cmd, "", wait);
    }

    public static void start(String cmd, String param) throws Exception {
        SysCmd.start(null, cmd, param, false);
    }

    public static void start(String cmd, String param, boolean wait) throws Exception {
        SysCmd.start(null, cmd, param, wait);
    }

    public static void start(I_Directory startDir, String cmd, String param, boolean wait) throws Exception {
        SysCmd_Data data = new SysCmd_Data();
        data.startDir.set(startDir);
        data.command.set(cmd);
        data.parameter.set(param);
        data.wait.set(wait);
        new SysCmd().start(data);
    }

    public void start(SysCmd_Data data) throws Err_Exception {
        block20: {
            Err.ifNull(data, data.command.get());
            String cmd = data.command.get();
            if (data.parameter.get() != null && data.parameter.get().length() > 0) {
                cmd = String.valueOf(cmd) + " " + data.parameter.get();
            }
            if (data.startDir.get() != null) {
                cmd = "cd " + data.startDir.get() + ";" + cmd;
            }
            try {
                String[] args = null;
                if (Sys.isLinux()) {
                    args = new String[]{"sh", "-c", cmd};
                } else if (Sys.isWindows()) {
                    args = new String[]{"cmd", "/c", cmd};
                } else if (Sys.isMac()) {
                    args = new String[]{"open", "-a", cmd};
                } else {
                    Err.todo(new Object[0]);
                }
                boolean waitFor = data.wait.get() != null && data.wait.get() != false;
                Process p = Runtime.getRuntime().exec(args);
                A_ParallelProcess handleOutput = null;
                A_ParallelProcess handleError = null;
                if (waitFor && data.streamOutput.get() != null) {
                    handleOutput = Lib_Stream.connectTerminal(p.getInputStream(), data.streamOutput.get());
                }
                if (waitFor && data.streamError.get() != null) {
                    handleError = Lib_Stream.connectTerminal(p.getErrorStream(), data.streamError.get());
                }
                if (waitFor && data.streamInput.get() != null) {
                    Lib_Stream.connectTerminalNonBlocking(data.streamInput.get(), p.getOutputStream(), p);
                }
                if (!waitFor) break block20;
                try {
                    data.result.set(p.waitFor());
                    if (handleOutput != null) {
                        while (!handleOutput.isFinished()) {
                            Thread.yield();
                        }
                    }
                    if (handleError != null) {
                        while (!handleError.isFinished()) {
                            Thread.yield();
                        }
                    }
                }
                catch (InterruptedException e1) {
                    data.result.set(Integer.MIN_VALUE);
                    Err.wrap(e1, "External Process was not clean executed!", data);
                }
            }
            catch (IOException e) {
                data.result.set(Integer.MIN_VALUE);
                Err.wrap(e, "External Process was not clean executed!", data);
            }
        }
        if (data.result.get() != null && data.result.get() != 0) {
            throw Err.newRuntime("The execution of the command failed. Error code: " + data.result.get(), data);
        }
    }
}

