/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.error;

import de.mn77.base.data.type.Lib_Class;
import de.mn77.base.error.Err_DataBase;
import de.mn77.base.error.Err_Exception;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.MFile;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

public class Err {
    public static Err_Runtime accessProtected(Object ... oa) {
        throw new Err_Runtime("Access is prohibited!", oa);
    }

    public static Err_Runtime forbidden(Object ... oa) {
        throw new Err_Runtime("Execution is forbidden!", oa);
    }

    public static Err_Runtime impossible(Object ... oa) {
        throw new Err_Runtime("This error can not occur. It's impossible!", oa);
    }

    public static Err_Runtime invalid(Object ... oa) {
        throw new Err_Runtime("Invalid condition!", oa);
    }

    public static Err_Runtime todo(Object ... oa) {
        throw new Err_Runtime("ToDo!", oa);
    }

    public static Err_Runtime direct(String message, Object ... oa) {
        throw new Err_Runtime(message, oa);
    }

    public static Err_Runtime newRuntime(String info, Object ... oa) {
        throw new Err_Runtime(info, oa);
    }

    public static Err_Exception newException(String info, Object ... oa) throws Err_Exception {
        throw new Err_Exception(info, oa);
    }

    public static Err_FileSys newFileSys(String info, Object ... oa) throws Err_FileSys {
        throw new Err_FileSys(info, oa);
    }

    public static Err_FileSys fsAccess(Object ... oa) throws Err_FileSys {
        throw new Err_FileSys("File/Directory-Access-Error", oa);
    }

    public static Err_FileSys fsFailed(Object ... oa) throws Err_FileSys {
        throw new Err_FileSys("Action failed!", oa);
    }

    public static void fsIfMissing(Object o) throws Err_FileSys {
        if (o instanceof String) {
            o = new File("" + o);
        }
        if (o instanceof I_File) {
            o = ((I_File)o).getFile();
        }
        if (o instanceof File) {
            if (!((File)o).exists()) {
                new Err_FileSys("File/Directory doesn't exist!", o);
            }
        } else {
            Err.todo(new Object[0]);
        }
    }

    public static void fsIfExist(Object o) throws Err_FileSys {
        if (o instanceof File) {
            if (new MFile((File)o).exists()) {
                new Err_FileSys("File/Directory still exists!", o);
            }
        } else if (o instanceof String) {
            if (new MFile("" + o).exists()) {
                new Err_FileSys("File/Directory still exists!", o);
            }
        } else {
            Err.todo(new Object[0]);
        }
    }

    public static void ifEmpty(String ... oa) {
        Err.ifNull(new Object[]{oa});
        int i = 0;
        while (i < oa.length) {
            if (oa[i].length() == 0) {
                throw new Err_Runtime("String " + (i + 1) + " is empty!", new Object[0]);
            }
            ++i;
        }
    }

    public static void ifEqual(Object a, Object b) {
        if (a.equals(b)) {
            throw new Err_Runtime("Objects are equal: " + a, new Object[0]);
        }
    }

    public static void ifNot(boolean value) {
        if (!value) {
            throw new Err_Runtime("Value is not as expected: " + value, new Object[0]);
        }
    }

    public static void ifNot(Object value, Object expected) {
        Err.ifNull(value, expected);
        if (!value.equals(expected)) {
            throw new Err_Runtime("Value is not as expected: " + value + " != " + expected, new Object[0]);
        }
    }

    public static void ifNot(Object value, Object expected, String message) {
        Err.ifNull(value, expected);
        if (!value.equals(expected)) {
            throw new Err_Runtime(String.valueOf(message) + ": " + value + " != " + expected, new Object[0]);
        }
    }

    public static void ifNull(Object ... oa) {
        int i = 0;
        while (i < oa.length) {
            if (oa[i] == null) {
                throw new Err_Runtime("Object " + (i + 1) + " is null!", new Object[0]);
            }
            ++i;
        }
    }

    public static void ifNotNull(Object ... oa) {
        int i = 0;
        while (i < oa.length) {
            if (oa[i] != null) {
                throw new Err_Runtime("Object " + (i + 1) + " is not null!", new Object[0]);
            }
            ++i;
        }
    }

    public static void ifOutOfBounds(double abs, double value) {
        Err.ifToSmall(0.0, abs);
        if (value > abs || value < -abs) {
            throw new Err_Runtime("Out of bounds", "Value: " + value, "Min: " + -abs, "Max: " + abs);
        }
    }

    public static void ifOutOfBounds(double min, double max, double ... werte) {
        double[] dArray = werte;
        int n = werte.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d > max || d < min) {
                throw new Err_Runtime("Out of bounds", "Value: " + d, "Min: " + min, "Max: " + max);
            }
            ++n2;
        }
    }

    public static void ifToBig(double max, double value) {
        if (value > max) {
            throw new Err_Runtime("Value is to big", "Value: " + value, "Max: " + max);
        }
    }

    public static void ifToSmall(double min, double value) {
        if (value < min) {
            throw new Err_Runtime("Value is to small", "Value: " + value, "Min: " + min);
        }
    }

    public static void ifInstanceNot(Object[] arr, Class<?> ... allowed) {
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Err.ifInstanceNot(o, allowed);
            ++n2;
        }
    }

    public static void ifInstanceNot(Object o, Class<?> ... allowed) {
        Class<?>[] classArray = allowed;
        int n = allowed.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> a = classArray[n2];
            if (Lib_Class.isChildOf(o, a)) {
                return;
            }
            ++n2;
        }
        throw new Err_Runtime("Invalid class: " + o.getClass(), new Object[]{allowed});
    }

    public static RuntimeException show(Throwable t) {
        return Err.show(t, null);
    }

    public static RuntimeException show(Throwable t, String text) {
        MOut.error(t, text);
        return null;
    }

    public static RuntimeException exit(Throwable t) {
        return Err.exit(t, null);
    }

    public static RuntimeException exit(Throwable t, String text) {
        MOut.error(t, text);
        System.exit(1);
        return null;
    }

    public static Err_Exception wrap(Exception e, Object ... details) {
        Err.ifNull(e);
        return new Err_Exception(e, details);
    }

    public static Err_Runtime wrap(RuntimeException e, Object ... details) {
        Err.ifNull(e);
        return new Err_Runtime(e, details);
    }

    public static Err_FileSys wrap(IOException e, Object ... details) {
        Err.ifNull(e);
        return new Err_FileSys(e, details);
    }

    public static Err_DataBase wrap(SQLException e, Object ... details) {
        Err.ifNull(e);
        return new Err_DataBase(e, details);
    }
}

