/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Type;

public class Lib_Par {
    public static void checkBlockNecessary(CallRuntime cr) {
        if (cr.call.getBlock() == null) {
            throw new CodeError(cr, "Invalid function-call", "Block needed for this function");
        }
    }

    public static void checkBlockForbidden(CallRuntime cr) {
        if (cr.call.getBlock() != null) {
            throw new CodeError(cr, "Invalid function-call", "No Block allowed for this function");
        }
    }

    public static I_Object checkParAdvance(CallRuntime cr, I_Object streamIt, int argPos, Class<?> type) {
        I_Object par = cr.getParAdvance(streamIt, argPos);
        return Lib_Par.checkPar(cr, par, type, argPos);
    }

    public static I_Object checkPar(CallRuntime cr, I_Object par, Class<?> type, Integer argPos) {
        I_Object parReal = Lib_Convert.getValue(cr, par);
        if (type != null && !type.isAssignableFrom(parReal.getClass())) {
            String m = cr.call.method;
            if (m != null && m.charAt(0) >= 'a' && m.charAt(0) <= 'z') {
                m = String.valueOf('.') + m;
            }
            String msg = "Invalid type of argument";
            String eValue = String.valueOf(Lib_Type.getName(parReal.getClass(), par)) + "(" + par.toDebug(cr) + ")";
            String eTarget = "\"" + (m != null ? m : cr.call.object.getTypeName()) + "\"";
            String eArg = argPos != null && argPos > 1 ? " as argument " + argPos : "";
            String eDet = "Got " + eValue + eArg + " for " + eTarget + ", expected: " + Lib_Par.typelistToText(type);
            throw new CodeError(cr, "Invalid type of argument", eDet);
        }
        return parReal;
    }

    public static I_Object checkParExt(CallRuntime cr, I_Object par, Class<?>[] types) {
        I_Object parReal = Lib_Convert.getValue(cr, par);
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            if (t.isAssignableFrom(parReal.getClass())) {
                return parReal;
            }
            ++n2;
        }
        throw new CodeError(cr, "Invalid type of argument", "Got " + Lib_Type.getName(parReal.getClass(), par) + "(" + par.toDebug(cr) + "), expected: " + Lib_Par.typelistToText(new Class[][]{types}));
    }

    public static I_Object[] checkPars(CallRuntime cr, I_Object streamIt, Class<?> ... types) {
        Err.ifNull(cr.call);
        if (streamIt == null && types.length == 0 && cr.parCount() > 0) {
            throw new CodeError(cr, "Invalid number of arguments", "No parameters allowed");
        }
        I_Object[] pars = cr.getPars(streamIt);
        int oal = pars.length;
        Lib_Error.ifPars(oal, types.length, types.length, cr);
        int i = 0;
        while (i < oal) {
            pars[i] = Lib_Par.checkPar(cr, pars[i], types[i], i + 1);
            ++i;
        }
        return pars;
    }

    public static I_Object checkParsEach(CallRuntime cr, I_Object streamIt, int offset, I_Object[] eachIt, Class<?> type) {
        Err.ifNull(cr.call, streamIt);
        I_Object result = cr.getParsEach(streamIt, offset, eachIt);
        return Lib_Par.checkPar(cr, result, type, offset);
    }

    public static I_Object checkParEach(CallRuntime cr, I_Object streamIt, int parIdx, I_Object eachIt, Class<?> type) {
        Err.ifNull(cr.call, streamIt);
        I_Object result = cr.getParEach(streamIt, parIdx, eachIt);
        return Lib_Par.checkPar(cr, result, type, parIdx + 1);
    }

    public static I_Object[] checkParsExt(CallRuntime cr, I_Object streamIt, Class<?>[] ... types) {
        I_Object[] pars = cr.getPars(streamIt);
        Lib_Error.ifPars(pars.length, types.length, types.length, cr);
        int i = 0;
        while (i < pars.length) {
            pars[i] = Lib_Convert.getValue(cr, pars[i]);
            if (types[i] != null) {
                boolean hit = false;
                Class<?>[] classArray = types[i];
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> t = classArray[n2];
                    if (t.isAssignableFrom(pars[i].getClass())) {
                        hit = true;
                        break;
                    }
                    ++n2;
                }
                if (!hit) {
                    String errDetailGot = pars.length == 1 ? String.valueOf(Lib_Type.getName(pars[0].getClass(), pars[0])) + "(" + pars[0].toDebug(cr) + ")" : Lib_Par.objTypesToText(pars);
                    throw new CodeError(cr, "Invalid type of argument", "Got " + errDetailGot + ", expected " + Lib_Par.typelistToText(types));
                }
            }
            ++i;
        }
        return pars;
    }

    public static I_Object[] checkParsFlex(CallRuntime cr, I_Object streamIt, int par_min, int par_max) {
        I_Object[] pars = cr.getPars(streamIt);
        int len = pars.length;
        Lib_Error.ifPars(len, par_min, par_max, cr);
        int i = 0;
        while (i < len) {
            pars[i] = Lib_Convert.getValue(cr, pars[i]);
            ++i;
        }
        return pars;
    }

    private static String objTypesToText(I_Object[] oa) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int ioa = 0;
        while (ioa < oa.length) {
            I_Object o = oa[ioa];
            if (ioa != 0) {
                sb.append(", ");
            }
            sb.append(o.getTypeName());
            ++ioa;
        }
        sb.append(")");
        return sb.toString();
    }

    private static String typelistToText(Class<?> type) {
        return Lib_Type.getName(type, null);
    }

    private static String typelistToText(Class<?>[][] types) {
        StringBuilder sb = new StringBuilder();
        if (types.length > 1) {
            sb.append("(");
        }
        int ica = 0;
        while (ica < types.length) {
            Class<?>[] ca = types[ica];
            if (ica != 0) {
                sb.append(", ");
            }
            if (ca.length > 1) {
                sb.append('[');
            }
            int i = 0;
            while (i < ca.length) {
                if (i != 0) {
                    sb.append(" | ");
                }
                sb.append(Lib_Type.getName(ca[i], null));
                ++i;
            }
            if (ca.length > 1) {
                sb.append(']');
            }
            ++ica;
        }
        if (types.length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }
}

