/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct.runtime;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.group.Group4;
import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.FunctionPar;
import org.jmo_lang.struct.MultiCallItems;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.struct.runtime.VarEnv;

public class VarConstEnv {
    private static int counter = 0;
    private final int nr;
    public final VarEnv vars;
    public final VarEnv cons;
    private final VarConstEnv parent;
    private MultiCallItems multicall = null;
    private Handle_Loop loop = null;
    private Group4<Block, CallRuntime, CallRuntime, FunctionPar[]> funcInitData = null;
    private Group2<CallRuntime, CallRuntime> initType = null;

    public VarConstEnv(VarConstEnv parent) {
        this.parent = parent;
        VarEnv parentVars = parent == null ? null : parent.vars;
        VarEnv parentCons = parent == null ? null : parent.cons;
        this.vars = new VarEnv(parentVars, false);
        this.cons = new VarEnv(parentCons, true);
        this.nr = ++counter;
    }

    public MultiCallItems useMultiCall() {
        if (this.multicall == null && this.parent != null) {
            this.multicall = this.parent.useMultiCall();
        }
        if (this.multicall == null) {
            this.multicall = new MultiCallItems();
        }
        return this.multicall;
    }

    public void loopSet(Handle_Loop handle) {
        if (this.loop != null) {
            Err.invalid("Loop is already set!");
        }
        this.loop = handle;
    }

    public Handle_Loop loopGet(CallRuntime cr) {
        if (this.loop != null) {
            return this.loop;
        }
        if (this.parent != null) {
            return this.parent.loopGet(cr);
        }
        throw new CodeError(cr, "Unknown loop!", "There's no loop known, in this and the parent blocks");
    }

    public void setFuncInit(Block block, CallRuntime cpOutside, CallRuntime cpNew, FunctionPar[] vars) {
        this.funcInitData = new Group4<Block, CallRuntime, CallRuntime, FunctionPar[]>(block, cpOutside, cpNew, vars);
    }

    public Group4<Block, CallRuntime, CallRuntime, FunctionPar[]> getFuncInit(CallRuntime cr) {
        if (this.funcInitData != null) {
            return this.funcInitData;
        }
        if (this.parent != null) {
            return this.parent.getFuncInit(cr);
        }
        throw Err.invalid("There's no data to initialize!");
    }

    public void initTypeSet(CallRuntime cpOld, CallRuntime cpNew2) {
        this.initType = new Group2<CallRuntime, CallRuntime>(cpOld, cpNew2);
    }

    public Group2<CallRuntime, CallRuntime> initTypeGet() {
        VarConstEnv cur = this;
        while (cur.initType == null && cur.parent != null) {
            cur = cur.parent;
        }
        return cur.initType;
    }

    public VarConstEnv getParent() {
        return this.parent;
    }

    public String toString() {
        String sp = this.parent == null ? "" : " --> Parent: " + this.parent.toString();
        return "VCE" + this.nr + sp;
    }
}

