/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct.runtime;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.sys.Sys;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_EventObject;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.pseudo.mc.MC_THIS;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.struct.runtime.VarConstEnv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;

public class Instance
extends A_EventObject
implements I_AutoBlockDo {
    private final Type type;
    private final App app;
    private final Call[] pars;
    private VarConstEnv main_env = null;

    public Instance(App app, Type type, Call[] pars) {
        this.type = type;
        this.app = app;
        this.pars = pars;
    }

    @Override
    public void init(CallRuntime cpOld) {
        CallRuntime cpNew = new CallRuntime(this, cpOld.call);
        this.main_env = cpNew.vce;
        I_Object[] parObjs = null;
        if (this.type.isControl()) {
            int parLen = this.type.getVars() == null ? 0 : this.type.getVars().length;
            parObjs = new I_Object[parLen];
            cpNew.vce.initTypeSet(cpOld, cpNew);
        } else if (this.pars != null) {
            parObjs = new I_Object[this.pars.length];
            int i = 0;
            while (i < parObjs.length) {
                parObjs[i] = cpOld.execInit(this.pars[i], null);
                ++i;
            }
        } else {
            parObjs = new I_Object[]{};
        }
        this.type.getBlock().execTypeBlock(cpOld, cpNew, parObjs);
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime crOld, String method) {
        switch (method) {
            case "_init": {
                return this.iInit(crOld);
            }
            case "_sleep": {
                return this.iSleep(crOld);
            }
        }
        Function f = this.type.getFunctions().get(crOld, method);
        CallRuntime cpNew = crOld.copyVCE(this, this.main_env, true);
        if (f.getName().charAt(0) == '_' && !(crOld.call.object instanceof MC_THIS)) {
            throw new ExecError(crOld, "Invalid access to private function", "This function is only accessable within the type definition: " + f.getName());
        }
        try {
            return new ObjectCallResult(f.getBlock().execFunction(crOld, cpNew, f), f.hasControl());
        }
        catch (ReturnException r) {
            Lib_Exec.checkIsReturn(cpNew, r);
            return new ObjectCallResult(r.get().getResult(), f.hasControl());
        }
    }

    @Override
    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        cr.instance.eventRun(cr, event, null);
        return new ObjectCallResult(this, false);
    }

    @Override
    protected boolean validateEvent(CallRuntime cr, String event) {
        return this.type.getEvents().knows(event.substring(1));
    }

    private ObjectCallResult iInit(CallRuntime crOld) {
        if (!this.type.isControl()) {
            throw new ExecError(crOld, "This Type has no control functionality!", "Type is defined with \"()\", so it has no \"._init()\". Maybe define it with {}");
        }
        Lib_Error.ifNotBetween(crOld, 0, 2, crOld.parCount(), "Arguments for _init");
        Group2<CallRuntime, CallRuntime> init = crOld.vce.initTypeGet();
        switch (crOld.parCount()) {
            case 0: {
                I_Object[] parObjs = null;
                if (this.pars != null) {
                    parObjs = new I_Object[this.pars.length];
                    int i = 0;
                    while (i < parObjs.length) {
                        parObjs[i] = ((CallRuntime)init.o1).execInit(this.pars[i], null);
                        ++i;
                    }
                } else {
                    parObjs = new I_Object[]{};
                }
                this.type.getBlock().reInit((CallRuntime)init.o1, (CallRuntime)init.o2, parObjs);
                break;
            }
            case 1: {
                int parLen1 = this.type.getVars().length;
                if (parLen1 == 0) {
                    throw new ExecError(crOld, "Invalid call of _init", "This type has no parameters to initialize");
                }
                I_Object funcPars1 = crOld.pars(this, A_IntNumber.class)[0];
                int parToInit1 = Lib_Convert.getIntValue(crOld, funcPars1);
                Lib_Error.ifPars(parToInit1, 1, parLen1, crOld);
                I_Object parObj1 = ((CallRuntime)init.o1).execInit(this.pars[parToInit1 - 1], null);
                this.type.getBlock().reInit((CallRuntime)init.o1, (CallRuntime)init.o2, this.pars.length, parToInit1, parObj1);
                break;
            }
            case 2: {
                int parLen2 = this.type.getVars().length;
                if (parLen2 == 0) {
                    throw new ExecError(crOld, "Invalid call of _init", "This type has no parameters to initialize");
                }
                I_Object[] funcPars2 = crOld.pars(this, A_IntNumber.class, I_Object.class);
                int parToInit2 = Lib_Convert.getIntValue(crOld, funcPars2[0]);
                Lib_Error.ifPars(parToInit2, 1, parLen2, crOld);
                I_Object eachValue2 = funcPars2[1];
                I_Object parObj2 = ((CallRuntime)init.o1).execEachInit(this.pars[parToInit2 - 1], null, eachValue2);
                this.type.getBlock().reInit((CallRuntime)init.o1, (CallRuntime)init.o2, this.pars.length, parToInit2, parObj2);
            }
        }
        return new ObjectCallResult(this, false);
    }

    private ObjectCallResult iSleep(CallRuntime cr) {
        I_Object[] oa = cr.parsFlex(this, 1, 4);
        int[] values = new int[oa.length];
        int i = 0;
        while (i < oa.length) {
            values[i] = Lib_Convert.getIntValue(cr, oa[i]);
            ++i;
        }
        int ms = 0;
        switch (oa.length) {
            case 1: {
                ms = values[0];
                break;
            }
            case 2: {
                ms = values[0] * 1000 + values[1];
                break;
            }
            case 3: {
                ms = values[0] * 60 + values[1] * 1000 + values[2];
                break;
            }
            case 4: {
                ms = values[0] * 60 + values[1] * 60 + values[2] * 1000 + values[3];
            }
        }
        Sys.sleep(ms);
        return new ObjectCallResult(this, true);
    }

    public App getApp() {
        return this.app == null ? (App)this : this.app;
    }

    public Type getType() {
        return this.type;
    }

    public VarConstEnv getMainEnv() {
        return this.main_env;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return "Instance(" + this.type.getName() + ")";
    }

    protected void setMainEnv(VarConstEnv vce) {
        if (this.main_env != null) {
            Err.forbidden("Is already set!");
        }
        this.main_env = vce;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        Call c2stream;
        if (this.type == null || this.type.getAutoBlockFunction() == null) {
            throw new ExecError(cr, "This type has no auto-block-function!", "Type: " + this.type.getName());
        }
        String newMethod = this.type.getAutoBlockFunction();
        Call call2 = new Call(cr.getSurrBlock(), this, newMethod, cr.call.parCalls, cr.getDebugInfo());
        Block c2block = cr.call.getBlock();
        if (c2block != null) {
            call2.setBlock(c2block);
        }
        if ((c2stream = cr.call.getStream()) != null) {
            call2.setStream(c2stream);
        }
        CallRuntime cpNew = cr.copyCall(call2, false);
        return this.callMethod((CallRuntime)cpNew, (String)newMethod).obj;
    }
}

