/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.filter.FilterText;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.pseudo.mc.MC_DEBUG;
import org.jmo_lang.object.pseudo.mc.MC_IT_BLOCK;
import org.jmo_lang.object.pseudo.mc.MC_IT_EACH;
import org.jmo_lang.object.pseudo.mc.MC_IT_STREAM;
import org.jmo_lang.object.pseudo.mc.MC_JMO;
import org.jmo_lang.object.pseudo.mc.MC_QUEST;
import org.jmo_lang.object.pseudo.mc.MC_THIS;
import org.jmo_lang.object.pseudo.mc.MagicConst;
import org.jmo_lang.object.pseudo.mc.MagicPosition;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;

public class ParseObj_MagicConst
implements I_ParseObject {
    @Override
    public boolean hits(char c0, Block current, String s) {
        return c0 == '_';
    }

    @Override
    public Group2<I_Object, String> parse(App app, Block current, String s, DebugInfo debugInfo) {
        Err.ifNull(current);
        String var = FilterText.matchingLeft("_ABCDEFGHIJKLMNOPQRSTUVWXYZ", s);
        String rem = s.substring(var.length());
        switch (var) {
            case "_THIS": {
                return this.res(new MC_THIS(false), rem);
            }
            case "_JMO": {
                return this.res(new MC_JMO(), rem);
            }
            case "_DEBUG": {
                return this.res(new MC_DEBUG(), rem);
            }
            case "_CURRENT": 
            case "_CUR": {
                return this.res(new MC_IT_STREAM(false), rem);
            }
            case "_EACH": {
                return this.res(new MC_IT_EACH(false), rem);
            }
            case "_IT": {
                return this.res(new MC_IT_BLOCK(false), rem);
            }
            case "_FUNC": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.FUNC), rem);
            }
            case "_LOOP": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.LOOP), rem);
            }
            case "_LINE": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.LINE), rem);
            }
            case "_FILE": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.FILE), rem);
            }
            case "_ARGS": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.ARGS), rem);
            }
            case "_TOP_LEFT": {
                return this.res(new MagicPosition(POSITION.TOP_LEFT), rem);
            }
            case "_TOP_RIGHT": {
                return this.res(new MagicPosition(POSITION.TOP_RIGHT), rem);
            }
            case "_BOTTOM_LEFT": {
                return this.res(new MagicPosition(POSITION.BOTTOM_LEFT), rem);
            }
            case "_BOTTOM_RIGHT": {
                return this.res(new MagicPosition(POSITION.BOTTOM_RIGHT), rem);
            }
            case "_CENTER": {
                return this.res(new MagicPosition(POSITION.CENTER), rem);
            }
            case "_TOP": {
                return this.res(new MagicPosition(POSITION.TOP), rem);
            }
            case "_LEFT": {
                return this.res(new MagicPosition(POSITION.LEFT), rem);
            }
            case "_BOTTOM": {
                return this.res(new MagicPosition(POSITION.BOTTOM), rem);
            }
            case "_RIGHT": {
                return this.res(new MagicPosition(POSITION.RIGHT), rem);
            }
            case "_APP": {
                return this.res(app, rem);
            }
            case "_PI": {
                return this.res(new Dec(Math.PI), rem);
            }
            case "_E": {
                return this.res(new Dec(Math.E), rem);
            }
            case "_DEVELOPERS": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.DEVELOPERS), rem);
            }
            case "_SUPPORTERS": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.SUPPORTERS), rem);
            }
            case "_SPONSORS": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.SPONSORS), rem);
            }
            case "_QUEST": {
                return this.res(new MC_QUEST(), rem);
            }
        }
        throw new ParseError("Unknown MagicConst", "Got: " + var, debugInfo);
    }

    private Group2<I_Object, String> res(I_Object result, String rem) {
        return new Group2<I_Object, String>(result, rem);
    }
}

