/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.func;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.parser.Parser_Call;
import org.jmo_lang.parser.func.I_ParseFunc;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.tools.Lib_Parser;

public class ParseFunc_StringSetGet
implements I_ParseFunc {
    @Override
    public boolean hits(char c0, String s) {
        return c0 == ':' && s.length() >= 2 && s.charAt(1) != ':';
    }

    @Override
    public Group2<Call, String> parse(App app, Block current, I_Object obj, String s, DebugInfo debugInfo) {
        String rem = s.substring(1);
        String str = this.iString(rem);
        rem = rem.substring(str.length()).trim();
        if (str.length() == 0) {
            throw new CodeError("Invalid key for set/get", "Got empty string, valid are: A-Z,a-z,0-9,_", debugInfo);
        }
        boolean isSet = rem.length() >= 2 && rem.charAt(0) == '=' && rem.charAt(1) != '=';
        return isSet ? this.iSet(app, current, obj, debugInfo, str, rem) : this.iGet(app, current, obj, debugInfo, str, rem);
    }

    private Group2<Call, String> iGet(App app, Block current, I_Object obj, DebugInfo debugInfo, String str, String rest) {
        Call[] aPos = new Call[]{new Call(current, new Str(str), debugInfo)};
        Lib_Parser.ifPars(aPos.length, 1, Integer.MAX_VALUE, debugInfo);
        Call c = new Call(current, obj, "get", aPos, debugInfo);
        return new Group2<Call, String>(c, rest);
    }

    private Group2<Call, String> iSet(App app, Block current, I_Object obj, DebugInfo debugInfo, String str, String rest) {
        String par = rest.substring(rest.indexOf(61) + 1).trim();
        Call[] aPar = Parser_Call.parseParameter(app, current, par, debugInfo);
        Err.ifNot(1, aPar.length);
        Call cPar = aPar[0];
        Call[] aPos = new Call[]{new Call(current, new Str(str), debugInfo)};
        Lib_Parser.ifPars(aPos.length, 1, Integer.MAX_VALUE, debugInfo);
        int len = aPos.length;
        Call[] ca = new Call[len + 1];
        System.arraycopy(aPos, 0, ca, 0, len);
        ca[len] = cPar;
        Call c = new Call(current, obj, "set", ca, debugInfo);
        return new Group2<Call, Object>(c, null);
    }

    private String iString(String s) {
        int p = 0;
        while (p <= s.length() - 1) {
            char c = s.charAt(p);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_')) {
                return s.substring(0, p);
            }
            ++p;
        }
        return s;
    }
}

