/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.func;

import de.mn77.base.data.group.Group2;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.parser.Parser_Call;
import org.jmo_lang.parser.func.I_ParseFunc;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;

public class ParseFunc_MathLet
implements I_ParseFunc {
    private static final String ca0 = "+-*/%&^|";
    private static final String ca1 = "+-*/&^|";

    @Override
    public boolean hits(char c0, String s) {
        if (s.length() < 3) {
            return false;
        }
        if (ca0.indexOf(c0) == -1) {
            return false;
        }
        char c1 = s.charAt(1);
        if (c1 == '=') {
            return true;
        }
        if (c0 != c1) {
            return false;
        }
        if (ca1.indexOf(c1) == -1) {
            return false;
        }
        return s.charAt(2) == '=';
    }

    @Override
    public Group2<Call, String> parse(App app, Block current, I_Object obj, String s, DebugInfo debugInfo) {
        int epos = s.indexOf(61, 1) + 1;
        String m1 = s.substring(0, epos);
        String par = s.substring(epos);
        Call[] pars = Parser_Call.parseParameter(app, current, par, debugInfo);
        if (pars.length != 1) {
            throw new ParseError("Invalid function call!", "Missing or too much parameter(s) for: " + m1, debugInfo);
        }
        Call c = new Call(current, obj, m1, pars, debugInfo);
        return new Group2<Call, Object>(c, null);
    }
}

