/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.fdef;

import de.mn77.base.sys.MOut;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.fdef.I_ParseFDef;
import org.jmo_lang.parser.fdef.Lib_FDef;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.Type;

public class ParseFDef_Direct
implements I_ParseFDef {
    private static final String regex = "^([a-z_][A-Za-z0-9_]*)(\\s+|\\s*[({]\\s*[)}]\\s*)?([A-Z][A-Za-z0-9_]*[?]?)?(\\s*=\\s*.*)?$";

    @Override
    public boolean hits(String s) {
        return s.matches(regex);
    }

    @Override
    public Function parse(App app, Type type, String s, DebugInfo debug) {
        char c0;
        String name = s.replaceFirst(regex, "$1");
        String rest = s.substring(name.length()).trim();
        if (rest.length() == 0) {
            return new Function(type, name, null, false, null, false, debug);
        }
        boolean control = false;
        char rc0 = rest.charAt(0);
        if (rc0 == '(') {
            rest = rest.substring(rest.indexOf(41) + 1).trim();
        } else if (rc0 == '{') {
            rest = rest.substring(rest.indexOf(125) + 1).trim();
            control = true;
        }
        String sReturnType = null;
        if (rest.length() > 0 && rest.charAt(0) != '=') {
            String regexReturnType = "^([A-Z][A-Za-z0-9_]*).*$";
            sReturnType = rest.replaceFirst("^([A-Z][A-Za-z0-9_]*).*$", "$1");
            rest = rest.substring(sReturnType.length()).trim();
        }
        if (sReturnType != null && sReturnType.length() > 0 && ((c0 = sReturnType.charAt(0)) == '(' || c0 == '{')) {
            throw new ParseError("Invalid function definition!", "Use () or {}, but not " + sReturnType, debug);
        }
        boolean returnNil = false;
        if (sReturnType != null && sReturnType.length() > 0 && sReturnType.endsWith("?")) {
            returnNil = true;
            MOut.exit(sReturnType, sReturnType.substring(0, sReturnType.length() - 2));
            sReturnType = sReturnType.substring(0, sReturnType.length() - 2);
        }
        app.strict.checkFuncResultType(sReturnType, name, debug);
        Function f = new Function(type, name, null, control, sReturnType, returnNil, debug);
        if (rest.length() > 0 && rest.charAt(0) == '=') {
            Lib_FDef.setReturnCall(rest, app, f, debug);
        }
        return f;
    }
}

