/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.sys.MOut;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.parser.Parser_Block;
import org.jmo_lang.parser.fdef.I_ParseFDef;
import org.jmo_lang.parser.fdef.ParseFDef_Direct;
import org.jmo_lang.parser.fdef.ParseFDef_ParMulti;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.Type;
import org.jmo_lang.tools.LineBuffer;

public class Parser_Function {
    private static final I_ParseFDef[] funcparser = new I_ParseFDef[]{new ParseFDef_Direct(), new ParseFDef_ParMulti()};

    public static void parse(App app, Type currentType, LineBuffer buffer, String s) {
        MOut.debug("Parse Function-Head", s);
        I_ParseFDef[] i_ParseFDefArray = funcparser;
        int n = funcparser.length;
        int n2 = 0;
        while (n2 < n) {
            I_ParseFDef pf = i_ParseFDefArray[n2];
            if (pf.hits(s)) {
                Function f = pf.parse(app, currentType, s, buffer.gDebugInfo());
                if (currentType.getFunctions().knows(f.getName())) {
                    throw new ParseError("Name of the function is already used!", "::" + f.getName(), buffer.gDebugInfo());
                }
                if (Lib_Array.knows(A_Object.blockedFunctions, f.getName())) {
                    throw new ParseError("Invalid definition, name for Function reserved!", "::" + f.getName(), buffer.gDebugInfo());
                }
                currentType.getFunctions().add(f.getName(), f);
                if (buffer.nextLevelDiff() > 0) {
                    if (f.isOneLine()) {
                        throw new ParseError("No Block allowed for one-line-function!", "::" + f.getName(), buffer.gDebugInfo());
                    }
                    new Parser_Block().parse(app, currentType, f, f.getBlock(), buffer, false);
                }
                return;
            }
            ++n2;
        }
        throw new ParseError("Unknown Function-Definition", s, buffer.gDebugInfo());
    }
}

