/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.pseudo.MultiCall;
import org.jmo_lang.object.pseudo.mc.A_MagicConst;
import org.jmo_lang.parser.event.I_ParserEvStart;
import org.jmo_lang.parser.event.ParserEvStart_Direct;
import org.jmo_lang.parser.func.I_ParseFunc;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.tools.Lib_StringParser;

public class Parser_Call {
    private static int multiCallCounter = 0;
    private static final I_ParserEvStart[] parsers_EvStart = new I_ParserEvStart[]{new ParserEvStart_Direct()};

    private Parser_Call() {
    }

    public static Call parseCall(App app, Block current, String s, DebugInfo debugInfo) {
        Group2<I_Object, String> go = Parser_Call.parseObject(app, current, s, debugInfo);
        I_Object obj = (I_Object)go.o1;
        s = (String)go.o2;
        s = Parser_Call.comment(s);
        Call first = null;
        Call last = null;
        while (s != null && s.length() > 0) {
            Call c = null;
            char c0 = s.charAt(0);
            s = s.trim();
            boolean dot = false;
            if (c0 == '.' && s.length() >= 2 && !s.startsWith("..")) {
                c0 = (s = s.substring(1)).charAt(0);
                if (c0 == ' ' || c0 == '\t') {
                    throw new CodeError("Space or tab after a dot", "Got: ." + s, debugInfo);
                }
                dot = true;
            }
            if (c0 == '@') {
                Err.ifNull(obj);
                Group2<Call, String> g = Parser_Call.parseEvStart(current, obj, s, debugInfo);
                c = (Call)g.o1;
                s = (String)g.o2;
            } else {
                if (!(dot || c0 < 'a' || c0 > 'z' || obj != null && obj instanceof A_MagicConst && ((A_MagicConst)obj).withoutDot())) {
                    throw new ParseError("Missing dot or mathematical sign.", s, debugInfo);
                }
                Group2<Call, String> res = Parser_Call.parseMethod(app, current, obj, s, debugInfo);
                c = (Call)res.o1;
                s = (String)res.o2;
            }
            if (first == null) {
                first = c;
            }
            if (last != null) {
                last.setStream(c);
            }
            last = c;
            obj = null;
            if (s == null || s.length() == 0) {
                Call last2 = c.searchLastCall();
                if (c.searchLastCall() != null) {
                    last = last2;
                }
            }
            if (s == null) continue;
            s = Parser_Call.comment(s);
        }
        if (first == null) {
            first = new Call(current, obj, debugInfo);
        }
        return first;
    }

    public static Call parseCallMulti(App app, Block current, String s, DebugInfo debugInfo, int key) {
        Call c = Parser_Call.parseCall(app, current, s, debugInfo);
        MultiCall mc = new MultiCall(key, c);
        return new Call(current, mc, debugInfo);
    }

    public static Group2<I_Object, String> parseObject(App app, Block current, String s, DebugInfo debugInfo) {
        s = s.trim();
        I_ParseObject po = app.parsemanager_obj.getParser(app, current, s, debugInfo);
        return po.parse(app, current, s, debugInfo);
    }

    public static Call[] parseParameter(App app, Block current, String s, DebugInfo debugInfo) {
        if (s.length() == 0) {
            return new Call[0];
        }
        s = s.trim();
        ArrayList<Call> pars = new ArrayList<Call>();
        while (s.length() > 0) {
            Group2<Call, String> g = Parser_Call.parseParameterItem(app, current, s.trim(), debugInfo);
            pars.add((Call)g.o1);
            s = (String)g.o2;
        }
        return pars.toArray(new Call[pars.size()]);
    }

    private static String comment(String s) {
        return (s = s.trim()).length() == 0 ? "" : (s.charAt(0) == '#' ? "" : s);
    }

    private static Group2<Call, String> parseEvStart(Block current, I_Object obj, String s, DebugInfo debugInfo) {
        I_ParserEvStart[] i_ParserEvStartArray = parsers_EvStart;
        int n = parsers_EvStart.length;
        int n2 = 0;
        while (n2 < n) {
            I_ParserEvStart pes = i_ParserEvStartArray[n2];
            if (pes.hits(s)) {
                return pes.parse(current, obj, s, debugInfo);
            }
            ++n2;
        }
        throw new ParseError("Unknown Event-Start", s, debugInfo);
    }

    private static Group2<Call, String> parseMethod(App app, Block current, I_Object obj, String s, DebugInfo debugInfo) {
        I_ParseFunc pf = app.parsemanager_func.getParser(obj, s, debugInfo);
        return pf.parse(app, current, obj, s, debugInfo);
    }

    private static Group2<Call, String> parseParameterItem(App app, Block current, String s, DebugInfo debugInfo) {
        Group2<String, String> result = Lib_StringParser.getNextPar(s, debugInfo);
        String par = (String)result.o1;
        String rem = (String)result.o2;
        int key = ++multiCallCounter;
        if (par.charAt(par.length() - 1) == '.') {
            if (!par.endsWith("...")) {
                throw new ParseError("Open end of parameter", s, debugInfo);
            }
            par = par.substring(0, par.length() - 3);
            par = String.valueOf(par) + "\u00b6" + key;
            return new Group2<Call, String>(Parser_Call.parseCallMulti(app, current, par, debugInfo, key), rem);
        }
        return new Group2<Call, String>(Parser_Call.parseCall(app, current, par, debugInfo), rem);
    }
}

