/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.struct;

import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import java.util.HashMap;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.object.struct.A_Sequence;
import org.jmo_lang.object.struct.JMo_KeyValue;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_Map
extends A_Sequence
implements I_AutoBlockDo {
    private final ArrayList<I_Object> keys;
    private final ArrayList<I_Object> values;

    public JMo_Map() {
        this.keys = new ArrayList();
        this.values = new ArrayList();
    }

    public JMo_Map(ArrayList<I_Object> keys, ArrayList<I_Object> objects) {
        this.keys = keys;
        this.values = objects;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "add": {
                return A_Object.stdResult(this.add(cr));
            }
            case "remove": 
            case "sub": {
                return A_Object.stdResult(this.remove(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.clear(cr));
            }
            case "each": {
                return this.each(cr);
            }
            case "getKeys": {
                return A_Object.stdResult(this.getKeys(cr));
            }
            case "getValues": {
                return A_Object.stdResult(this.getValues(cr));
            }
            case "hasKey": 
            case "knowsKey": {
                return A_Object.stdResult(this.knowsKey(cr));
            }
            case "hasValue": 
            case "knowsValue": {
                return A_Object.stdResult(this.knowsValue(cr));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr).obj;
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cr));
    }

    public I_Table<I_Object> internalTable() {
        MTable<I_Object> tab = new MTable<I_Object>(2);
        int i = 0;
        while (i < this.keys.size()) {
            tab.add((I_Object[])new I_Object[]{this.keys.get(i), this.values.get(i)});
            ++i;
        }
        return tab;
    }

    public HashMap<I_Object, I_Object> internalMap() {
        HashMap<I_Object, I_Object> result = new HashMap<I_Object, I_Object>();
        int i = 0;
        while (i < this.keys.size()) {
            result.put(this.keys.get(i), this.values.get(i));
            ++i;
        }
        return result;
    }

    private ObjectCallResult each(CallRuntime cpOld) {
        JMo_KeyValue item;
        boolean varlet;
        I_Object[] pars = cpOld.parsFlex(this, 0, 1);
        boolean bl = varlet = pars.length == 1;
        if (varlet) {
            cpOld.parType(pars[0], VarLet.class);
        }
        Call stream = cpOld.getStream();
        Block block = cpOld.getCallBlock();
        if (stream == null && block == null) {
            throw new CodeError(cpOld, "No Stream or Block for 'each'", null);
        }
        Handle_Loop handle = new Handle_Loop(this);
        CallRuntime cpNew = cpOld.copyLoop(handle);
        I_Object res = this;
        int pos = 0;
        while (pos < this.keys.size()) {
            block13: {
                handle.startLap();
                item = new JMo_KeyValue(this.keys.get(pos), this.values.get(pos));
                if (varlet) {
                    Var o = ((VarLet)pars[0]).getVar();
                    o.let(cpNew, cpNew, item);
                }
                if (block != null) {
                    try {
                        res = block.exec(cpNew, item);
                    }
                    catch (ReturnException e) {
                        Return temp = e.get();
                        switch (temp.getLevel()) {
                            case NEXT: {
                                break block13;
                            }
                            default: {
                                return temp.getLoopResult();
                            }
                        }
                    }
                }
                if (stream != null && block == null) {
                    res = cpNew.execInit(stream, item);
                }
            }
            ++pos;
        }
        if (stream != null && block != null) {
            if (this.keys.size() == 0) {
                Err.todo("Map is empty!");
            }
            int last = this.keys.size() - 1;
            item = new JMo_KeyValue(this.keys.get(last), this.values.get(last));
            res = cpNew.execInit(stream, item);
        }
        return new ObjectCallResult(res, true);
    }

    @Override
    public Int size(CallRuntime cr) {
        cr.pars();
        return new Int(this.keys.size());
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Map(");
        int i = 0;
        while (i < this.keys.size()) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.keys.get(i).toString());
            sb.append("->");
            sb.append(this.values.get(i).toString());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private JMo_Map add(CallRuntime cr) {
        I_Object[] pars = cr.parsFlex(this, 1, 2);
        if (pars.length == 1) {
            JMo_KeyValue kv = (JMo_KeyValue)cr.parType(pars[0], JMo_KeyValue.class);
            this.iAdd(cr, kv.getKey(), kv.getValue());
        } else {
            this.iAdd(cr, pars[0], pars[1]);
        }
        return this;
    }

    @Override
    protected JMo_Map copy(CallRuntime cr) {
        cr.pars(this, new Class[0]);
        ArrayList clonek = (ArrayList)this.keys.clone();
        ArrayList cloneo = (ArrayList)this.values.clone();
        return new JMo_Map(clonek, cloneo);
    }

    @Override
    protected I_Object get(CallRuntime cr) {
        I_Object[] oa = cr.parsFlex(this, 1, Integer.MAX_VALUE);
        if (oa.length == 1) {
            I_Object key = oa[0];
            int i = this.iGetIndex(cr, key, true);
            return this.values.get(i);
        }
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object key = i_ObjectArray[n2];
            int i = this.iGetIndex(cr, key, true);
            I_Object g = this.values.get(i);
            result.add(g);
            ++n2;
        }
        return new JMo_List(result);
    }

    @Override
    protected I_Object pull(CallRuntime cr) {
        I_Object[] oa = cr.parsFlex(this, 1, Integer.MAX_VALUE);
        if (oa.length == 1) {
            I_Object key = oa[0];
            int i = this.iGetIndex(cr, key, false);
            return i == -1 ? Nil.NIL : this.values.get(i);
        }
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object key = i_ObjectArray[n2];
            int i = this.iGetIndex(cr, key, false);
            Nil g = i == -1 ? Nil.NIL : this.values.get(i);
            result.add(g);
            ++n2;
        }
        return new JMo_List(result);
    }

    private JMo_List getKeys(CallRuntime cr) {
        cr.pars(this, new Class[0]);
        ArrayList clone = (ArrayList)this.keys.clone();
        return new JMo_List(clone);
    }

    private JMo_List getValues(CallRuntime cr) {
        cr.pars(this, new Class[0]);
        ArrayList clone = (ArrayList)this.values.clone();
        return new JMo_List(clone);
    }

    @Override
    protected Bool isEmpty(CallRuntime cr) {
        cr.pars();
        return Bool.getObject(this.keys.size() == 0);
    }

    private Bool knowsKey(CallRuntime cr) {
        I_Object search = cr.pars(this, I_Object.class)[0];
        int knows = this.iGetIndex(cr, search, false);
        return knows == -1 ? Bool.FALSE : Bool.TRUE;
    }

    private Bool knowsValue(CallRuntime cr) {
        I_Object search = cr.pars(this, I_Object.class)[0];
        for (I_Object o : this.values) {
            if (!o.equals(search)) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    private JMo_Map remove(CallRuntime cr) {
        I_Object key = cr.pars(this, I_Object.class)[0];
        int i = this.iGetIndex(cr, key, true);
        this.keys.remove(i);
        this.values.remove(i);
        return this;
    }

    private JMo_Map clear(CallRuntime cr) {
        cr.pars(this, new Class[0]);
        this.keys.clear();
        this.values.clear();
        return this;
    }

    @Override
    protected JMo_Map set(CallRuntime cr) {
        I_Object[] oa = cr.pars(this, I_Object.class, I_Object.class);
        I_Object key = oa[0];
        I_Object value = oa[1];
        int i = this.iGetIndex(cr, key, true);
        this.values.set(i, value);
        return this;
    }

    @Override
    protected JMo_Map put(CallRuntime cr) {
        I_Object[] oa = cr.pars(this, I_Object.class, I_Object.class);
        int pos = this.iGetIndex(cr, oa[0], false);
        if (pos >= 0) {
            this.values.set(pos, oa[1]);
        } else {
            this.iAdd(cr, oa[0], oa[1]);
        }
        return this;
    }

    private void iAdd(CallRuntime cr, I_Object key, I_Object value) {
        int i = this.iGetIndex(cr, key, false);
        if (i != -1) {
            throw new ExecError(cr, "Duplicated Key", "Got: " + key);
        }
        this.keys.add(key);
        this.values.add(value);
    }

    private int iGetIndex(CallRuntime cr, I_Object key, boolean error) {
        int i = 0;
        while (i < this.keys.size()) {
            boolean equal = this.keys.get(i).toString().equals(key.toString());
            if (equal) {
                return i;
            }
            ++i;
        }
        if (error) {
            throw new ExecError(cr, "Unknown key", "Got: " + key);
        }
        return -1;
    }

    @Override
    protected JMo_KeyValue first(CallRuntime cr) {
        cr.pars();
        return new JMo_KeyValue(this.keys.get(0), this.values.get(0));
    }

    @Override
    protected JMo_KeyValue last(CallRuntime cr) {
        cr.pars();
        int idx = this.keys.size() - 1;
        return new JMo_KeyValue(this.keys.get(idx), this.values.get(idx));
    }

    @Override
    protected I_Object internalDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        I_Object key = cr.parType(keys[offset], I_Object.class);
        if (!this.keys.contains(key)) {
            if (lazy) {
                return Nil.NIL;
            }
            throw new ExecError(cr, "Unknown key for Map.", "Key is missing! Got: " + key);
        }
        if (offset == keys.length - 1) {
            int pos = this.iGetIndex(cr, key, true);
            return this.values.get(pos);
        }
        int pos = this.iGetIndex(cr, key, true);
        I_Object deeper = this.values.get(pos);
        if (!(deeper instanceof A_Sequence)) {
            throw new ExecError(cr, "Invalid type of value.", "Value to key " + key.toDebug(cr) + " isn't a sequence, so I can't go into it!");
        }
        A_Sequence deeper2 = (A_Sequence)deeper;
        return deeper2.internalDeepGet(cr, keys, offset + 1, lazy);
    }

    @Override
    protected void internalDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        I_Object key = cr.parType(keys[offset], I_Object.class);
        int idx = this.iGetIndex(cr, key, !lazy);
        if (offset == keys.length - 1) {
            if (idx == -1) {
                if (lazy) {
                    this.keys.add(key);
                    this.values.add(value);
                    return;
                }
                throw new ExecError(cr, "Unknown key for Map.", "Key is missing! Got: " + key);
            }
            this.values.set(idx, value);
        } else {
            I_Object deeper;
            if (idx == -1) {
                if (lazy) {
                    this.keys.add(key);
                    this.values.add(new JMo_Map());
                    idx = this.values.size() - 1;
                } else {
                    throw new ExecError(cr, "Unknown key for Map.", "Key is missing! Got: " + key);
                }
            }
            if (!((deeper = this.values.get(idx)) instanceof A_Sequence)) {
                throw new ExecError(cr, "Invalid type of value.", "Value to key " + key.toDebug(cr) + " isn't a sequence, so I can't go into it!");
            }
            A_Sequence deeper2 = (A_Sequence)deeper;
            deeper2.internalDeepSet(cr, keys, offset + 1, value, lazy);
        }
    }
}

