/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.struct;

import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.pseudo.FuncLet;
import org.jmo_lang.object.struct.A_Sequence;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Sequence;
import org.jmo_lang.tools.Lib_Type;

public class JMo_Makro
extends A_Sequence
implements I_AutoBlockDo {
    private final ArrayList<I_Object> items;

    public JMo_Makro() {
        this(null, new ArrayList<I_Object>());
    }

    public JMo_Makro(CallRuntime cr, ArrayList<I_Object> items) {
        this.items = items;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "add": {
                return A_Object.stdResult(this.add(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.clear(cr));
            }
            case "items": {
                return A_Object.stdResult(this.getItems(cr));
            }
            case "exec": {
                return A_Object.stdResult(this.exec(cr));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.exec(cr);
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cr));
    }

    @Override
    public Int size(CallRuntime cr) {
        cr.pars();
        return new Int(this.items.size());
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return Lib_Type.getName(this);
    }

    private JMo_Makro add(CallRuntime cr) {
        I_Object[] pars;
        I_Object[] i_ObjectArray = pars = cr.parsFlex(this, 1);
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            FuncLet func = (FuncLet)cr.parType(par, FuncLet.class);
            this.items.add(func);
            ++n2;
        }
        return this;
    }

    @Override
    protected JMo_Makro copy(CallRuntime cr) {
        cr.pars();
        ArrayList clone = (ArrayList)this.items.clone();
        return new JMo_Makro(cr, clone);
    }

    @Override
    protected Bool isEmpty(CallRuntime cr) {
        cr.pars();
        return Bool.getObject(this.items.isEmpty());
    }

    private JMo_Makro clear(CallRuntime cr) {
        cr.pars();
        this.items.clear();
        return this;
    }

    private JMo_List getItems(CallRuntime cr) {
        cr.pars(this, new Class[0]);
        ArrayList clone = (ArrayList)this.items.clone();
        return new JMo_List(clone);
    }

    private JMo_Makro exec(CallRuntime cr) {
        cr.pars();
        for (I_Object item : this.items) {
            if (item == Nil.NIL) continue;
            ((FuncLet)item).exec(cr);
        }
        return this;
    }

    @Override
    protected I_Object first(CallRuntime cr) {
        cr.pars();
        return this.items.size() == 0 ? Nil.NIL : this.items.get(0);
    }

    @Override
    protected I_Object last(CallRuntime cr) {
        cr.pars();
        return this.items.size() == 0 ? Nil.NIL : this.items.get(this.items.size() - 1);
    }

    @Override
    protected I_Object get(CallRuntime cr) {
        A_IntNumber pos = (A_IntNumber)cr.pars(this, A_IntNumber.class)[0];
        int pos2 = Lib_Convert.getIntValue(cr, pos);
        Lib_Error.ifNotBetween(cr, 1, this.items.size(), pos2, "position");
        return this.items.get(pos2 - 1);
    }

    @Override
    protected I_Object pull(CallRuntime cr) {
        A_IntNumber pos = (A_IntNumber)cr.pars(this, A_IntNumber.class)[0];
        int pos2 = Lib_Convert.getIntValue(cr, pos);
        if (pos2 > this.items.size()) {
            return Nil.NIL;
        }
        Lib_Error.ifNotBetween(cr, 1, this.items.size(), pos2, "position");
        return this.items.get(pos2 - 1);
    }

    @Override
    protected JMo_Makro set(CallRuntime cr) {
        I_Object[] oa = cr.pars(this, A_IntNumber.class, FuncLet.class);
        int pos = Lib_Convert.getIntValue(cr, oa[0]);
        Lib_Error.ifNotBetween(cr, 1, this.items.size(), pos, "position");
        FuncLet o = (FuncLet)oa[1];
        this.items.set(pos - 1, o);
        return this;
    }

    @Override
    protected I_Object put(CallRuntime cr) {
        I_Object[] oa = cr.pars(this, A_IntNumber.class, FuncLet.class);
        int pos = Lib_Convert.getIntValue(cr, oa[0]);
        while (pos > this.items.size()) {
            this.items.add(Nil.NIL);
        }
        Lib_Error.ifNotBetween(cr, 1, this.items.size(), pos, "position");
        FuncLet o = (FuncLet)oa[1];
        this.items.set(pos - 1, o);
        return this;
    }

    @Override
    protected I_Object internalDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.parType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPos(cr, i, this.items.size(), lazy);
        if (pos > this.items.size()) {
            if (lazy) {
                return Nil.NIL;
            }
            Lib_Error.ifNotBetween(cr, 1, this.items.size(), pos, "position in makro");
        }
        if (offset == keys.length - 1) {
            return this.items.get(pos - 1);
        }
        throw new ExecError(cr, "Invalid access for Makro.", "A Makro is only in one dimension and has no deeper objects");
    }

    @Override
    protected void internalDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.parType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPos(cr, i, this.items.size(), lazy);
        if (lazy) {
            while (this.items.size() < pos) {
                this.items.add(Nil.NIL);
            }
        }
        if (offset != keys.length - 1) {
            throw new ExecError(cr, "Invalid access for Makro.", "A Makro is only in one dimension and has no deeper objects");
        }
        this.items.set(pos - 1, value);
    }
}

