/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.Lib_FileSys;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.filesys.A_FileSys;
import org.jmo_lang.object.filesys.JMo_File;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.ParCallBuffer;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Output;

public class JMo_Dir
extends A_FileSys
implements I_Object {
    private final ParCallBuffer par;
    private File file = null;

    public JMo_Dir() {
        this.par = null;
        this.file = null;
    }

    public JMo_Dir(Call par) {
        Err.ifNull(par);
        this.par = new ParCallBuffer(par);
        this.file = null;
    }

    public JMo_Dir(File f) {
        Err.ifNull(f);
        this.par = null;
        this.file = f;
    }

    @Override
    protected void init2(CallRuntime cr) {
        if (this.par != null) {
            I_Object filename = this.par.init(cr, this, Str.class);
            String sDir = ((Str)filename).getValue();
            this.file = new File(sDir);
            return;
        }
        if (this.par == null && this.file == null) {
            this.file = new File(Sys.getCurrentDir());
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "list": {
                return A_Object.stdResult(this.list(cr));
            }
            case "files": {
                return A_Object.stdResult(this.files(cr));
            }
            case "dirs": {
                return A_Object.stdResult(this.dirs(cr));
            }
            case "create": {
                return A_Object.stdResult(this.create(cr));
            }
            case "makeDir": {
                return A_Object.stdResult(this.makeDir(cr));
            }
            case "rename": {
                return A_Object.stdResult(this.rename(cr));
            }
            case "move": {
                return A_Object.stdResult(this.move(cr));
            }
            case "delete": {
                return A_Object.stdResult(this.delete(cr));
            }
        }
        return null;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        String p = Lib_Output.toDebug(cr, this.par.get());
        if (p.length() != 0) {
            p = "(" + p + ")";
        }
        return "Dir" + p;
    }

    @Override
    public String toString() {
        return this.file.getAbsolutePath();
    }

    @Override
    public File getInternalFile() {
        return this.file;
    }

    private JMo_List dirs(CallRuntime cr) {
        cr.pars();
        return this.iDirList(false, true);
    }

    private JMo_List files(CallRuntime cr) {
        cr.pars();
        return this.iDirList(true, false);
    }

    private JMo_List iDirList(boolean files, boolean dirs) {
        File[] dirContent;
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        File[] fileArray = dirContent = this.file.listFiles();
        int n = dirContent.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            boolean isf = f.isFile();
            if (isf && files) {
                al.add(new JMo_File(f));
            }
            if (!isf && dirs) {
                al.add(new JMo_Dir(f));
            }
            ++n2;
        }
        return new JMo_List(al);
    }

    private JMo_List list(CallRuntime cr) {
        cr.pars();
        return this.iDirList(true, true);
    }

    private JMo_Dir create(CallRuntime cr) {
        cr.pars();
        String path = this.file.getAbsolutePath();
        try {
            Lib_FileSys.createPathStructure(path);
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "Can't create Directory", path);
        }
        return this;
    }

    private JMo_Dir makeDir(CallRuntime cr) {
        Str par = (Str)cr.pars(this, Str.class)[0];
        String newDirName = par.getValue();
        if (newDirName.contains(Sys.getSeperatorDir())) {
            throw new ExtError(cr, "Can't create Directory", "No target-path allowed");
        }
        newDirName = this.file + Sys.getSeperatorDir() + newDirName;
        try {
            Lib_FileSys.createPathStructure(newDirName);
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "Can't create Directory", newDirName);
        }
        return new JMo_Dir(new File(newDirName));
    }

    protected I_Object rename(CallRuntime cr) {
        Str par = (Str)cr.pars(this, Str.class)[0];
        String newName = Lib_Convert.getStringValue(cr, par);
        if (newName.contains(Sys.getSeperatorDir())) {
            throw new ExtError(cr, "Directory-Rename failed", "No target-path allowed");
        }
        newName = String.valueOf(this.file.getParent()) + Sys.getSeperatorDir() + newName;
        File newFile = new File(newName);
        boolean done = this.file.renameTo(newFile);
        if (!done) {
            throw new ExtError(cr, "Directory-Rename failed", String.valueOf(this.file.getAbsolutePath()) + " --> " + newFile.getAbsolutePath());
        }
        this.file = newFile;
        return this;
    }

    private Nil delete(CallRuntime cr) {
        boolean deleted;
        cr.pars();
        File f = this.getInternalFile();
        if (f.exists() && !(deleted = f.delete())) {
            throw new ExtError(cr, "File-Delete-Error", this.getInternalFile().getAbsolutePath());
        }
        return Nil.NIL;
    }

    private A_FileSys move(CallRuntime cr) {
        Str par = (Str)cr.pars(this, Str.class)[0];
        String newPath = Lib_Convert.getStringValue(cr, par);
        File target = new File(newPath);
        try {
            Files.move(this.file.toPath(), target.toPath(), new CopyOption[0]);
            this.file = target;
            return this;
        }
        catch (IOException e) {
            throw new ExtError(cr, "Directory-Move-Error", String.valueOf(this.file.getAbsolutePath()) + " --> " + target.getAbsolutePath());
        }
    }
}

