/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.classic;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_ControlObject;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Decimal;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.I_AutoBlockList;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.ParCallBuffer;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Type;

public class JMo_Count
extends A_Object
implements I_AutoBlockDo,
I_AutoBlockList,
I_ControlObject {
    private static final Class<? extends I_Object>[] typesStart = new Class[]{A_Number.class, Bool.class, Char.class, JMo_Range.class};
    private static final Class<? extends I_Object>[] typesEnd = new Class[]{A_Number.class, Bool.class, Char.class};
    private static final Class<? extends I_Object>[] typesStep = new Class[]{A_Number.class};
    private ParCallBuffer start;
    private ParCallBuffer end;
    private ParCallBuffer step;

    public JMo_Count(Call end_or_range) {
        this(end_or_range, null, null);
    }

    public JMo_Count(Call start, Call end) {
        this(start, end, null);
    }

    public JMo_Count(Call start, Call end, Call step) {
        this.start = new ParCallBuffer(start);
        this.end = end == null ? null : new ParCallBuffer(end);
        this.step = step == null ? null : new ParCallBuffer(step);
    }

    @Override
    public void init(CallRuntime cr) {
        this.start.initExt(cr, this, typesStart);
        if (this.end != null) {
            this.end.initExt(cr, this, typesEnd);
        }
        if (this.step != null) {
            this.step.init(cr, this, A_Number.class);
        }
        if (this.start != null && this.start.get() instanceof JMo_Range && this.step != null) {
            Lib_Error.ifPars(3, 1, 2, cr);
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "each": {
                return this.each(cr, false, true);
            }
            case "toList": {
                return this.each(cr, true, true);
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr, (boolean)false, (boolean)true).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        return ((JMo_List)this.each((CallRuntime)cr, (boolean)true, (boolean)false).obj).getInternalObject();
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cr));
    }

    public ObjectCallResult each(CallRuntime cpOld, boolean toList, boolean execBlockStream) {
        ArrayList<I_Object> list;
        if (cpOld.call == null && execBlockStream) {
            Err.invalid(cpOld.call, toList, execBlockStream);
        }
        I_Object[] pars = cpOld.parsFlex(this, 0, execBlockStream ? 1 : 0);
        BlockExecArgs args = new BlockExecArgs(pars);
        I_Object result = this;
        ArrayList<I_Object> arrayList = list = toList ? new ArrayList<I_Object>() : null;
        if (Lib_Type.typeIs(cpOld, this.start.get(), JMo_Range.class)) {
            if (this.step != null) {
                throw new CodeError(cpOld, "Invalid parameter-count", "With Range, only 1 or 2 pars are allowed.");
            }
            Group2<ParCallBuffer, ParCallBuffer> range = ((JMo_Range)this.start.get()).getInternalValues();
            this.start = (ParCallBuffer)range.o1;
            if (this.end != null) {
                this.step = this.end;
            }
            this.end = (ParCallBuffer)range.o2;
        }
        if (this.start != null && this.end == null && this.step == null) {
            this.end = this.start;
            this.start = new ParCallBuffer(new Call(cpOld.getSurrBlock(), new Int(1), cpOld.getDebugInfo()));
            this.start.init(cpOld, this, Int.class);
        }
        if (execBlockStream && cpOld.getStream() == null && cpOld.getCallBlock() == null) {
            return new ObjectCallResult(this.end.get(), true);
        }
        Handle_Loop handle = new Handle_Loop(this);
        CallRuntime cpNew = cpOld.copyLoop(handle);
        if (Lib_Type.typeIs(cpNew, this.start.get(), I_Integer.class, Char.class) && Lib_Type.typeIs(cpNew, this.end.get(), I_Integer.class, Char.class) && (this.step == null || Lib_Type.typeIs(cpNew, this.step.get(), I_Integer.class))) {
            int i3;
            boolean desc;
            int i1 = Lib_Convert.getIntValue(cpNew, this.start.get(), true);
            int i2 = Lib_Convert.getIntValue(cpNew, this.end.get(), true);
            boolean bl = desc = i2 < i1;
            int n = this.step == null ? (desc ? -1 : 1) : (i3 = Lib_Convert.getIntValue(cpNew, this.step.get()));
            if (desc && i3 > 0 || !desc && i3 < 0) {
                throw new ExecError(cpNew, "Endless running loop", "From " + i1 + " to " + i2 + " with stepping " + i3);
            }
            int i = 0;
            I_Object it = null;
            i = i1;
            while (!(desc ? i < i2 : i > i2)) {
                handle.startLap();
                boolean last = desc ? i <= i2 : i >= i2;
                it = this.iEachIntToObject(Lib_Type.getType(cpNew, this.start.get()), Lib_Type.getType(cpNew, this.end.get()), i, pars);
                if (toList) {
                    list.add(it);
                } else if (execBlockStream) {
                    result = Lib_Exec.execBlockStream(cpNew, args, it);
                    if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                        return ((Return)result).getLoopResult();
                    }
                }
                if (!last) {
                    i1 = Lib_Convert.getIntValue(cpNew, this.start.getInit(cpNew, this, typesStart), true);
                    i2 = Lib_Convert.getIntValue(cpNew, this.end.getInit(cpNew, this, typesEnd), true);
                    boolean bl2 = desc = i2 < i1;
                    i3 = this.step == null ? (desc ? -1 : 1) : Lib_Convert.getIntValue(cpNew, cpNew.parType(this.step.getInit(cpNew, this, typesStep), Int.class));
                }
                i += i3;
            }
        } else if (Lib_Type.typeIs(cpNew, this.start.get(), I_Decimal.class, I_Integer.class) && Lib_Type.typeIs(cpNew, this.end.get(), I_Decimal.class, I_Integer.class) && (this.step == null || Lib_Type.typeIs(cpNew, this.step.get(), I_Decimal.class, I_Integer.class))) {
            double d3;
            boolean desc;
            double d1 = Lib_Convert.getDoubleValue(cpNew, this.start.get());
            double d2 = Lib_Convert.getDoubleValue(cpNew, this.end.get());
            boolean bl = desc = d2 < d1;
            double d = this.step == null ? (double)(desc ? -1 : 1) : (d3 = Lib_Convert.getDoubleValue(cpNew, this.step.get()));
            if (desc && d3 > 0.0 || !desc && d3 < 0.0) {
                throw new ExecError(cpNew, "Endless running Counter", "From " + d1 + " to " + d2 + " with stepping " + d3);
            }
            double d4 = d1;
            while (!(desc ? !(d4 >= d2) : !(d4 <= d2))) {
                handle.startLap();
                boolean last = desc ? d4 <= d2 : d4 >= d2;
                Dec it = new Dec(d4);
                if (toList) {
                    list.add(it);
                } else if (execBlockStream) {
                    result = Lib_Exec.execBlockStream(cpNew, args, it);
                    if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                        return ((Return)result).getLoopResult();
                    }
                }
                if (!last) {
                    d1 = Lib_Convert.getDoubleValue(cpNew, this.start.getInit(cpNew, this, new Class[0]));
                    d2 = Lib_Convert.getDoubleValue(cpNew, this.end.getInit(cpNew, this, new Class[0]));
                    boolean bl3 = desc = d2 < d1;
                    d3 = this.step == null ? (double)(desc ? -1 : 1) : Lib_Convert.getDoubleValue(cpNew, cpNew.parTypeExt(this.step.getInit(cpNew, this, new Class[0]), typesStep));
                }
                d4 += d3;
            }
        } else {
            throw new CodeError(cpNew, "Invalid parameters", this.toDebug(cpNew));
        }
        return toList ? new ObjectCallResult(new JMo_List(list), false) : new ObjectCallResult(result, true);
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        String par = this.start.toString();
        if (this.end != null) {
            par = String.valueOf(par) + "," + this.end.toString();
        }
        if (this.step != null) {
            par = String.valueOf(par) + "," + this.step.toString();
        }
        return "Count(" + par + ")";
    }

    private I_Object iEachIntToObject(Class<?> start, Class<?> end, int i, I_Object[] pars) {
        int idx_end;
        Class[] arr = new Class[]{Bool.class, JMo_Byte.class, JMo_Short.class, Int.class, JMo_Long.class, Char.class};
        int idx_start = Lib_Array.indexOf(start, arr);
        Class typ = arr[Math.max(idx_start, idx_end = Lib_Array.indexOf(end, arr))];
        if (typ == Bool.class) {
            return Bool.getObject(i != 0);
        }
        if (typ == JMo_Byte.class) {
            return new JMo_Byte((byte)i);
        }
        if (typ == JMo_Short.class) {
            return new JMo_Short((short)i);
        }
        if (typ == Int.class) {
            return new Int(i);
        }
        if (typ == JMo_Long.class) {
            return new JMo_Long(i);
        }
        if (typ == Char.class) {
            return new Char((char)i);
        }
        throw Err.todo(typ, i);
    }
}

