/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.error.Err;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.I_Decimal;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Exec;

public class Bool
extends A_Atomic
implements I_Integer,
I_Atomic,
I_AutoBlockDo {
    public static final Bool TRUE = new Bool(true);
    public static final Bool FALSE = new Bool(false);
    private final boolean value;

    public static final Bool getObject(boolean b) {
        return b ? TRUE : FALSE;
    }

    private Bool(boolean val) {
        this.value = val;
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "else": {
                return this.doElse(cr);
            }
            case "use": {
                return A_Object.stdResult(this.use(cr));
            }
            case "+": 
            case "add": {
                return A_Object.stdResult(this.add(cr));
            }
            case "!&&": 
            case "nand": {
                return A_Object.stdResult(this.comparsion2(cr, COMPARE2.NAND));
            }
            case "!||": 
            case "nor": {
                return A_Object.stdResult(this.comparsion2(cr, COMPARE2.NOR));
            }
            case "!^^": 
            case "xnor": {
                return A_Object.stdResult(this.comparsion2(cr, COMPARE2.XNOR));
            }
            case "!": 
            case "not": {
                return A_Object.stdResult(this.not(cr));
            }
            case "&&": 
            case "and": {
                return A_Object.stdResult(this.comparsion2(cr, COMPARE2.AND));
            }
            case "or": 
            case "||": {
                return A_Object.stdResult(this.comparsion2(cr, COMPARE2.OR));
            }
            case "^^": 
            case "xor": {
                return A_Object.stdResult(this.comparsion2(cr, COMPARE2.XOR));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.doIf((CallRuntime)cr, (boolean)false, (boolean)false, (boolean)false).obj;
    }

    @Override
    public Integer compareTo3(I_AtomicValue o) {
        if (o instanceof Bool) {
            return new Boolean(this.value).compareTo(((Bool)o).getValue());
        }
        return null;
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return Lib_AtomConv.convert(cr, ATOMIC.BOOL, to, this, this.getValue());
    }

    @Override
    protected Int length(CallRuntime cr) {
        return new Int(this.value ? 4 : 5);
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public int getIntValue(CallRuntime cr) {
        return this.value ? 1 : 0;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected Bool comparsion(CallRuntime cr, COMPARE m) {
        I_Object raw = cr.parsExt(this, new Class[][]{{Bool.class, A_Number.class}})[0];
        int par = Lib_Convert.getIntValue(cr, raw);
        int val = this.value ? 1 : 0;
        switch (m) {
            case G: {
                return Bool.getObject(val > par);
            }
            case L: {
                return Bool.getObject(val < par);
            }
            case GE: {
                return Bool.getObject(val >= par);
            }
            case LE: {
                return Bool.getObject(val <= par);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    protected Bool comparsion2(CallRuntime cr, COMPARE2 m) {
        boolean val = this.value;
        if (val) {
            switch (m) {
                case OR: {
                    return TRUE;
                }
                case NOR: {
                    return FALSE;
                }
            }
        } else {
            switch (m) {
                case AND: {
                    return FALSE;
                }
                case NAND: {
                    return TRUE;
                }
            }
        }
        I_Object raw = cr.pars(this, Bool.class)[0];
        boolean par = Lib_Convert.getBoolValue(cr, raw);
        switch (m) {
            case AND: {
                return Bool.getObject(val && par);
            }
            case OR: {
                return Bool.getObject(val || par);
            }
            case XOR: {
                return Bool.getObject(val ^ par);
            }
            case NAND: {
                return Bool.getObject(!val || !par);
            }
            case NOR: {
                return Bool.getObject(!val && !par);
            }
            case XNOR: {
                return Bool.getObject(!(val ^ par));
            }
        }
        throw Err.todo(new Object[]{cr, m});
    }

    private I_Object add(CallRuntime cr) {
        int vn;
        String vb;
        I_Object para = cr.pars(this, A_Atomic.class)[0];
        String string = vb = this.value ? "true" : "false";
        if (para instanceof Str) {
            return new Str(String.valueOf(vb) + ((Str)para).getValue());
        }
        if (para instanceof Char) {
            return new Str(String.valueOf(vb) + ((Char)para).getValue());
        }
        int n = vn = this.value ? 1 : 0;
        if (para instanceof Bool) {
            return this.comparsion2(cr, COMPARE2.AND);
        }
        if (para instanceof JMo_Long) {
            return new JMo_Long((long)vn + ((JMo_Long)para).getValue());
        }
        if (para instanceof I_Decimal) {
            return new Dec((double)vn + Lib_Convert.getDoubleValue(cr, para));
        }
        if (para instanceof I_Integer) {
            return new Int(vn + Lib_Convert.getIntValue(cr, para));
        }
        throw Err.invalid(para);
    }

    private I_Object use(CallRuntime cr) {
        return this.value ? cr.parsOneAdvance(this, 0, I_Object.class) : cr.parsOneAdvance(this, 1, I_Object.class);
    }

    private Bool not(CallRuntime cr) {
        cr.pars();
        return Bool.getObject(!this.value);
    }

    private ObjectCallResult doElse(CallRuntime cr) {
        boolean withPar;
        I_Object[] pars = cr.parsFlex(this, 0, 1);
        if (this.value) {
            return new ObjectCallResult(this, true);
        }
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        boolean bl = withPar = pars != null && pars.length == 1;
        if (!withPar && stream == null && block == null) {
            return new ObjectCallResult(this, true);
        }
        boolean check = this.value;
        if (withPar) {
            I_Object base = cr.parType(pars[0], Bool.class);
            check = ((Bool)base).getValue();
        } else {
            check = !this.value;
        }
        I_Object res = Bool.getObject(check);
        Bool it = Bool.getObject(check);
        Bool its = Bool.getObject(check);
        res = Lib_Exec.execIf(cr, block, stream, check, it, its, false, res);
        return new ObjectCallResult(res, true);
    }

    static enum COMPARE2 {
        AND,
        OR,
        XOR,
        NAND,
        NOR,
        XNOR;

    }
}

