/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.cli;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.version.Lib_Version;
import de.mn77.base.version.VersionData_ABC;
import de.mn77.spec.terminal.COLOR_BG;
import de.mn77.spec.terminal.COLOR_FG;
import de.mn77.spec.terminal.MTerminal;
import java.io.IOException;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.struct.App;

public class JMo_CLI {
    private static final VersionData_ABC version = new VersionData_ABC(0, 5, 2);

    public static void main(String[] args) {
        MOut.debugNo();
        MOut.setJavaErrors(false);
        MOut.setLineBreak("\r\n");
        try {
            Lib_Version.init(version, false);
            JMo_CLI cli = new JMo_CLI();
            cli.start(false, false);
        }
        catch (Throwable e) {
            Err.exit(e);
        }
    }

    public void start(boolean parseOnly, boolean debug) throws IOException, Err_FileSys {
        MOut.setLineBreak("\r\n");
        Lib_Version.initKeep(version);
        Parser_App parser = new Parser_App();
        MTerminal terminal = new MTerminal();
        if (debug) {
            terminal.setDebug();
        }
        parser.setTerminalRawMode(terminal.isInRawMode());
        this.headline(terminal, parser);
        boolean run = true;
        while (run) {
            run = this.runTerminal(parser, terminal, null, parseOnly);
        }
        MOut.text("Good Bye!");
    }

    public boolean runTerminal(Parser_App parser, MTerminal terminal, String in, boolean parseOnly) throws IOException, Err_FileSys {
        String uin = in;
        if (uin == null) {
            uin = this.readline(terminal);
        }
        if (uin == null || uin.equals("exit") || uin.equals("quit") || uin.equals("q")) {
            terminal.print("\r\n");
            terminal.closeTerminal();
            return false;
        }
        Group2<String, Boolean> result = this.exec(parser, uin, parseOnly);
        if (terminal != null) {
            if (terminal.isInRawMode()) {
                COLOR_FG color = (Boolean)result.o2 != false ? COLOR_FG.GREEN : COLOR_FG.RED;
                String output = terminal.isInRawMode() ? Lib_String.replace((String)result.o1, '\n', "\n\r") : (String)result.o1;
                terminal.print(new Object[]{color, "\r=>   ", output, "\r\n", COLOR_FG.DEFAULT});
            } else {
                terminal.print("=>   ", result.o1, "\n");
            }
        }
        return true;
    }

    private Group2<String, Boolean> exec(Parser_App parser, String s, boolean testOnly) throws Err_FileSys {
        int linebreak;
        String result = null;
        boolean ok = false;
        try {
            App app = parser.parseText(s);
            result = testOnly ? null : app.exec(null);
            ok = true;
        }
        catch (ErrorBaseDebug t) {
            MOut.text(t.toInfo());
            result = "Error";
        }
        catch (Throwable t) {
            String errMsg = "Error   : Java-Error\r\n";
            MOut.text("Error   : Java-Error\r\n" + t.getMessage());
            result = "Error";
        }
        if (result == null) {
            result = "";
        }
        result = (linebreak = result.indexOf(10)) == -1 ? result : String.valueOf(result.substring(0, linebreak)) + "\u00b6\u2026";
        return new Group2<String, Boolean>(result, ok);
    }

    private void headline(MTerminal terminal, Parser_App parser) {
        String version_parser = parser.getVersionString(true, false);
        String version_cli = version.toFormat("CLI %1.%2.%3 (%b)");
        String version_date = parser.getVersion().toFormat("%dd.mm.yyyy");
        if (terminal.isInRawMode()) {
            terminal.print(new Object[]{COLOR_BG.BLUE, COLOR_FG.WHITE, "JM\u00b0", COLOR_BG.DEFAULT});
            terminal.print(new Object[]{COLOR_FG.YELLOW, " " + version_parser});
            terminal.print(new Object[]{COLOR_FG.BROWN, "  /  "});
            terminal.print(new Object[]{COLOR_FG.GREEN, version_cli});
            terminal.print(new Object[]{COLOR_FG.BROWN, "  /  "});
            terminal.print(new Object[]{COLOR_FG.LIGHTMAGENTA, version_date});
            terminal.print("\r\n\n");
        } else {
            String t = "JMo " + version_parser + "  /  " + version_cli + "  /  " + version_date;
            terminal.print(String.valueOf(t) + "\n\n");
        }
    }

    private String readline(MTerminal terminal) throws IOException {
        if (terminal.isInRawMode()) {
            terminal.print(new Object[]{COLOR_BG.DEFAULT, COLOR_FG.LIGHTBLUE, "JM\u00b0> ", COLOR_FG.DEFAULT});
            String input = terminal.readln();
            terminal.print("\r\n");
            return input;
        }
        terminal.print("JMo> ");
        return terminal.readln();
    }
}

