/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.spec.textstyler;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.type.TypeTable2;
import de.mn77.base.error.Err;
import de.mn77.spec.textstyler.TS_CONSTANTS;
import de.mn77.spec.textstyler.TS_Field;
import de.mn77.spec.textstyler.TextStyler;

public class TS_Line {
    private final TextStyler td;
    private final TypeTable2<TS_CONSTANTS, String> content;
    private I_List<TS_Field> puffer_bereiche;
    private int nextTab = 1;

    public TS_Line(TextStyler td) {
        this.td = td;
        this.content = new TypeTable2<TS_CONSTANTS, String>(TS_CONSTANTS.class, String.class);
    }

    public TS_Line l(String text) {
        Err.ifNull(text);
        this.content.add(new Object[]{TS_CONSTANTS.LEFT, text});
        return this;
    }

    public TS_Line r(String text) {
        Err.ifNull(text);
        this.content.add(new Object[]{TS_CONSTANTS.RIGHT, text});
        return this;
    }

    public TS_Line c(String text) {
        Err.ifNull(text);
        this.content.add(new Object[]{TS_CONSTANTS.CENTER, text});
        return this;
    }

    public TS_Line tc(char c) {
        this.content.add(new Object[]{TS_CONSTANTS.FILL, "" + c});
        return this;
    }

    public TS_Line t(int ... nr) {
        Err.ifOutOfBounds(0.0, 1.0, nr.length);
        int tab = nr.length == 1 ? nr[0] : this.nextTab;
        Err.ifToSmall(this.nextTab, tab);
        this.nextTab = tab + 1;
        this.content.add(new Object[]{TS_CONSTANTS.TAB, "" + tab});
        return this;
    }

    public TS_Line rtl(String text, char delimiter, int ... nr) {
        Err.ifNull(text);
        if (text.indexOf(delimiter) == -1) {
            Err.invalid("Text contains no delimiter. But it is needed!");
        }
        String r = text.substring(0, text.indexOf(delimiter));
        String l = text.substring(text.indexOf(delimiter), text.length());
        this.r(r);
        this.t(nr);
        this.l(l);
        return this;
    }

    public TextStyler gDesigner() {
        return this.td;
    }

    public I_Sequence<Integer> gBedarf() {
        this.puffer_bereiche = new MList<TS_Field>();
        TS_Field akt_bereich = new TS_Field();
        this.puffer_bereiche.add(akt_bereich);
        int naechste_flucht = 1;
        for (Group2 group2 : this.content) {
            if (group2.o1 == TS_CONSTANTS.LEFT) {
                akt_bereich.left((String)group2.o2);
            }
            if (group2.o1 == TS_CONSTANTS.CENTER) {
                akt_bereich.center((String)group2.o2);
            }
            if (group2.o1 == TS_CONSTANTS.RIGHT) {
                akt_bereich.right((String)group2.o2);
            }
            if (group2.o1 == TS_CONSTANTS.FILL) {
                akt_bereich.fill(((String)group2.o2).charAt(0));
            }
            if (group2.o1 != TS_CONSTANTS.TAB) continue;
            int fluchtnr = Integer.parseInt((String)group2.o2);
            while (naechste_flucht < fluchtnr) {
                this.puffer_bereiche.add(null);
                ++naechste_flucht;
            }
            akt_bereich = new TS_Field();
            this.puffer_bereiche.add(akt_bereich);
            ++naechste_flucht;
        }
        MList<Integer> mList = new MList<Integer>();
        for (TS_Field bereich : this.puffer_bereiche) {
            mList.add(bereich == null ? null : Integer.valueOf(bereich.needed()));
        }
        return mList;
    }

    public String get(I_Sequence<Integer> breiten) {
        Err.ifToSmall(this.puffer_bereiche.size(), breiten.size());
        while (this.puffer_bereiche.size() < breiten.size()) {
            this.puffer_bereiche.add(null);
        }
        MList<Integer> breiten2 = new MList<Integer>();
        int letzter = 1;
        int bnr = 1;
        while (bnr <= this.puffer_bereiche.size()) {
            if (this.puffer_bereiche.get(bnr) == null) {
                breiten2.set(letzter, (Integer)breiten2.get(letzter) + breiten.get(bnr));
                breiten2.add(0);
            } else {
                breiten2.add(breiten.get(bnr));
                letzter = bnr;
            }
            ++bnr;
        }
        StringBuilder sb = new StringBuilder();
        int bnr2 = 1;
        while (bnr2 <= this.puffer_bereiche.size()) {
            TS_Field bereich = (TS_Field)this.puffer_bereiche.get(bnr2);
            if (bereich != null) {
                sb.append(bereich.get((Integer)breiten2.get(bnr2)));
            }
            ++bnr2;
        }
        return sb.toString();
    }
}

