/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.version;

import de.mn77.base.MN;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.debug.DEBUG_LEVEL;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.stream.Lib_Stream;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.sys.file.Lib_Jar;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.base.sys.file.MFileSys;
import de.mn77.base.version.I_VersionData;
import de.mn77.base.version.VersionData_ABC;
import de.mn77.base.version.VersionData_Single;
import de.mn77.base.version.VersionData_Standard;
import de.mn77.base.version.VersionData_Year;
import java.io.File;
import java.io.InputStream;

public class Lib_Version {
    private static final boolean online = MN.online();

    private Lib_Version() {
        Err.forbidden("Please use statically");
    }

    public static I_VersionData init(I_VersionData info, boolean create) throws Err_FileSys {
        if (online) {
            Lib_Version.update(info);
        } else {
            Lib_Version.set(info, create);
        }
        return info;
    }

    public static I_VersionData initKeep(I_VersionData info) throws Err_FileSys {
        Lib_Version.update(info);
        return info;
    }

    private static void set(I_VersionData data, boolean create) throws Err_FileSys {
        MDateTime zp;
        long build;
        block7: {
            if (online) {
                return;
            }
            MOut.debug("Build-Nr +1");
            String filepath = Lib_Version.iFilePath();
            I_Directory current = MFileSys.current();
            if (current.knowsDir("src")) {
                current = current.dir("src");
            }
            String datei = String.valueOf(current.getPathAbsolute()) + filepath;
            String[] sa = Lib_Version.iRead(filepath);
            I_VersionData info2 = sa == null ? null : Lib_Version.iLoadedDataToObject(sa);
            boolean write = true;
            if (create && info2 != null) {
                throw Err.direct("Build-file already exist. Set 'create' to false!", new Object[0]);
            }
            if (!create && info2 == null) {
                MOut.debug("Build-Nr +1 aborted, cause of no init-data!");
                write = false;
            }
            build = info2 == null ? 0L : info2.getBuild();
            zp = new MDateTime();
            ++build;
            try {
                String s = String.valueOf(zp.toString()) + " " + build + " " + data.getDataSign() + " " + Lib_Version.iDataToString(data.toFileData());
                if (write) {
                    Lib_Version.iWrite(datei, s);
                }
            }
            catch (Err_FileSys f) {
                if (MOut.getDebugInfo() == DEBUG_LEVEL.NO) break block7;
                Err.show(f);
            }
        }
        data.update(build, zp);
    }

    private static String iDataToString(Object[] infodata) {
        String result = "";
        Object[] objectArray = infodata;
        int n = infodata.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (result.length() > 0) {
                result = String.valueOf(result) + " ";
            }
            result = String.valueOf(result) + o.toString();
            ++n2;
        }
        return result;
    }

    private static void update(I_VersionData info) throws Err_FileSys {
        String filepath = Lib_Version.iFilePath();
        String[] sa = Lib_Version.iRead(filepath);
        if (sa != null) {
            Group2<Long, I_DateTime> g = Lib_Version.iFileToBuildTime(sa);
            info.update((Long)g.o1, (I_DateTime)g.o2);
        }
    }

    private static String[] iRead(String filepath) throws Err_FileSys {
        InputStream stream = Lib_Version.iReadFile(filepath);
        if (stream == null) {
            MOut.debug("Stream-Error");
            return null;
        }
        String s = Lib_Stream.readASCII(stream);
        if (s == null || s.length() == 0) {
            MOut.debug("Nothing to read!");
            return null;
        }
        return s.trim().split(" ");
    }

    private static void iWrite(String file, String dataline) throws Err_FileSys {
        Lib_TextFile.set(new File(file), dataline, true);
    }

    private static InputStream iReadFile(String filepath) {
        try {
            return Lib_Jar.getJarStream(filepath);
        }
        catch (Err_FileSys e) {
            return null;
        }
    }

    private static String iFilePath() {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        String className = trace[3].getClassName();
        int t = 47;
        String result = String.valueOf('/') + className.replace('.', '/') + ".build";
        return result;
    }

    private static I_VersionData iLoadedDataToObject(String[] sa) {
        if (sa[0].matches("[0-9]+")) {
            return VersionData_Standard.fromOld(sa);
        }
        Group2<Long, I_DateTime> g = Lib_Version.iFileToBuildTime(sa);
        String[] sa2 = new String[sa.length - 4];
        System.arraycopy(sa, 4, sa2, 0, sa2.length);
        switch (sa[3].charAt(0)) {
            case 'a': {
                return new VersionData_Single((I_DateTime)g.o2, (Long)g.o1, sa2);
            }
            case 'b': {
                return new VersionData_ABC((I_DateTime)g.o2, (Long)g.o1, sa2);
            }
            case 's': {
                return new VersionData_Standard((I_DateTime)g.o2, (Long)g.o1, sa2);
            }
            case 'y': {
                return new VersionData_Year((I_DateTime)g.o2, (Long)g.o1, sa2);
            }
        }
        throw Err.todo(new Object[]{sa});
    }

    private static Group2<Long, I_DateTime> iFileToBuildTime(String[] sa) {
        MDateTime time = new MDateTime(String.valueOf(sa[0]) + " " + sa[1]);
        Long build = Long.parseLong(sa[2]);
        return new Group2<Long, I_DateTime>(build, time);
    }
}

