/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.stream;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.thread.A_AutoDaemon;
import de.mn77.base.thread.A_ParallelProcess;
import de.mn77.base.thread.ThreadGate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Lib_Stream {
    public static final int DEFAULT_BLOCKSIZE = 1024;

    public static String readASCII(InputStream is) throws Err_FileSys {
        StringBuffer sb = new StringBuffer();
        try {
            int readed = 0;
            while (readed >= 0) {
                readed = is.read();
                if (readed < 0) {
                    is.close();
                    continue;
                }
                sb.append((char)readed);
            }
        }
        catch (IOException e) {
            throw Err.wrap(e, "Stream-Read-Error");
        }
        return sb.toString();
    }

    public static ThreadGate connect(InputStream in, OutputStream out, boolean parallel) {
        return Lib_Stream.connect(in, out, parallel, true);
    }

    public static ThreadGate connect(InputStream in, OutputStream out, boolean parallel, boolean closeTarget) {
        return Lib_Stream.connect(in, out, parallel, closeTarget, 1024);
    }

    public static ThreadGate connect(InputStream in, OutputStream out, boolean parallel, boolean closeTarget, int block) {
        ThreadGate gate = parallel ? new ThreadGate(false) : null;
        Runnable run = () -> {
            try {
                BufferedInputStream bis = new BufferedInputStream(in);
                BufferedOutputStream bos = new BufferedOutputStream(out);
                byte[] ba = new byte[block];
                int next = 0;
                while ((next = bis.read()) > -1) {
                    bos.write(next);
                    while ((next = bis.read(ba)) == block) {
                        bos.write(ba);
                    }
                    if (next <= 0) continue;
                    bos.write(ba, 0, next);
                }
                bis.close();
                if (closeTarget) {
                    bos.close();
                } else {
                    bos.flush();
                }
                if (parallel) {
                    gate.open();
                }
            }
            catch (Throwable t) {
                Err.show(t);
            }
        };
        if (parallel) {
            new Thread(run).start();
        } else {
            run.run();
        }
        return gate;
    }

    public static A_ParallelProcess connectTerminal(final InputStream in, final OutputStream out) {
        return new A_ParallelProcess(){
            BufferedInputStream bis = null;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected void process() {
                try {
                    byte[] ba = new byte[1024];
                    int readed = -1;
                    while (true) {
                        BufferedInputStream bufferedInputStream;
                        if (this.bis != null) {
                            bufferedInputStream = this.bis;
                        } else {
                            bufferedInputStream = new BufferedInputStream(in);
                            this.bis = this.bis;
                        }
                        if ((readed = bufferedInputStream.read(ba)) <= -1) {
                            return;
                        }
                        out.write(ba, 0, readed);
                        out.flush();
                    }
                }
                catch (Throwable t) {
                    Err.show(t);
                }
            }
        };
    }

    public static void connectTerminalNonBlocking(final InputStream in, final OutputStream out, final Process p) {
        new A_AutoDaemon(){
            BufferedInputStream bis = null;

            @Override
            protected void cycle() {
                if (this.bis == null) {
                    this.bis = new BufferedInputStream(in);
                }
                try {
                    int av = this.bis.available();
                    if (av == 0 && !p.isAlive()) {
                        this.finish();
                        return;
                    }
                    if (av > 0) {
                        byte[] ba = new byte[av];
                        this.bis.read(ba);
                        out.write(ba);
                        out.flush();
                    } else {
                        Thread.yield();
                    }
                }
                catch (Throwable t) {
                    Err.show(t);
                    this.finish();
                }
            }
        };
    }
}

