/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct.hints;

import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.Lib_Jar;
import de.mn77.spec.csv.CSV_TableFile;
import java.io.File;
import java.io.IOException;

public abstract class A_HintFile {
    private static final String[] defaultJarCalls = new String[]{"/jar/hints/", "calls", "csv"};
    private static final String[] defaultJarTypes = new String[]{"/jar/hints/", "types", "csv"};
    private final String[] jarFile;
    private File fileTarget = null;

    public A_HintFile(TYPE type) {
        this.jarFile = type == TYPE.CALLS ? defaultJarCalls : defaultJarTypes;
        this.clear();
    }

    public abstract void clear();

    public final void load() {
        this.clear();
        this.iLoad();
    }

    public final void save() throws Err_FileSys {
        this.cleanUp();
        CSV_TableFile csv = new CSV_TableFile(this.fileTarget);
        csv.write(this.getCSVTable());
    }

    public final void setFile(String target) {
        this.fileTarget = new File(target);
    }

    public final void show() {
        this.cleanUp();
        MOut.text(this.getCSVTable().toStringDebug());
    }

    protected abstract void cleanUp();

    protected abstract I_Table<String> getCSVTable();

    protected abstract boolean isEmpty();

    protected final void loadDefault() {
        if (this.fileTarget == null || this.isEmpty()) {
            this.iLoad();
        }
    }

    protected abstract void pAddLineFromCSV(I_Sequence<String> var1);

    private void iLoad() {
        try {
            File f = this.fileTarget;
            if (this.fileTarget == null) {
                this.fileTarget = f = Lib_Jar.getFileCopy(this.jarFile[0], this.jarFile[1], this.jarFile[2]);
            }
            if (!f.exists()) {
                return;
            }
            CSV_TableFile csv = new CSV_TableFile(f);
            I_Table<String> data = csv.get();
            for (I_Sequence i_Sequence : data) {
                this.pAddLineFromCSV(i_Sequence);
            }
        }
        catch (Err_FileSys | IOException e) {
            Err.show(e);
            return;
        }
    }

    public static enum TYPE {
        CALLS,
        TYPES;

    }
}

