/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Parser;

public abstract class A_VarManager<T extends I_Object> {
    private final A_VarManager<T> parent;
    private final ArrayList<String> vars_name = new ArrayList();
    private final ArrayList<String> vars_raw = new ArrayList();
    private final ArrayList<T> vars_T = new ArrayList();

    public A_VarManager(A_VarManager<T> parent) {
        this.parent = parent;
    }

    public int count() {
        return this.vars_name.size();
    }

    public T create(String name, DebugInfo debug, boolean definition) {
        char c_l2;
        T vo = this.iUse(name, false);
        if (!definition && vo != null) {
            return vo;
        }
        int len = name.length();
        char c_l1 = name.charAt(len - 1);
        if (c_l1 == '?' || c_l1 == '\u00bf') {
            --len;
        }
        if (len > 0 && (c_l2 = name.charAt(len - 1)) == '?') {
            --len;
        }
        String rawname = name.substring(0, len);
        char c0 = name.charAt(0);
        if (c0 >= 'A' && c0 <= 'Z') {
            if (name.length() - rawname.length() >= 2) {
                throw new ParseError("Invalid constant!", "Modifier ?? not allowed: " + name, debug);
            }
            if (name.length() != rawname.length() && name.charAt(name.length() - 1) == '\u00bf') {
                throw new ParseError("Invalid constant!", "Modifier \u00bf not allowed: " + name, debug);
            }
        }
        if (this.knowsRaw(rawname)) {
            if (name.equals(rawname)) {
                throw new ParseError("Name of variable already used in this type!", name, debug);
            }
            throw new ParseError("Raw name of variable already used in this type!", name, debug);
        }
        vo = this.pCreateNew(name);
        this.vars_name.add(name);
        this.vars_raw.add(rawname);
        this.vars_T.add(vo);
        return vo;
    }

    public void describe(CallRuntime cr, int depth) {
        for (I_Object t : this.vars_T) {
            t.describe(cr, depth);
        }
    }

    public void describe(int left) {
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + "Items:");
        if (!this.vars_T.isEmpty()) {
            for (I_Object t : this.vars_T) {
                MOut.text(String.valueOf(space) + t.toString());
            }
        } else {
            MOut.text(String.valueOf(space) + "  none");
        }
        MOut.text(String.valueOf(space) + "Parent:");
        if (this.parent == null) {
            MOut.text(String.valueOf(space) + "  none");
        } else {
            this.parent.describe(left + 1);
        }
    }

    public boolean knows(String name) {
        if (this.vars_name.contains(name)) {
            return true;
        }
        return this.parent != null && this.parent.knows(name);
    }

    public boolean knowsRaw(String rawname) {
        if (this.vars_raw.contains(rawname)) {
            return true;
        }
        return this.parent != null && this.parent.knowsRaw(rawname);
    }

    public T use(String name) {
        return this.iUse(name, true);
    }

    protected abstract T pCreateNew(String var1);

    private T iUse(String name, boolean error_unknown) {
        if (this.parent == this) {
            Err.invalid(name);
        }
        if (this.vars_name.contains(name)) {
            int idx = this.vars_name.indexOf(name);
            return (T)((I_Object)this.vars_T.get(idx));
        }
        if (this.parent != null && this.parent.knows(name)) {
            return this.parent.use(name);
        }
        if (error_unknown) {
            throw Err.forbidden("Access to unknown variable: " + name);
        }
        return null;
    }
}

