/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import de.mn77.base.error.Err;
import java.io.File;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.filesys.A_FileSys;
import org.jmo_lang.object.filesys.JMo_Dir;
import org.jmo_lang.object.filesys.JMo_File;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Output;

public class JMo_Path
extends A_Object
implements I_Object {
    private Call par;
    private File file = null;

    public JMo_Path(Call par) {
        Err.ifNull(par);
        this.par = par;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.par != null) {
            I_Object filename = cr.execInit(this.par, null);
            if (!((filename = Lib_Convert.getValue(cr, filename)) instanceof Str)) {
                throw Err.invalid(filename.toDebug(cr));
            }
            String filestr = ((Str)filename).getValue();
            this.file = new File(filestr);
            this.par = null;
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "do": 
            case "get": {
                A_FileSys f1 = this.file.isDirectory() ? new JMo_Dir(this.file) : new JMo_File(this.file);
                return A_Object.stdResult(f1);
            }
            case "getFile": {
                JMo_File f2 = new JMo_File(this.file);
                return A_Object.stdResult(f2);
            }
            case "getDir": {
                JMo_Dir f3 = new JMo_Dir(this.file);
                return A_Object.stdResult(f3);
            }
        }
        return null;
    }

    @Override
    public Integer compareTo2(I_Object o) {
        if (o instanceof JMo_Path) {
            return this.file.compareTo(((JMo_Path)o).file);
        }
        return null;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        if (this.file != null) {
            return this.toString();
        }
        String p = Lib_Output.toDebug(cr, this.par);
        if (p.length() != 0) {
            p = "(" + p + ")";
        }
        return "Path" + p;
    }

    @Override
    public String toString() {
        return "Path(" + this.file.toString() + ")";
    }
}

