/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.Lib_String;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Type;

public abstract class A_Number
extends A_Atomic {
    @Override
    protected final ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "+": 
            case "add": {
                return A_Object.stdResult(this.ar(cr, NOP1.ADD, true));
            }
            case "-": 
            case "sub": {
                return A_Object.stdResult(this.ar(cr, NOP1.SUB, new boolean[0]));
            }
            case "*": 
            case "mul": {
                return A_Object.stdResult(this.ar(cr, NOP1.MUL, true));
            }
            case "/": 
            case "div": {
                return A_Object.stdResult(this.ar(cr, NOP1.DIV, new boolean[0]));
            }
            case "%": 
            case "mod": {
                return A_Object.stdResult(this.ar(cr, NOP1.MOD, new boolean[0]));
            }
            case "log": {
                return A_Object.stdResult(this.ar(cr, NOP1.LOG, new boolean[0]));
            }
            case "++": 
            case "inc": {
                return A_Object.stdResult(this.ar(cr, NOP01.INC));
            }
            case "--": 
            case "dec": {
                return A_Object.stdResult(this.ar(cr, NOP01.DEC));
            }
            case "~": 
            case "neg": {
                return A_Object.stdResult(this.ar(cr, NOP0.NEG));
            }
            case "abs": {
                return A_Object.stdResult(this.ar(cr, NOP0.ABS));
            }
            case "**": 
            case "pow": {
                return A_Object.stdResult(this.ar(cr, NOP01.POW));
            }
            case "//": 
            case "sqrt": {
                return A_Object.stdResult(this.ar(cr, NOP01.SQR));
            }
            case "format": {
                return A_Object.stdResult(this.format(cr));
            }
            case "limit": {
                return A_Object.stdResult(this.limit(cr));
            }
        }
        return this.call4(cr, method);
    }

    protected abstract ObjectCallResult call4(CallRuntime var1, String var2);

    protected abstract A_Number number_op(CallRuntime var1, NOP0 var2);

    protected abstract A_Number number_op(CallRuntime var1, NOP01 var2, I_Object[] var3);

    protected abstract A_Number number_op(CallRuntime var1, NOP1 var2, A_Number var3);

    private final I_AtomicValue number_opStr(CallRuntime cr, NOP1 op, A_Atomic p) {
        String par = Lib_Convert.getStringValue(cr, p);
        if (op == NOP1.ADD) {
            return new Str(this.getValue() + par);
        }
        if (op == NOP1.MUL) {
            if (this.getValue() instanceof Double || this.getValue() instanceof Float) {
                throw new CodeError(cr, "Wrong Type to multiply a Char or String", "Got " + Lib_Type.getName(this) + ", please use Int");
            }
            String s = Lib_String.sequence(par, ((Number)this.getValue()).longValue());
            return new Str(s);
        }
        throw new CodeError(cr, "Unknown Type or Function", this.getValue() + " " + (Object)((Object)op) + " " + Lib_Type.getName(p));
    }

    private I_AtomicValue ar(CallRuntime cr, NOP0 op) {
        cr.pars(this.getClass());
        return this.number_op(cr, op);
    }

    private I_AtomicValue ar(CallRuntime cr, NOP01 op) {
        I_Object[] pars = cr.parsFlex(null, this, 0, 1);
        return this.number_op(cr, op, pars);
    }

    private I_AtomicValue ar(CallRuntime cr, NOP1 op, boolean ... strPossible) {
        if (strPossible.length > 0 && strPossible[0]) {
            A_Atomic para = (A_Atomic)cr.pars(this.getClass(), this, A_Atomic.class)[0];
            if (para instanceof A_Number) {
                return this.number_op(cr, op, (A_Number)para);
            }
            if (para instanceof Bool) {
                return this.number_op(cr, op, new Int(Lib_Convert.getIntValue(cr, para)));
            }
            return this.number_opStr(cr, op, para);
        }
        A_Number parn = (A_Number)cr.pars(null, this, A_Number.class)[0];
        return this.number_op(cr, op, parn);
    }

    private Str format(CallRuntime cr) {
        Str o = (Str)cr.pars(Str.class, this, Str.class)[0];
        String format = o.getValue();
        String number = this.getValue().toString();
        String result = "";
        int nPos = number.length() - 1;
        int fPos = format.length() - 1;
        while (fPos >= 0) {
            char f = format.charAt(fPos);
            if (fPos > 0 && format.charAt(fPos - 1) == '~') {
                result = String.valueOf(f) + result;
                --fPos;
            } else {
                switch (f) {
                    case '0': {
                        result = nPos >= 0 ? String.valueOf(number.charAt(nPos)) + result : "0" + result;
                        --nPos;
                        break;
                    }
                    case '#': {
                        result = nPos >= 0 ? String.valueOf(number.charAt(nPos)) + result : " " + result;
                        --nPos;
                        break;
                    }
                    case '?': {
                        if (nPos >= 0) {
                            result = String.valueOf(number.charAt(nPos)) + result;
                        }
                        --nPos;
                        break;
                    }
                    default: {
                        result = String.valueOf(f) + result;
                    }
                }
            }
            --fPos;
        }
        if (nPos >= 0) {
            result = String.valueOf(number.substring(0, nPos + 1)) + result;
        }
        return new Str(result);
    }

    private A_Number limit(CallRuntime cr) {
        double max;
        Class[] classArray = new Class[]{A_Number.class, A_Number.class};
        I_Object[] pars = cr.pars(null, this, classArray);
        double min = Lib_Convert.getDoubleValue(cr, pars[0]);
        if (min > (max = Lib_Convert.getDoubleValue(cr, pars[1]))) {
            throw new ExecError(cr, "Min. is greater than max.!", "Min.: " + min + "  Max.: " + max);
        }
        double d = ((Number)this.getValue()).doubleValue();
        if (d > max) {
            d = max;
        }
        if (d < min) {
            d = min;
        }
        return (A_Number)Lib_AtomConv.convert(cr, this.getClass(), (I_Object)new Dec(d));
    }

    protected static enum NOP0 {
        NEG,
        ABS;

    }

    protected static enum NOP01 {
        INC,
        DEC,
        POW,
        SQR;

    }

    protected static enum NOP1 {
        ADD,
        SUB,
        MUL,
        DIV,
        MOD,
        LOG;

    }
}

